/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
//		Expression trees
include	backend;
include	types;
include	file;
include	hash;
include	scanner;
include	ptree;
include	symtab;
include	errmsg;
include	sbuffer;
include	target;
include	value;
include	gencode;
include	real;
include	xtree;

bcall_x:	public	type	inherit	tree_p	{
	public:

	args:		* tree_p;
	offset:		fileOffset;

display:	dynamic	(indent: int) =
	{
	if	(args)
		args display(indent + INDENT_AMOUNT);
	super display(indent);
	}

computeBenefits:	dynamic	(nesting: int) =
	{
	if	(args)
		args computeBenefits(nesting);
	}

sethiUllman:	dynamic	() signedByte =
	{
	if	(args)
		args sethiUllman();
	}

checkForNoEffect:	dynamic	() ref tree_p =
	{
	return self;
	}

hasSideEffects:	dynamic	() boolean =
	{
	return TRUE;
	}

/*
	This function examines a call tree after it has been type checked,
	Any array slice arguments are re-processed according to whether 
	the call is a remote or a local call.
 */
processDescriptors:	(s: ref scope_s) ref tree_p =
	{
	if	(args == 0)
		return self;		// no args, no descriptors

	a:	ref tree_p;
	ar:	ref argument_x;

	a = args;
	if	(a->operator == O_ARG){
		while	(a->operator == O_ARG){
			ar = ref argument_x(a);
			ar->left = convertDescriptors(s, ar->left);
			if	(ar->right == 0)
				break;
			if	(ar->right->operator != O_ARG)
				ar->right = convertDescriptors(s, ar->right);
			a = ar->right;
			}
		}
	else
		args = convertDescriptors(s, args);
	return self;
	}

	};

methodCall_x:	public	type	inherit	bcall_x	{
	public:

	objectRef:	* tree_p;
	name:		ref identifier;

create:	factory	(l: ref tree_p, id: ref identifier,
				r: ref tree_p,
				o: fileOffset) ref methodCall_x =
	{
	return new methodCall_x[ O_MCALL, r, o, l, id ];
	}

createKnown:	factory	(l: ref tree_p, m: ref symbol_s,
				r: ref tree_p,
				o: fileOffset,
				t: ref type_s, 
				directCall: boolean,
				s: ref scope_s) ref tree_p =
	{
	self = new methodCall_x[ O_MCALL, r, o, l, m->name ];
	return constructMethodCall(m, directCall, t, s);
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf(" %S\n", name spelling());
	if	(objectRef)
		objectRef display(indent + INDENT_AMOUNT);
	}

computeBenefits:	dynamic	(nesting: int) =
	{
	if	(objectRef)
		objectRef computeBenefits(nesting);
	super computeBenefits(nesting);
	}

assignTypes:	dynamic	(s: ref scope_s, boolean) ref tree_p =
	{
	directCall:	boolean;

	if	(dtype)
		return self;

		// calls to super should not be dynamic, they know where to
		// go.

	if	(objectRef->operator == O_SUPER)
		directCall = TRUE;
	else
		directCall = FALSE;
	if	(objectRef)
		objectRef = objectRef assignTypes(s, TRUE);
	if	(args)
		args = args assignTypes(s, TRUE);
	if	(objectRef == 0 || objectRef->operator == O_ERROR)
		return ErrorTree;
	CurrentContext.offset = offset;
	if	(objectRef->operator == O_TYPE)
		return factoryCall(s);

	t:		ref type_s;

	t = objectRef->dtype;
	if	(objectRef->operator == O_SCONST){
		if	(t == IntType){
			error(ErrSconstNeedsType);
			return ErrorTree;
			}
		objectRef = objectRef sconstTemp(s, t);
		}
	if	(t->topType == T_REF)
		t = t targetOf();
	else	{
		objectRef = objectRef takeAddress(t);

			// Since we know the real type of the object, we
			// know where to go.

		directCall = TRUE;
		}
	if	(t->topType == T_ERROR)
		return ErrorTree;
	if	(t->topType != T_STRUCT){
		error(ErrBadStructOp);
		return ErrorTree;
		}

	m:		* symbol_s;

	m = t lookupMember(name, s);
	if	(m == 0){
		error(ErrUndefSym, name spelling());
		return ErrorTree;
		}
	return constructMethodCall(m, directCall, t, s);
	}

constructMethodCall:	(m: ref symbol_s, directCall: boolean,
					t: ref type_s, 
					s: ref scope_s) ref tree_p =
	{
	ft:	ref function_z;

	ft = ref function_z(m->dtype);
	if	(ft == 0 ||
		 ft->topType == T_ERROR)
		return ErrorTree;
	if	(ft->topType != T_FUNC){
		error(ErrNotFunc);
		return ErrorTree;
		}
	if	(m->qualifier & DQ_FACTORY){
		error(ErrBadFactory, m->name spelling());
		return ErrorTree;
		}

	x:		ref tree_p;
	obj:		ref tree_p;

	obj = objectRef;
	if	(m->qualifier & DQ_DYNAMIC){
		if	(directCall)
			objectRef = iden_x createKnown(O_ID, ft, m,
							m->currentValue, 0);
		else
			objectRef = dynamic_x create(O_DYNAMIC, ft, m, 
							t dynamicOffset());
		}
	else if	(m->storageClass == SC_REMOTE ||
		 ft->callingConvention == FC_GATE){
		if	(!obj->dtype isFarPointer()){
			error(ErrBadStructOp);
			return ErrorTree;
			}
		return remoteCall_x create(obj, ft, m, args, s, offset);
		}
	else
		objectRef = iden_x createKnown(O_ID, ft, m, m->currentValue, 0);
	dtype = ft returnTypeOf();
	CurrentContext.offset = offset;
	args = ft checkArguments(s, args, name);
	if	(args == 0)
		args = obj;
	else
		args = Func argument(obj, args, offset);
	return processDescriptors(s);
	}

fold:	dynamic	() ref tree_p =
	{
	if	(args)
		args = args fold();
	objectRef = objectRef fold();
	return self;
	}

sethiUllman:	dynamic	() signedByte =
	{
	super sethiUllman();
	objectRef sethiUllman();
	return regneeds(self);
	}

factoryCall:	(s: ref scope_s) ref tree_p =
	{
	sym:		ref symbol_s;
	func:		ref tree_p;

	sym = objectRef lookupMember(name, s);
	if	(sym == 0){
		error(ErrUndefSym, name spelling());
		return ErrorTree;
		}
	if	(sym->qualifier & DQ_FACTORY == 0){
		error(ErrNotFactory, name spelling());
		return ErrorTree;
		}
	func = iden_x createKnown(O_ID, sym->dtype getType(), sym,
							sym->currentValue, 0);

	fc:	ref staticCall_x;

	fc = ref staticCall_x(Func staticCall(func, args, offset));
	return fc checkFunctionCall(s, name, sym);
	}

	};

staticCall_x:	public	type	inherit	bcall_x	{
	public:

	func:		* tree_p;

constructor:	(l: ref tree_p, r: ref tree_p, o: fileOffset) =
	{
	super constructor(O_SCALL);
	func = l;
	args = r;
	offset = o;
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("\n");
	if	(func)
		func display(indent + INDENT_AMOUNT);
	}

fold:	dynamic	() ref tree_p =
	{
	if	(args)
		args = args fold();
	if	(func)
		func = func fold();
	return self;
	}

computeBenefits:	dynamic	(nesting: int) =
	{
	if	(func)
		func computeBenefits(nesting);
	super computeBenefits(nesting);
	}

sethiUllman:	dynamic	() signedByte =
	{
	super sethiUllman();
	if	(func)
		func sethiUllman();
	return regneeds(self);
	}

assignTypes:	dynamic	(s: ref scope_s, boolean) ref tree_p =
	{
	id:			ref identifier;
	sym:			ref symbol_s;
	methodReferenceOk:	boolean;

	if	(dtype)
		return self;
	if	(args)
		args = args assignTypes(s, TRUE);
	if	(func){
		if	(func->operator == O_DOT ||
			 func->operator == O_ARROW)
			methodReferenceOk = FALSE;
		else
			methodReferenceOk = TRUE;
		func = func assignTypes(s, TRUE);
		}
	else
		return ErrorTree;
	if	(func->operator == O_ERROR)
		return func;
	CurrentContext.offset = offset;
	if	(func->operator == O_TYPE){
		if	(args == 0){
			error(ErrBadCast);
			return ErrorTree;
			}
		c:	ref cast_x;

		args = args convertArgsToCommas();
		c = cast_x createKnown(ref type_x(func)->ttype, 
								args, offset);
		return c checkCast(TRUE);
		}
	if	(func->operator == O_ID){
		id = ref iden_x(func)->name;
		sym = ref iden_x(func)->symbol;
		if	(sym->qualifier & DQ_MEMBERFUNC){
			x:	ref tree_p;

			if	(!methodReferenceOk){
				error(ErrBadMethodOp);
				return ErrorTree;
				}
			if	(sym->qualifier & DQ_FACTORY)
				x = type_x create(s getEnclosingType(), 0);
			else
				x = Func auto(Project.selfSymbol);
			x = methodCall_x createKnown(x, sym, args, 
					offset, s getEnclosingType(), FALSE, s);
			return x;
			}
		}
	else	{
		id = 0;
		sym = 0;
		}
	return checkFunctionCall(s, id, sym);
	}

checkFunctionCall:	(s: ref scope_s, id: ref identifier, 
					sym: ref symbol_s) ref tree_p =
	{
	t:	ref type_s;

	t = func->dtype;
	if	(t->topType == T_REF){
		t = t targetOf();
		func = binop(O_IND, t, func, 0);
		}
	if	(t->topType != T_FUNC){
		error(ErrNotFunc);
		return ErrorTree;
		}
	if	(args && args->operator == O_ERROR)
		return args;
	dtype = t returnTypeOf();

	ft:	* function_z;

	ft = ref function_z(t);
	CurrentContext.offset = offset;
	dtype = ft returnTypeOf();
	x:	ref tree_p;
	if	(id &&
		 sym->storageClass == SC_INTRINSIC){
		if	(sym->initBase != 4)
			args = ft checkArguments(s, args, id);
		return convertToIntrinsicOperation(sym->initBase, self);
		}
	args = ft checkArguments(s, args, id);
	return processDescriptors(s);
	}

	};

argument_x:	public	type	inherit	tree_p	{
	public:

	left:		* tree_p;
	right:		* tree_p;
	offset:		fileOffset;

constructor:	(l: ref tree_p, r: ref tree_p, o: fileOffset) =
	{
	super constructor(O_ARG);
	left = l;
	right = r;
	offset = o;
	}

display:	dynamic	(indent: int) =
	{
	for	(;;){
		if	(left)
			left display(indent + INDENT_AMOUNT);
		super display(indent);
		printf("\n");
		if	(right){
			if	(right->operator == O_ARG){
				self = ref argument_x(right);
				continue;
				}
			else
				right display(indent + INDENT_AMOUNT);
			break;
			}
		else
			break;
		}
	}

fold:	dynamic	() ref tree_p =
	{
	x:		ref tree_p;

	x = self;
	for	(;;){
		if	(left)
			left = left fold();
		if	(right &&
			 right->operator == O_ARG)
			self = ref argument_x(right);
		else
			break;
		}
	if	(right)
		right = right fold();
	return x;
	}

computeBenefits:	dynamic	(nesting: int) =
	{
	if	(left)
		left computeBenefits(nesting);
	if	(right)
		right computeBenefits(nesting);
	}

sethiUllman:	dynamic	() signedByte =
	{
	if	(right)
		right sethiUllman();
	if	(left)
		left sethiUllman();
	return 0;
	}
/*
	This function converts O_ARG argument nodes to O_SEQ comma operator
	nodes.  This is necessary in casts that looked like function calls.
 */
convertArgsToCommas:	dynamic	() ref tree_p =
	{
	left = left convertArgsToCommas();
	right = right convertArgsToCommas();
	return binop(O_SEQ, right->dtype, left, right);
	}

makeRightAssociative:	dynamic	() ref tree_p =
	{
	list2:	ref argument_x;

	for	(;;){
		list2 = self;
		self = ref argument_x(left);
		if	(operator != O_ARG)
			break;
		list2->left = right;
		right = list2;
		}
	return list2;
	}

assignTypes:	dynamic	(s: ref scope_s, boolean) ref tree_p =
	{
	errorSeen:	boolean;
	x:		ref tree_p;

	if	(dtype)
		return self;
	dtype = IntType;
	errorSeen = FALSE;
	x = self;
	for	(;;){
		if	(left){
			left = left assignTypes(s, TRUE);
			if	(left->operator == O_ERROR)
				errorSeen = TRUE;
			}
		if	(right && right->operator == O_ARG)
			self = ref argument_x(right);
		else
			break;
		}
	if	(right){
		right = right assignTypes(s, TRUE);
		if	(right->operator == O_ERROR)
			return right;
		}
	if	(errorSeen)
		return ErrorTree;
	return x;
	}

checkArgument:	dynamic	(s: ref scope_s, p: ref parameter_s, pnum: int, 
					id: ref identifier) ref tree_p =
	{
	CurrentContext.offset = offset;
	left = left checkArgument(s, p, pnum, id);
	if	(p)
		p = p->next;
	if	(right)
		right = right checkArgument(s, p, pnum + 1, id);
	return self;
	}

	};

remoteCall_x:	public	type	inherit bcall_x {
	public:

	objectRef:	ref tree_p;
	symbol:		ref symbol_s;
	frameSize:	ref tree_p;
	retnAddr:	ref tree_p;
	retnLen:	ref tree_p;

create:	factory	(obj: ref tree_p, d: ref function_z, m: ref symbol_s, 
			a: ref tree_p, s: ref scope_s,
					offset: fileOffset) ref tree_p =
	{
	self = new remoteCall_x[ O_RCALL, a, offset, obj, m, 0, 0, 0 ];
	dtype = d returnTypeOf();
	CurrentContext.offset = offset;
	args = d checkArguments(s, args, m->name);
	return processDescriptors(s);
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("\n");
	if	(retnAddr)
		retnAddr display(indent + INDENT_AMOUNT);
	if	(retnLen)
		retnLen display(indent + INDENT_AMOUNT);
	}

declareReturn:	(addr: ref tree_p, len: ref tree_p) =
	{
	retnAddr = addr;
	retnLen = len;
	}

fold:	dynamic	() ref tree_p =
	{
	if	(args)
		args = args fold();
	if	(retnAddr)
		retnAddr = retnAddr fold();
	if	(retnLen)
		retnLen = retnLen fold();
	objectRef = objectRef fold();
	return self;
	}

sethiUllman:	dynamic	() signedByte =
	{
	super sethiUllman();
	objectRef sethiUllman();
	return regneeds(self);
	}

processDescriptors: (s: ref scope_s) ref tree_p =
	{
	if	(args == 0)
		return self;		// no args, no descriptors

	a:	ref tree_p;
	ar:	ref argument_x;
	scode:	ref tree_p;

	scode = 0;
	a = args;
	CallForm = symbol->storageClass;
	if	(a->operator == O_ARG){
		while	(a->operator == O_ARG){
			ar = ref argument_x(a);
			ar->left = copyDescriptors(s, ar->left, &scode);
			if	(ar->right == 0)
				break;
			if	(ar->right->operator != O_ARG)
				ar->right = copyDescriptors(s, ar->right, 
								&scode);
			a = ar->right;
			}
		}
	else
		args = copyDescriptors(s, args, &scode);

	u:	ref tree_p;
	v:	ref tree_p;
	sym:	ref symbol_s;
	d:	ref type_s;

	if	(scode == 0)
		return self;
	d = number_z create(T_UNSIGNED, NO_RANGE, INTBITS);
	sym = s unnamedLocal(d);
	frameSize = Func auto(sym);
	v = iden_x createKnown(O_REG, d, 0, 0, ESP);
	u = Func auto(sym);
	u = binop(O_ASG, d, u, v);
	v = binop(O_SEQ, dtype, scode, self);
	v = binop(O_SEQ, dtype, u, v);
	return v;
	}

	};

dynamic_x:	public	type	inherit	tree_p {
	public:

	symbol:		ref symbol_s;
	dynamicOffset:	addr_t;

create:	factory	(op: operators, t: ref type_s, m: ref symbol_s, 
					doff: addr_t) ref dynamic_x =
	{
	self = new dynamic_x[ op, m, doff ];
	dtype = t;
	return self;
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf(" %S %x\n", symbol->name spelling(), dynamicOffset);
	}

	};

ellipsis_x:	public	type	inherit	tree_p	{
	public:

create:	factory	() ref ellipsis_x =
	{
	self = alloc(sizeof ellipsis_x);
	self = [ O_ELLIPSIS ];
	return self;
	}

display:	dynamic	(indent: int) =
	{
	super display(indent);
	printf("\n");
	}

assignTypes:	dynamic	(ref scope_s, boolean) ref tree_p =
	{
	if	(Project.varArgsType == 0){
		error(ErrNoVarArgs);
		return ErrorTree;
		}
	dtype = Project.varArgsType;
	return self;
	}

	};

CallForm:	int;

copyDescriptors:	(sc: ref scope_s, arg: ref tree_p, 
					scodep: ref ref tree_p) ref tree_p =
	{
	if	(arg->dtype->topType != T_DESCRIPTOR)
		return arg;

	d:		ref type_s;
	sym:		ref symbol_s;
	copyAreaPtr:		ref symbol_s;
	dest, init:	ref tree_p;
	dest2:		ref tos_x;
	cpylen, dlen:	ref tree_p;
	cdest:		ref tree_p;
	src:		ref tree_p;
	t:		ref tree_p;
	v:		ref tree_p;
	u:		ref tree_p;

	d = number_z create(T_UNSIGNED, NO_RANGE, INTBITS);
	copyAreaPtr = sc unnamedLocal(d);

		// First, reserve space for the described data

	if	(arg->operator == O_CAST){
		src = ref cast_x(arg)->opnd;
		if	(src->dtype->topType != T_ARRAY){
			error(ErrUnfinished);
			return ErrorTree;
			}
		x:	addr_t;

		x = src->dtype sizeOf();
		v = iden_x createKnown(O_REG, d, 0, 0, ESP);
		t = binop(O_SBA, d, v, Func icon((x + 3) & ~3, INTBITS));
		src = src promoteArrays();
		cpylen = Func icon(x, INTBITS);
		dlen = Func icon(x, INTBITS);
		}
	else	{
		rlen:	ref tree_p;
		dd:	ref type_s;
		x:	addr_t;
		m:	ref tree_p;

		t = 0;
		if	(arg->operator == O_SLICE){
			if	(ref slice_x(arg)->left){
				error(ErrUnfinished);
				return ErrorTree;
				}
			dlen = ref slice_x(arg)->right;
			dd = arg->dtype elementOf();
			x = dd sizeOf();
			if	(dlen hasSimpleShape()){
				rlen = dlen dup(0);
				if	(x > 1){
					m = Func icon(x, INTBITS);
					rlen = binop(O_MUL, d, rlen, m);
					}
				cpylen = rlen dup(0);
				}
			else	{
				sym = sc unnamedLocal(d);
				u = Func auto(sym);
				t = binop(O_ASG, d, u, dlen);
				cpylen = Func auto(sym);
				rlen = Func auto(sym);
				if	(x > 1){
					m = Func icon(x, INTBITS);
					rlen = binop(O_MUL, d, rlen, m);
					m = Func icon(x, INTBITS);
					cpylen = binop(O_MUL, d, cpylen, m);
					}
				}
			src = ref slice_x(arg)->arrayRef promoteArrays();
			}
		else	{
			dlen = structRef(arg, DescrBoundOffset * BYTEBITS, d);
			dd = arg->dtype elementOf();
			x = dd sizeOf();
			if	(x > 1){
				m = Func icon(x, INTBITS);
				rlen = binop(O_MUL, d, rlen, m);
				}
			if	(arg hasSimpleShape()){
				rlen = dlen dup(0);
				if	(x > 1){
					m = Func icon(x, INTBITS);
					rlen = binop(O_MUL, d, rlen, m);
					}
				cpylen = rlen dup(0);
				}
			else	{
				sym = sc unnamedLocal(d);
				u = Func auto(sym);
				t = binop(O_ASG, d, u, dlen);
				cpylen = Func auto(sym);
				rlen = Func auto(sym);
				if	(x > 1){
					m = Func icon(x, INTBITS);
					rlen = binop(O_MUL, d, rlen, m);
					m = Func icon(x, INTBITS);
					cpylen = binop(O_MUL, d, cpylen, m);
					}
				}
			src = structRef(arg, 0, d);
			}
		v = iden_x createKnown(O_REG, d, 0, 0, ESP);
		v = binop(O_SBA, d, v, rlen);
		if	(t)
			t = binop(O_SEQ, d, t, v);
		else
			t = v;
		v = iden_x createKnown(O_REG, d, 0, 0, ESP);
		v = binop(O_ANA, d, v, Func icon(~3, INTBITS));
		t = binop(O_SEQ, d, t, v);
		}

		// Now link in the code so far, then remember the location
		// of the copy area

	if	(*scodep)
		t = binop(O_SEQ, d, *scodep, t);
	cdest = Func auto(copyAreaPtr);
	v = iden_x createKnown(O_REG, d, 0, 0, ESP);
	v = binop(O_ASG, d, cdest, v);
	t = binop(O_SEQ, d, t, v);
	v = Func argument(src, cpylen, 0);
	cdest = Func auto(copyAreaPtr);
	v = Func argument(cdest, v, 0);
	v = Func staticCall(0, v, 0);
	v->operator = O_MCOPY;
	v->dtype = d;
	t = binop(O_SEQ, d, t, v);
	*scodep = t;

	v = iden_x createKnown(O_REG, d, 0, 0, ESP);
	cdest = Func auto(copyAreaPtr);
	cdest = binop(O_SUB, d, cdest, v);
	dest = tos_x create(d);
	init = binop(O_ASG, d, dest, cdest);
	dest2 = tos_x create(d);
	dest2->adjust = DescrMaxBoundOffset;
	dest = binop(O_ASG, d, dest2, dlen);
	if	(CallForm == SC_REMOTE){
		d:	ref type_s;

		d = array_z create(NO_RANGE, 2, IntType);
		init = concatOps(init, dest);
		dest = allocTos_x create(d);
		}
	else	{
		dest2 = tos_x create(d);
		dest2->adjust = DescrBoundOffset;
		dest = binop(O_ASG, d, dest2, dest);
		init = concatOps(init, dest);
		dest = allocTos_x create(arg->dtype);
		}
	init = concatOps(dest, init);
	dest = tos_x create(arg->dtype);
	t = concatOps(init, dest);
	return t;
	}

convertDescriptors:	(s: ref scope_s, arg: ref tree_p) ref tree_p =
	{
	if	(arg->dtype->topType != T_DESCRIPTOR)
		return arg;

	if	(arg->operator == O_CAST){
		c:	ref cast_x;

		c = ref cast_x(arg);
		return c->opnd descriptorArgument(s, c->dtype);
		}

	d:		ref type_s;
	sym:		ref symbol_s;
	dest, init:	ref tree_p;
	dest2:		ref tos_x;
	src:		ref tree_p;

	d = number_z create(T_UNSIGNED, NO_RANGE, INTBITS);

	t, prefix, suffix, mlen, rlen:	ref tree_p;

	prefix = 0;
	if	(arg->operator == O_SLICE){
		if	(ref slice_x(arg)->left){
			error(ErrUnfinished);
			return ErrorTree;
			}
		mlen = rlen = ref slice_x(arg)->right;
		src = ref slice_x(arg)->arrayRef;
		src = src promoteArrays();
		}
	else if	(arg->operator == O_SCALL ||
		 arg->operator == O_MCALL){
		sym:	ref symbol_s;
		x, y:	ref tree_p;

		sym = s unnamedLocal(arg->dtype);
		x = Func auto(sym);
		rlen = structRef(x, DescrBoundOffset * BYTEBITS, d);
		mlen = structRef(x, DescrMaxBoundOffset * BYTEBITS, d);
		src = structRef(x, 0, d);
		x = Func binary(O_ASG, x, arg, 0);
		prefix = x assignTypes(s, FALSE);
		}
	else	{
		rlen = structRef(arg, DescrBoundOffset * BYTEBITS, d);
		mlen = structRef(arg, DescrMaxBoundOffset * BYTEBITS, d);
		src = structRef(arg, 0, d);
		}

		// Now link in the code so far, then remember the location
		// of the copy area

	t = src dup(-1);
	t = t removeNoEffectCode();
	prefix = concatOps(prefix, t);
	t = concatOps(prefix, allocTos_x create(arg->dtype));
	dest = tos_x create(d);
	t = concatOps(t, binop(O_ASG, d, dest, src));
	dest2 = tos_x create(d);
	dest2->adjust = DescrMaxBoundOffset;
	dest = binop(O_ASG, d, dest2, mlen);
	if	(mlen == rlen)
		rlen = dest;
	else
		t = concatOps(t, dest);
	dest2 = tos_x create(d);
	dest2->adjust = DescrBoundOffset;
	t = concatOps(t, binop(O_ASG, d, dest2, rlen));
	suffix = src dup(+1);
	suffix = suffix removeNoEffectCode();
	t = concatOps(t, suffix);
	dest = tos_x create(arg->dtype);
	t = binop(O_SEQ, dest->dtype, t, dest);
	return t;
	}
