#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define NO_LEAK 0

template <class T> class Q {
private:
    int hd, tl, cnt, max;
    T   *a;
public:
    Q(int n=10) { hd = tl = 0; cnt = 0; max = n; a = new T [n]; }
    ~Q() { delete [] a; }
    int add(T);
    int del(T&);
};

template <class T> int Q<T>::add(T t)
{
    if (cnt == max)
        return 0;
#if NO_LEAK
    a[ tl ].T::~T();
#endif
    a[ tl++ ] = t;
    if (tl == max)
        tl = 0;
    cnt++;
    return 1;
}

template <class T> int Q<T>::del(T& t)
{
    if (!cnt)
        return 0;
#if NO_LEAK
    t.T::~T();
#endif
    t = a[ hd++ ];
    if (hd == max)
        hd = 0;
    cnt--;
    return 1;
}


class MemEater {
private:
    char *junk;
public:
    MemEater() { printf("():allocating\n"); junk = new char [ 10000 ];
        if (!junk) exit(1); }
    ~MemEater() { printf("deleting\n"); delete junk; }
    MemEater &operator=(MemEater &me)
        { printf("op=:allocating\n"); junk = new char [ 10000 ]; 
        if (!junk) exit(2); memcpy(junk, me.junk, 10000); return *this; }
    MemEater(MemEater &me)
        { printf("copying..."); *this=me; }
        
};

Q<MemEater> qme(10);

void main(void)
{
    MemEater m;

    for (int i = 0; i < 320; i++) {
        printf("i = %d\n", i);
        printf("adding\n");
        qme.add(m);
        printf("getting\n");
        qme.del(m);
    }
}
