/** 
 ** CLIPPING.H 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#ifndef _CLIPPING_H_
#define _CLIPPING_H_

#define INSIDE		0
#define CLIPPED		1
#define OUTSIDE		2

#ifndef WHEN_CLIPPED
#define WHEN_CLIPPED
#endif

#ifndef WHEN_OUTSIDE
#define WHEN_OUTSIDE	return
#endif

#define CLIPDOT(c,xx,yy) {						\
    if((xx > c->gc_xcliphi) || (xx < c->gc_xcliplo)) { WHEN_OUTSIDE; }  \
    if((yy > c->gc_ycliphi) || (yy < c->gc_ycliplo)) { WHEN_OUTSIDE; }  \
}

#define CLIPDOTTOCONTEXT(c,xx,yy) {					\
    if((xx > c->gc_xmax) || (xx < 0)) { WHEN_OUTSIDE; }			\
    if((yy > c->gc_ymax) || (yy < 0)) { WHEN_OUTSIDE; }			\
}

#define CLIPHLINE(c,x1,x2,yy) {						\
    if(x1 > x2) EXCHG(x1,x2);						\
    if((x1 > c->gc_xcliphi) || (x2 < c->gc_xcliplo)) { WHEN_OUTSIDE; }  \
    if((yy > c->gc_ycliphi) || (yy < c->gc_ycliplo)) { WHEN_OUTSIDE; }  \
    if(x1 < c->gc_xcliplo) { x1 = c->gc_xcliplo; WHEN_CLIPPED; }	\
    if(x2 > c->gc_xcliphi) { x2 = c->gc_xcliphi; WHEN_CLIPPED; }	\
}

#define CLIPVLINE(c,xx,y1,y2) {						\
    if(y1 > y2) EXCHG(y1,y2);						\
    if((xx > c->gc_xcliphi) || (xx < c->gc_xcliplo)) { WHEN_OUTSIDE; }  \
    if((y1 > c->gc_ycliphi) || (y2 < c->gc_ycliplo)) { WHEN_OUTSIDE; }  \
    if(y1 < c->gc_ycliplo) { y1 = c->gc_ycliplo; WHEN_CLIPPED; }	\
    if(y2 > c->gc_ycliphi) { y2 = c->gc_ycliphi; WHEN_CLIPPED; }	\
}

#define CLIPBOXTEST(c,x1,y1,x2,y2) {					\
    if((x1 > c->gc_xcliphi) || (x2 < c->gc_xcliplo)) { WHEN_OUTSIDE; }  \
    if((y1 > c->gc_ycliphi) || (y2 < c->gc_ycliplo)) { WHEN_OUTSIDE; }  \
}

#define CLIPBOXSORTANDTEST(c,x1,y1,x2,y2) {				\
    if(x1 > x2) EXCHG(x1,x2);						\
    if(y1 > y2) EXCHG(y1,y2);						\
    CLIPBOXTEST(c,x1,y1,x2,y2);						\
}

#define CLIPBOX(c,x1,y1,x2,y2) {					\
    CLIPBOXSORTANDTEST(c,x1,y1,x2,y2);					\
    if(x1 < c->gc_xcliplo) { x1 = c->gc_xcliplo; WHEN_CLIPPED; }	\
    if(y1 < c->gc_ycliplo) { y1 = c->gc_ycliplo; WHEN_CLIPPED; }	\
    if(x2 > c->gc_xcliphi) { x2 = c->gc_xcliphi; WHEN_CLIPPED; }	\
    if(y2 > c->gc_ycliphi) { y2 = c->gc_ycliphi; WHEN_CLIPPED; }	\
}

#define CLIPSORTEDBOX(c,x1,y1,x2,y2) {					\
    CLIPBOXTEST(c,x1,y1,x2,y2);						\
    if(x1 < c->gc_xcliplo) { x1 = c->gc_xcliplo; WHEN_CLIPPED; }	\
    if(y1 < c->gc_ycliplo) { y1 = c->gc_ycliplo; WHEN_CLIPPED; }	\
    if(x2 > c->gc_xcliphi) { x2 = c->gc_xcliphi; WHEN_CLIPPED; }	\
    if(y2 > c->gc_ycliphi) { y2 = c->gc_ycliphi; WHEN_CLIPPED; }	\
}

#define CLIPBOXTOCONTEXT(c,x1,y1,x2,y2) {				\
    if(x1 > x2) EXCHG(x1,x2);						\
    if(y1 > y2) EXCHG(y1,y2);						\
    if((x1 > c->gc_xmax) || (x2 < 0)) { WHEN_OUTSIDE; }			\
    if((y1 > c->gc_ymax) || (y2 < 0)) { WHEN_OUTSIDE; }			\
    if(x1 < 0) { x1 = 0; WHEN_CLIPPED; }				\
    if(y1 < 0) { y1 = 0; WHEN_CLIPPED; }				\
    if(x2 > c->gc_xmax) { x2 = c->gc_xmax; WHEN_CLIPPED; }		\
    if(y2 > c->gc_ymax) { y2 = c->gc_ymax; WHEN_CLIPPED; }		\
}

#endif /* whole file */

