/**
 ** P4PIXRD.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p4.h"

int _GrP4ReadPixel(GC *cxt,long addr)
{
	pixptr p = P_ADDRESS(cxt,addr);
	int mask = 0x80 >> P_OFFSET(addr);
	int plane = 4;
	int pixel = 0;

	if(cxt->gc_onscreen) while(--plane >= 0) {
	    pixel <<= 1;
	    _SetVGAReadPlane(plane);
	    if(*p & mask) pixel |= 1;
	}
	else while(--plane >= 0) {
	    if(*p & mask) pixel |= 0x10;
	    p = (pixptr)((long)p + cxt->gc_planeoffset);
	    pixel >>= 1;
	}
	return(pixel);
}

