/**
 ** PGTEST.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/


#include <string.h>

#include <grx.h>
#include <mousex.h>
#include <stdio.h>
#include <stdlib.h>

int    Argc;
char **Argv;

#ifdef __TURBOC__
extern long clock(void);
#endif

#ifdef __GNUC__
extern long rawclock(void);
#define clock() rawclock()
#endif


void pgtest(void)
{
	long start,end;
	int  ii,ypos;
	char buff[2048];

	while(kbhit()) getkey();
	sprintf(buff,
	    "GRAPHICS MODE: width = %d, height = %d, colors = %d",
	    GrSizeX(),
	    GrSizeY(),
	    GrNumColors()
	);
	GrClearContext(0);
	GrTextXY(10,(GrSizeY() - 16) / 2,buff,GrWhite(),GrNOCOLOR);
	getkey();

	GrClearContext(0);
	start = clock();
	for(ii = 0; ii < 200; ii++) {
	    GrClearContext(ii & 255);
	}
	end = clock();
	sprintf(buff,
	    "Time to clear full screen 200 times: %.2f seconds",
	    (double)(end - start) * 0.055
	);
	GrClearContext(0);
	GrTextXY(10,(GrSizeY() - 16) / 2,buff,GrWhite(),GrNOCOLOR);
	getkey();

	GrClearContext(0);
	start = clock();
	for(ii = 0; ii < 2000; ii++) {
	    GrTextXY(0,0,
		"QUICK BROWN FOX JUMPS OVER THE LAZY DOG",
		ii % 3,
		ii % 23
	    );
	}
	end = clock();
	sprintf(buff,
	    "Time to draw text 2000 times in same page: %.2f seconds",
	    (double)(end - start) * 0.055
	);
	GrClearContext(0);
	GrTextXY(10,(GrSizeY() - 16) / 2,buff,GrWhite(),GrNOCOLOR);
	getkey();

	GrClearContext(0);
	ypos  = (GrScreenY()*GrScreenY() > 256*1024) ?
		    (256*1024 / GrScreenX()) - 8:
		    (64*1024  / GrScreenX()) - 8;
	start = clock();
	for(ii = 0; ii < 2000; ii++) {
	    GrTextXY(0,ypos,
		"QUICK BROWN FOX JUMPS OVER THE LAZY DOG",
		ii % 3,
		ii % 23
	    );
	}
	end = clock();
	sprintf(buff,
	    "Time to draw text 2000 times crossing pages: %.2f seconds",
	    (double)(end - start) * 0.055
	);
	GrClearContext(0);
	GrTextXY(10,(GrSizeY() - 16) / 2,buff,GrWhite(),GrNOCOLOR);
	getkey();
}

void main(int argc,char **argv)
{
	int x = 0;
	int y = 0;
	int c = 0;

	Argc = argc - 1;
	Argv = argv + 1;
	if((Argc >= 2) &&
	   (sscanf(Argv[0],"%d",&x) == 1) && (x >= 320) &&
	   (sscanf(Argv[1],"%d",&y) == 1) && (y >= 200)) {
	    Argc -= 2;
	    Argv += 2;
	    if((Argc > 0) && (sscanf(Argv[0],"%d",&c) == 1) && (c >= 2)) {
		Argc--;
		Argv++;
	    }
	}
	if(c >= 2)
	    GrSetMode(GR_width_height_color_graphics,x,y,c);
	else if((x >= 320) && (y >= 200))
	    GrSetMode(GR_width_height_graphics,x,y);
	else GrSetMode(GR_default_graphics);
	pgtest();
	GrSetMode(GR_default_text);
	exit(0);
}


