/* This is file locale.h */
/*
** Copyright (C) 1994 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _LOCALE_H_
#define _LOCALE_H_

#ifdef __cplusplus
extern "C" {
#endif

#define LC_COLLATE	0x01
#define LC_CTYPE	0x02
#define LC_MONETARY	0x04
#define LC_NUMERIC	0x08
#define LC_TIME		0x10
#define LC_ALL		0x1f

#ifndef NULL
#define NULL 0
#endif

struct lconv {
  char *currency_symbol;
  char *decimal_point;
  char *grouping;
  char *int_curr_symbol;
  char *mon_decimal_point;
  char *mon_grouping;
  char *negative_sign;
  char *positive_sign;
  char *thousands_sep;
  char frac_digits;
  char int_frac_digits;
  char n_cs_precedes;
  char n_sep_by_space;
  char n_sign_posn;
  char p_cs_precedes;
  char p_sep_by_space;
  char p_sign_posn;
};

struct lconv *localeconv(void);
char *setlocale(int category, const char *locale);

#ifdef __cplusplus
}
#endif

#endif
