#include <stdio.h>
#include <dos.h>
#include <go32.h>
#include <dpmi.h>

char *comma(u_long val)
{
  static char buf2[30];
  char buf1[30];
  int i, j;
  sprintf(buf1, "%12d", val);
  for (j=0, i=0; i<12; i++)
  {
    buf2[j] = buf1[i];
    j++;
    if (i == 11)
      break;
    if (i%3 == 2)
    {
      if (buf1[i] != ' ')
        buf2[j++] = ',';
      else
        buf2[j++] = ' ';
    }
  }
  buf2[j++] = 0;
  return buf2;
}

int main()
{
  int i, pm, vm;
  _go32_dpmi_meminfo meminfo;

  pm = _go32_dpmi_remaining_physical_memory();
  vm = _go32_dpmi_remaining_virtual_memory();
  _go32_dpmi_get_free_memory_information(&meminfo);

  printf("available memory          = %s\n", comma(meminfo.available_memory));
  printf("available pages           = %s\n", comma(meminfo.available_pages));
  printf("available lockable pages  = %s\n", comma(meminfo.available_lockable_pages));
  printf("linear space              = %s\n", comma(meminfo.linear_space));
  printf("unlocked pages            = %s\n", comma(meminfo.unlocked_pages));
  printf("available physical memory = %s\n", comma(meminfo.available_physical_pages * 4096));
  printf("total physical memory     = %s\n", comma(meminfo.total_physical_pages * 4096));
  printf("free linear space         = %s\n", comma(meminfo.free_linear_space));
  printf("size of paging file       = %s\n", comma(meminfo.max_pages_in_paging_file * 4096));
  printf("remaining physical memory = %s\n", comma(pm));
  printf("remaining virtual memory  = %s\n", comma(vm));
  
  return 0;
}
