-- ADDER is a ripple carry adder with a time delay of 1ns per gate
entity adder is
  port (a, b: in bit_vector (3 downto 0);
	sum: out bit_vector (3 downto 0);
	carry: out bit);
end adder;

architecture rtl of adder is
  signal carry_vector : bit_vector (4 downto 0);
  signal interm : bit_vector (3 downto 0);
begin
  -- intermediate signal for feed back into carry logic
  interm<=transport a xor b after 1ns;
  -- carry logic
  carry_vector<=((a and b) or (interm and carry_vector(3 downto 0))) & 0 
			after 2ns;
  sum<=transport interm xor carry_vector(3 downto 0) after 1ns;
  carry<=carry_vector(4);
end rtl;

-- A test bench to test the adder component
entity test_adder is
end test_adder;

library vector;
use std.textio.all,vector.functions.all;
architecture behaviour of test_adder is
  component adder
    port (a, b: in bit_vector (3 downto 0);
	sum: out bit_vector (3 downto 0);
	carry: out bit);
  end component;

  for all:adder use entity work.adder;

  signal op1_int,op2_int,result_int : integer :=0;
  signal op1,op2,result : bit_vector(3 downto 0);
begin
  -- adder instantiation
  inst1: adder
	port map (op1,op2,result);

  -- convert inputs and outputs
  op1<=to_bit(4,op1_int);
  op2<=to_bit(4,op2_int);
  result_int<=to_natural(result);

  -- infinite loop that read operands
  p1: process
    variable l : line;
    variable a,b : integer;
  begin
    write(l,"Enter two operands separated by a space.");
    writeline(output,l);
    readline(input,l);
    read(l,a);
    read(l,b);
    op1_int<=a;
    op2_int<=b;
    -- wait for adder to compute sum
    wait for 15ns;
  end process;
end;
