#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include "calc.h"
#include "file.h"
#include "write.h"

char prgm_id[] = "\nCRC-M2 - Cyclic Redundancy Checker"
		 ", Version 1.12, 01/02/90, rtk\n";

#define ONE_K     1024
#define MAX_BUF   (32 * ONE_K - 1)

unsigned int buf_size;
char *buf;

void disp_help(void)
{
  wrstr("\nUsage:  CRC filespec [filespec...]\n");
}

void strins(char *dest, char *src, int i)
{
  int slen, dlen;

  slen = strlen(src);
  dlen = strlen(dest);
  memmove(dest+i+slen, dest+i, dlen-i+1);
  memmove(dest+i, src, slen);
}

process(char *path, char *name)
{
  char pn[MAXPATH];
  int fd;
  int bytes_read;
  unsigned int crc16;
  unsigned long crc32;

  strcpy(pn, path);
  strcat(pn, name);
  wrchar('\t');
  wrstr(name);
  wr_char_rep(' ', 12-strlen(name));
  wrstr(": ");

  fd = file_open(pn);

  crc16 = 0;
  crc32 = 0xffffffff;   /* pre-condition - bits all ones */

  do {
    bytes_read = rdbin(fd, buf, buf_size);
    update_crc(buf, bytes_read, &crc16, &crc32);
  } while (bytes_read == buf_size);

  crc32 ^= 0xffffffff;  /* post-condition - one's complement */

  file_close(fd);

  wrstr("crc16=");
  wrhex(crc16);
  wrstr("  crc32=");
  wrlnghex(crc32);
  wrchar('\n');
}

main(int argc, char *argv[])
{
  struct ffblk ffblk;
  int i, attr = FA_HIDDEN + FA_SYSTEM;
  char path[MAXPATH];

  wrstr(prgm_id);
  if (argc == 1) {
    disp_help();
    return;
  } else
    wrchar('\n');

  make_table();
  buf_size = coreleft() - ONE_K;
  if (buf_size > MAX_BUF)
    buf_size = MAX_BUF;
  buf = (char *)malloc(buf_size);

  for (i = 1; i < argc; ++i) {
    if (findfirst(argv[i], &ffblk, attr) == 0) {
      if (i > 1)
        wrchar('\n');
      strcpy(path, argv[i]);
      strupr(path);
      get_path(path);
      wrstr(path);
      wrchar('\n');

      do {
        process(path, ffblk.ff_name);
      } while (findnext(&ffblk) == 0);
    } else {
      wrstr(argv[i]);
      wrstr(": Not found\n");
    }
  }
}
