#include "write.h"

#define MASK  0xf

void wrchar(int ch)
{
  int dosfn = 0x2;              /* character output */
  unsigned int dosdx, dosal = 0;

  dosdx = ch;
  bdos(dosfn, dosdx, dosal);
  if (ch == '\n')
    bdos(dosfn, '\r', dosal);
}

void wr_char_rep(char ch, int cnt)
{
  while (cnt-- > 0)
    wrchar(ch);
}

void wrstr(char *s)
{
  while (*s)
    wrchar(*s++);
}

static char hex_array[] = "0123456789ABCDEF";

void wrhex(unsigned int v)
{
  wrchar( hex_array[v >> 12       ] );
  wrchar( hex_array[v >>  8 & MASK] );
  wrchar( hex_array[v >>  4 & MASK] );
  wrchar( hex_array[v       & MASK] );
}

void wrlnghex(unsigned long v)
{
  wrchar( hex_array[v >> 28       ] );
  wrchar( hex_array[v >> 24 & MASK] );
  wrchar( hex_array[v >> 20 & MASK] );
  wrchar( hex_array[v >> 16 & MASK] );

  wrchar( hex_array[v >> 12 & MASK] );
  wrchar( hex_array[v >>  8 & MASK] );
  wrchar( hex_array[v >>  4 & MASK] );
  wrchar( hex_array[v       & MASK] );
}
