


FLEXDOC(1)                User Commands                FLEXDOC(1)



NNNNAAAAMMMMEEEE
     flexdoc - documentation for flex, fast lexical analyzer gen-
     erator

SSSSYYYYNNNNOOOOPPPPSSSSIIIISSSS
     fffflllleeeexxxx [[[[----bbbbccccddddffffhhhhiiiillllnnnnppppssssttttvvvvwwwwBBBBFFFFIIIILLLLTTTTVVVV77778888++++ ----CCCC[[[[aaaaeeeeffffFFFFmmmmrrrr]]]] ----PPPPpppprrrreeeeffffiiiixxxx  ---- SSSSsssskkkkeeeelllleeee----
     ttttoooonnnn]]]] [_f_i_l_e_n_a_m_e ...]

DDDDEEEESSSSCCCCRRRRIIIIPPPPTTTTIIIIOOOONNNN
     _f_l_e_x is a  tool  for  generating  _s_c_a_n_n_e_r_s:  programs  which
     recognized  lexical  patterns in text.  _f_l_e_x reads the given
     input files, or its standard input  if  no  file  names  are
     given,  for  a  description  of  a scanner to generate.  The
     description is in the form of pairs of  regular  expressions
     and  C  code,  called  _r_u_l_e_s.  _f_l_e_x  generates as output a C
     source file, lllleeeexxxx....yyyyyyyy....cccc,,,, which defines a routine yyyyyyyylllleeeexxxx(((()))).... This
     file is compiled and linked with the ----llllffffllll library to produce
     an executable.  When the executable is run, it analyzes  its
     input  for occurrences of the regular expressions.  Whenever
     it finds one, it executes the corresponding C code.

SSSSOOOOMMMMEEEE SSSSIIIIMMMMPPPPLLLLEEEE EEEEXXXXAAAAMMMMPPPPLLLLEEEESSSS
     First some simple examples to get the flavor of how one uses
     _f_l_e_x.  The  following  _f_l_e_x  input specifies a scanner which
     whenever it encounters the string "username" will replace it
     with the user's login name:

         %%
         username    printf( "%s", getlogin() );

     By default, any text not matched by a _f_l_e_x scanner is copied
     to  the output, so the net effect of this scanner is to copy
     its input file to its output with each occurrence of  "user-
     name"  expanded.   In  this  input,  there is just one rule.
     "username" is the _p_a_t_t_e_r_n and the "printf"  is  the  _a_c_t_i_o_n.
     The "%%" marks the beginning of the rules.

     Here's another simple example:

                 int num_lines = 0, num_chars = 0;

         %%
         \n      ++num_lines; ++num_chars;
         .       ++num_chars;

         %%
         main()
                 {
                 yylex();
                 printf( "# of lines = %d, # of chars = %d\n",
                         num_lines, num_chars );
                 }



Version 2.4        Last change: November 1993                   1






FLEXDOC(1)                User Commands                FLEXDOC(1)



     This scanner counts the number of characters and the  number
     of  lines in its input (it produces no output other than the
     final report on the counts).  The first  line  declares  two
     globals,  "num_lines"  and "num_chars", which are accessible
     both inside yyyyyyyylllleeeexxxx(((()))) and in the mmmmaaaaiiiinnnn(((()))) routine declared after
     the  second  "%%".  There are two rules, one which matches a
     newline ("\n") and increments both the line  count  and  the
     character  count,  and one which matches any character other
     than a newline (indicated by the "." regular expression).

     A somewhat more complicated example:

         /* scanner for a toy Pascal-like language */

         %{
         /* need this for the call to atof() below */
         #include <math.h>
         %}

         DIGIT    [0-9]
         ID       [a-z][a-z0-9]*

         %%

         {DIGIT}+    {
                     printf( "An integer: %s (%d)\n", yytext,
                             atoi( yytext ) );
                     }

         {DIGIT}+"."{DIGIT}*        {
                     printf( "A float: %s (%g)\n", yytext,
                             atof( yytext ) );
                     }

         if|then|begin|end|procedure|function        {
                     printf( "A keyword: %s\n", yytext );
                     }

         {ID}        printf( "An identifier: %s\n", yytext );

         "+"|"-"|"*"|"/"   printf( "An operator: %s\n", yytext );

         "{"[^}\n]*"}"     /* eat up one-line comments */

         [ \t\n]+          /* eat up whitespace */

         .           printf( "Unrecognized character: %s\n", yytext );

         %%

         main( argc, argv )
         int argc;



Version 2.4        Last change: November 1993                   2






FLEXDOC(1)                User Commands                FLEXDOC(1)



         char **argv;
             {
             ++argv, --argc;  /* skip over program name */
             if ( argc > 0 )
                     yyin = fopen( argv[0], "r" );
             else
                     yyin = stdin;

             yylex();
             }

     This is the beginnings of a simple scanner  for  a  language
     like  Pascal.   It  identifies different types of _t_o_k_e_n_s and
     reports on what it has seen.

     The details of this example will be explained in the follow-
     ing sections.

FFFFOOOORRRRMMMMAAAATTTT OOOOFFFF TTTTHHHHEEEE IIIINNNNPPPPUUUUTTTT FFFFIIIILLLLEEEE
     The _f_l_e_x input file consists of three sections, separated by
     a line with just %%%%%%%% in it:

         definitions
         %%
         rules
         %%
         user code

     The _d_e_f_i_n_i_t_i_o_n_s section contains declarations of simple _n_a_m_e
     definitions  to  simplify  the  scanner  specification,  and
     declarations of _s_t_a_r_t _c_o_n_d_i_t_i_o_n_s, which are explained  in  a
     later section.

     Name definitions have the form:

         name definition

     The "name" is a word beginning with a letter  or  an  under-
     score  ('_')  followed by zero or more letters, digits, '_',
     or '-' (dash).  The definition is  taken  to  begin  at  the
     first  non-white-space character following the name and con-
     tinuing to the end of the line.  The definition  can  subse-
     quently  be referred to using "{name}", which will expand to
     "(definition)".  For example,

         DIGIT    [0-9]
         ID       [a-z][a-z0-9]*

     defines "DIGIT" to be a regular expression which  matches  a
     single  digit,  and  "ID"  to  be a regular expression which
     matches a letter followed by zero-or-more letters-or-digits.
     A subsequent reference to



Version 2.4        Last change: November 1993                   3






FLEXDOC(1)                User Commands                FLEXDOC(1)



         {DIGIT}+"."{DIGIT}*

     is identical to

         ([0-9])+"."([0-9])*

     and matches one-or-more digits followed by a '.' followed by
     zero-or-more digits.

     The _r_u_l_e_s section of the _f_l_e_x input  contains  a  series  of
     rules of the form:

         pattern   action

     where the pattern must be unindented  and  the  action  must
     begin on the same line.

     See below for a further description of patterns and actions.

     Finally, the user code section is simply copied to  lllleeeexxxx....yyyyyyyy....cccc
     verbatim.   It  is used for companion routines which call or
     are called by the scanner.  The presence of this section  is
     optional;  if it is missing, the second %%%%%%%% in the input file
     may be skipped, too.

     In the definitions and rules sections, any _i_n_d_e_n_t_e_d text  or
     text  enclosed in %%%%{{{{ and %%%%}}}} is copied verbatim to the output
     (with the %{}'s removed).  The %{}'s must appear  unindented
     on lines by themselves.

     In the rules section, any indented  or  %{}  text  appearing
     before the first rule may be used to declare variables which
     are local to the scanning routine and  (after  the  declara-
     tions)  code  which  is to be executed whenever the scanning
     routine is entered.  Other indented or %{} text in the  rule
     section  is  still  copied to the output, but its meaning is
     not well-defined and it may well cause  compile-time  errors
     (this feature is present for _P_O_S_I_X compliance; see below for
     other such features).

     In the definitions section (but not in the  rules  section),
     an  unindented comment (i.e., a line beginning with "/*") is
     also copied verbatim to the output up to the next "*/".

PPPPAAAATTTTTTTTEEEERRRRNNNNSSSS
     The patterns in the input are written using an extended  set
     of regular expressions.  These are:

         x          match the character 'x'
         .          any character except newline
         [xyz]      a "character class"; in this case, the pattern
                      matches either an 'x', a 'y', or a 'z'



Version 2.4        Last change: November 1993                   4






FLEXDOC(1)                User Commands                FLEXDOC(1)



         [abj-oZ]   a "character class" with a range in it; matches
                      an 'a', a 'b', any letter from 'j' through 'o',
                      or a 'Z'
         [^A-Z]     a "negated character class", i.e., any character
                      but those in the class.  In this case, any
                      character EXCEPT an uppercase letter.
         [^A-Z\n]   any character EXCEPT an uppercase letter or
                      a newline
         r*         zero or more r's, where r is any regular expression
         r+         one or more r's
         r?         zero or one r's (that is, "an optional r")
         r{2,5}     anywhere from two to five r's
         r{2,}      two or more r's
         r{4}       exactly 4 r's
         {name}     the expansion of the "name" definition
                    (see above)
         "[xyz]\"foo"
                    the literal string: [xyz]"foo
         \X         if X is an 'a', 'b', 'f', 'n', 'r', 't', or 'v',
                      then the ANSI-C interpretation of \x.
                      Otherwise, a literal 'X' (used to escape
                      operators such as '*')
         \123       the character with octal value 123
         \x2a       the character with hexadecimal value 2a
         (r)        match an r; parentheses are used to override
                      precedence (see below)


         rs         the regular expression r followed by the
                      regular expression s; called "concatenation"


         r|s        either an r or an s


         r/s        an r but only if it is followed by an s.  The
                      s is not part of the matched text.  This type
                      of pattern is called as "trailing context".
         ^r         an r, but only at the beginning of a line
         r$         an r, but only at the end of a line.  Equivalent
                      to "r/\n".


         <s>r       an r, but only in start condition s (see
                    below for discussion of start conditions)
         <s1,s2,s3>r
                    same, but in any of start conditions s1,
                    s2, or s3
         <*>r       an r in any start condition, even an exclusive one.


         <<EOF>>    an end-of-file



Version 2.4        Last change: November 1993                   5






FLEXDOC(1)                User Commands                FLEXDOC(1)



         <s1,s2><<EOF>>
                    an end-of-file when in start condition s1 or s2

     Note that inside of a character class, all  regular  expres-
     sion  operators  lose  their  special  meaning except escape
     ('\') and the character class operators, '-', ']',  and,  at
     the beginning of the class, '^'.

     The regular expressions listed above are  grouped  according
     to  precedence, from highest precedence at the top to lowest
     at the bottom.   Those  grouped  together  have  equal  pre-
     cedence.  For example,

         foo|bar*

     is the same as

         (foo)|(ba(r*))

     since the '*' operator has higher precedence than concatena-
     tion, and concatenation higher than alternation ('|').  This
     pattern therefore matches _e_i_t_h_e_r the  string  "foo"  _o_r  the
     string "ba" followed by zero-or-more r's.  To match "foo" or
     zero-or-more "bar"'s, use:

         foo|(bar)*

     and to match zero-or-more "foo"'s-or-"bar"'s:

         (foo|bar)*


     Some notes on patterns:

     -    A negated character class such as the example  "[^A-Z]"
          above   _w_i_l_l   _m_a_t_c_h  _a  _n_e_w_l_i_n_e  unless  "\n"  (or  an
          equivalent escape sequence) is one  of  the  characters
          explicitly  present  in  the  negated  character  class
          (e.g., "[^A-Z\n]").  This is unlike how many other reg-
          ular  expression tools treat negated character classes,
          but unfortunately  the  inconsistency  is  historically
          entrenched.   Matching  newlines  means  that a pattern
          like [^"]* can match the entire  input  unless  there's
          another quote in the input.

     -    A rule can have at most one instance of  trailing  con-
          text (the '/' operator or the '$' operator).  The start
          condition, '^', and "<<EOF>>" patterns can  only  occur
          at the beginning of a pattern, and, as well as with '/'
          and '$', cannot be grouped inside parentheses.   A  '^'
          which  does  not  occur at the beginning of a rule or a
          '$' which does not occur at the end of a rule loses its



Version 2.4        Last change: November 1993                   6






FLEXDOC(1)                User Commands                FLEXDOC(1)



          special  properties  and is treated as a normal charac-
          ter.

          The following are illegal:

              foo/bar$
              <sc1>foo<sc2>bar

          Note  that  the  first  of  these,   can   be   written
          "foo/bar\n".

          The following will result in '$' or '^'  being  treated
          as a normal character:

              foo|(bar$)
              foo|^bar

          If what's wanted is a  "foo"  or  a  bar-followed-by-a-
          newline,  the  following could be used (the special '|'
          action is explained below):

              foo      |
              bar$     /* action goes here */

          A similar trick will work for matching a foo or a  bar-
          at-the-beginning-of-a-line.

HHHHOOOOWWWW TTTTHHHHEEEE IIIINNNNPPPPUUUUTTTT IIIISSSS MMMMAAAATTTTCCCCHHHHEEEEDDDD
     When the generated scanner is run,  it  analyzes  its  input
     looking  for strings which match any of its patterns.  If it
     finds more than one match, it takes  the  one  matching  the
     most  text  (for  trailing  context rules, this includes the
     length of the trailing part, even though  it  will  then  be
     returned  to the input).  If it finds two or more matches of
     the same length, the rule listed first  in  the  _f_l_e_x  input
     file is chosen.

     Once the match is determined, the text corresponding to  the
     match  (called  the  _t_o_k_e_n)  is made available in the global
     character pointer yyyyyyyytttteeeexxxxtttt,,,,  and  its  length  in  the  global
     integer yyyyyyyylllleeeennnngggg.... The _a_c_t_i_o_n corresponding to the matched pat-
     tern is  then  executed  (a  more  detailed  description  of
     actions  follows),  and  then the remaining input is scanned
     for another match.

     If no match is found, then the _d_e_f_a_u_l_t _r_u_l_e is executed: the
     next character in the input is considered matched and copied
     to the standard output.  Thus, the simplest legal _f_l_e_x input
     is:

         %%




Version 2.4        Last change: November 1993                   7






FLEXDOC(1)                User Commands                FLEXDOC(1)



     which generates a scanner that simply copies its input  (one
     character at a time) to its output.

     Note that yyyyyyyytttteeeexxxxtttt can  be  defined  in  two  different  ways:
     either  as  a character _p_o_i_n_t_e_r or as a character _a_r_r_a_y. You
     can control which definition _f_l_e_x uses by including  one  of
     the  special  directives  %%%%ppppooooiiiinnnntttteeeerrrr  or  %%%%aaaarrrrrrrraaaayyyy  in the first
     (definitions) section of your flex input.   The  default  is
     %%%%ppppooooiiiinnnntttteeeerrrr,,,, unless you use the ----llll lex compatibility option, in
     which case yyyyyyyytttteeeexxxxtttt will be an array.  The advantage of  using
     %%%%ppppooooiiiinnnntttteeeerrrr  is  substantially  faster  scanning  and no buffer
     overflow when matching very large tokens (unless you run out
     of  dynamic  memory).  The disadvantage is that you are res-
     tricted in how your actions can modify yyyyyyyytttteeeexxxxtttt (see the  next
     section),  and  calls  to  the iiiinnnnppppuuuutttt(((()))) and uuuunnnnppppuuuutttt(((()))) functions
     destroy the present contents of yyyyyyyytttteeeexxxxtttt,,,, which can be a  con-
     siderable porting headache when moving between different _l_e_x
     versions.

     The advantage of %%%%aaaarrrrrrrraaaayyyy is that you can then  modify  yyyyyyyytttteeeexxxxtttt
     to your heart's content, and calls to iiiinnnnppppuuuutttt(((()))) and uuuunnnnppppuuuutttt(((()))) do
     not destroy yyyyyyyytttteeeexxxxtttt (see below).  Furthermore,  existing  _l_e_x
     programs  sometimes  access yyyyyyyytttteeeexxxxtttt externally using declara-
     tions of the form:
         extern char yytext[];
     This definition is erroneous when used  with  %%%%ppppooooiiiinnnntttteeeerrrr,,,,  but
     correct for %%%%aaaarrrrrrrraaaayyyy....

     %%%%aaaarrrrrrrraaaayyyy defines yyyyyyyytttteeeexxxxtttt to be an array of  YYYYYYYYLLLLMMMMAAAAXXXX  characters,
     which  defaults to a fairly large value.  You can change the
     size by simply #define'ing YYYYYYYYLLLLMMMMAAAAXXXX to a  different  value  in
     the  first  section of your _f_l_e_x input.  As mentioned above,
     with %%%%ppppooooiiiinnnntttteeeerrrr yytext grows dynamically to  accomodate  large
     tokens.   While this means your %%%%ppppooooiiiinnnntttteeeerrrr scanner can accomo-
     date very large tokens (such as matching  entire  blocks  of
     comments),  bear  in  mind  that  each time the scanner must
     resize yyyyyyyytttteeeexxxxtttt it also must rescan the entire token from  the
     beginning,  so  matching such tokens can prove slow.  yyyyyyyytttteeeexxxxtttt
     presently does _n_o_t dynamically grow if  a  call  to  uuuunnnnppppuuuutttt(((())))
     results  in too much text being pushed back; instead, a run-
     time error results.

     Also note that  you  cannot  use  %%%%aaaarrrrrrrraaaayyyy  with  C++  scanner
     classes (the ----++++ option; see below).

AAAACCCCTTTTIIIIOOOONNNNSSSS
     Each pattern in a rule has a corresponding action, which can
     be any arbitrary C statement.  The pattern ends at the first
     non-escaped whitespace character; the remainder of the  line
     is  its  action.  If the action is empty, then when the pat-
     tern is matched the input token is  simply  discarded.   For
     example,  here  is  the  specification  for  a program which



Version 2.4        Last change: November 1993                   8






FLEXDOC(1)                User Commands                FLEXDOC(1)



     deletes all occurrences of "zap me" from its input:

         %%
         "zap me"

     (It will copy all other characters in the input to the  out-
     put since they will be matched by the default rule.)

     Here is a program which compresses multiple blanks and  tabs
     down  to a single blank, and throws away whitespace found at
     the end of a line:

         %%
         [ \t]+        putchar( ' ' );
         [ \t]+$       /* ignore this token */


     If the action contains a '{', then the action spans till the
     balancing  '}'  is  found, and the action may cross multiple
     lines.  _f_l_e_x knows about C strings and comments and won't be
     fooled  by braces found within them, but also allows actions
     to begin with %%%%{{{{ and will consider the action to be all  the
     text up to the next %%%%}}}} (regardless of ordinary braces inside
     the action).

     An action consisting solely of a vertical  bar  ('|')  means
     "same  as  the  action for the next rule."  See below for an
     illustration.

     Actions can  include  arbitrary  C  code,  including  rrrreeeettttuuuurrrrnnnn
     statements  to  return  a  value  to whatever routine called
     yyyyyyyylllleeeexxxx(((()))).... Each time yyyyyyyylllleeeexxxx(((()))) is called it continues processing
     tokens  from  where it last left off until it either reaches
     the end of the file or executes a return.

     Actions are free to modify yyyyyyyytttteeeexxxxtttt except for lengthening  it
     (adding  characters  to  its end--these will overwrite later
     characters in the input stream).  Modifying the final  char-
     acter  of  yytext  may  alter  whether when scanning resumes
     rules anchored with '^' are active.  Specifically,  changing
     the  final  character  of  yytext to a newline will activate
     such rules on the next scan, and  changing  it  to  anything
     else  will  deactivate  the rules.  Users should not rely on
     this behavior being present in  future  releases.   Finally,
     note  that  none of this paragraph applies when using %%%%aaaarrrrrrrraaaayyyy
     (see above).

     Actions are free to modify yyyyyyyylllleeeennnngggg except they should not  do
     so if the action also includes use of yyyyyyyymmmmoooorrrreeee(((()))) (see below).

     There are a  number  of  special  directives  which  can  be
     included within an action:



Version 2.4        Last change: November 1993                   9






FLEXDOC(1)                User Commands                FLEXDOC(1)



     -    EEEECCCCHHHHOOOO copies yytext to the scanner's output.

     -    BBBBEEEEGGGGIIIINNNN followed by the name of a start condition  places
          the  scanner  in the corresponding start condition (see
          below).

     -    RRRREEEEJJJJEEEECCCCTTTT directs the scanner to proceed on to the "second
          best"  rule which matched the input (or a prefix of the
          input).  The rule is chosen as described above in  "How
          the  Input  is  Matched",  and yyyyyyyytttteeeexxxxtttt and yyyyyyyylllleeeennnngggg set up
          appropriately.  It may either be one which  matched  as
          much  text as the originally chosen rule but came later
          in the _f_l_e_x input file, or one which matched less text.
          For example, the following will both count the words in
          the input  and  call  the  routine  special()  whenever
          "frob" is seen:

                      int word_count = 0;
              %%

              frob        special(); REJECT;
              [^ \t\n]+   ++word_count;

          Without the RRRREEEEJJJJEEEECCCCTTTT,,,, any "frob"'s in the input would not
          be  counted  as  words, since the scanner normally exe-
          cutes only one action per token.  Multiple RRRREEEEJJJJEEEECCCCTTTT''''ssss are
          allowed,  each  one finding the next best choice to the
          currently active rule.  For example, when the following
          scanner  scans the token "abcd", it will write "abcdab-
          caba" to the output:

              %%
              a        |
              ab       |
              abc      |
              abcd     ECHO; REJECT;
              .|\n     /* eat up any unmatched character */

          (The first three rules share the fourth's action  since
          they use the special '|' action.)  RRRREEEEJJJJEEEECCCCTTTT is a particu-
          larly expensive feature in terms  scanner  performance;
          if  it  is used in _a_n_y of the scanner's actions it will
          slow down _a_l_l of the scanner's matching.   Furthermore,
          RRRREEEEJJJJEEEECCCCTTTT  cannot be used with the -_C_f or -_C_F options (see
          below).

          Note also that unlike the other special actions, RRRREEEEJJJJEEEECCCCTTTT
          is  a  _b_r_a_n_c_h;  code  immediately  following  it in the
          action will _n_o_t be executed.

     -    yyyyyyyymmmmoooorrrreeee(((()))) tells  the  scanner  that  the  next  time  it
          matches  a  rule,  the  corresponding  token  should be



Version 2.4        Last change: November 1993                  10






FLEXDOC(1)                User Commands                FLEXDOC(1)



          _a_p_p_e_n_d_e_d onto the current value of yyyyyyyytttteeeexxxxtttt  rather  than
          replacing  it.   For  example,  given  the input "mega-
          kludge" the following will write "mega-mega-kludge"  to
          the output:

              %%
              mega-    ECHO; yymore();
              kludge   ECHO;

          First "mega-" is matched  and  echoed  to  the  output.
          Then  "kludge"  is matched, but the previous "mega-" is
          still hanging around at the beginning of yyyyyyyytttteeeexxxxtttt so  the
          EEEECCCCHHHHOOOO  for  the "kludge" rule will actually write "mega-
          kludge".  The presence of  yyyyyyyymmmmoooorrrreeee(((())))  in  the  scanner's
          action  entails  a  minor  performance  penalty  in the
          scanner's matching speed.

     -    yyyyyyyylllleeeessssssss((((nnnn)))) returns all but the first _n characters of the
          current token back to the input stream, where they will
          be rescanned when the scanner looks for the next match.
          yyyyyyyytttteeeexxxxtttt  and  yyyyyyyylllleeeennnngggg  are  adjusted appropriately (e.g.,
          yyyyyyyylllleeeennnngggg will now be equal to _n ).  For example,  on  the
          input  "foobar"  the  following will write out "foobar-
          bar":

              %%
              foobar    ECHO; yyless(3);
              [a-z]+    ECHO;

          An argument of  0  to  yyyyyyyylllleeeessssssss  will  cause  the  entire
          current  input  string  to  be  scanned  again.  Unless
          you've changed how the scanner will  subsequently  pro-
          cess  its  input  (using BBBBEEEEGGGGIIIINNNN,,,, for example), this will
          result in an endless loop.

     Note that yyyyyyyylllleeeessssssss is a macro and can only be used in the flex
     input file, not from other source files.

     -    uuuunnnnppppuuuutttt((((cccc)))) puts the  character  _c  back  onto  the  input
          stream.   It  will  be the next character scanned.  The
          following action will take the current token and  cause
          it to be rescanned enclosed in parentheses.

              {
              int i;
              unput( ')' );
              for ( i = yyleng - 1; i >= 0; --i )
                  unput( yytext[i] );
              unput( '(' );
              }

          Note that since each uuuunnnnppppuuuutttt(((()))) puts the  given  character



Version 2.4        Last change: November 1993                  11






FLEXDOC(1)                User Commands                FLEXDOC(1)



          back at the _b_e_g_i_n_n_i_n_g of the input stream, pushing back
          strings must be done back-to-front.  Also note that you
          cannot put back EEEEOOOOFFFF to attempt to mark the input stream
          with an end-of-file.

     -    iiiinnnnppppuuuutttt(((()))) reads the next character from the input stream.
          For  example, the following is one way to eat up C com-
          ments:

              %%
              "/*"        {
                          register int c;

                          for ( ; ; )
                              {
                              while ( (c = input()) != '*' &&
                                      c != EOF )
                                  ;    /* eat up text of comment */

                              if ( c == '*' )
                                  {
                                  while ( (c = input()) == '*' )
                                      ;
                                  if ( c == '/' )
                                      break;    /* found the end */
                                  }

                              if ( c == EOF )
                                  {
                                  error( "EOF in comment" );
                                  break;
                                  }
                              }
                          }

          (Note that if the scanner is compiled using  CCCC++++++++,,,,  then
          iiiinnnnppppuuuutttt(((())))  is  instead referred to as yyyyyyyyiiiinnnnppppuuuutttt(((()))),,,, in order
          to avoid a name clash with the CCCC++++++++ stream by  the  name
          of _i_n_p_u_t.)

     -    yyyyyyyytttteeeerrrrmmmmiiiinnnnaaaatttteeee(((()))) can be used in lieu of a return statement
          in  an action.  It terminates the scanner and returns a
          0 to the scanner's caller, indicating "all  done".   By
          default,  yyyyyyyytttteeeerrrrmmmmiiiinnnnaaaatttteeee(((())))  is also called when an end-of-
          file is encountered.  It is a macro and  may  be  rede-
          fined.

TTTTHHHHEEEE GGGGEEEENNNNEEEERRRRAAAATTTTEEEEDDDD SSSSCCCCAAAANNNNNNNNEEEERRRR
     The output of _f_l_e_x is the file lllleeeexxxx....yyyyyyyy....cccc,,,, which contains  the
     scanning  routine yyyyyyyylllleeeexxxx(((()))),,,, a number of tables used by it for
     matching tokens, and a number of auxiliary routines and mac-
     ros.  By default, yyyyyyyylllleeeexxxx(((()))) is declared as follows:



Version 2.4        Last change: November 1993                  12






FLEXDOC(1)                User Commands                FLEXDOC(1)



         int yylex()
             {
             ... various definitions and the actions in here ...
             }

     (If your environment supports function prototypes,  then  it
     will  be  "int  yylex(  void  )".)   This  definition may be
     changed by defining the "YY_DECL" macro.  For  example,  you
     could use:

         #define YY_DECL float lexscan( a, b ) float a, b;

     to give the scanning routine the name _l_e_x_s_c_a_n,  returning  a
     float, and taking two floats as arguments.  Note that if you
     give  arguments  to  the  scanning  routine  using  a   K&R-
     style/non-prototyped  function  declaration,  you  must ter-
     minate the definition with a semi-colon (;).

     Whenever yyyyyyyylllleeeexxxx(((()))) is called, it scans tokens from the  global
     input  file  _y_y_i_n  (which  defaults to stdin).  It continues
     until it either reaches an end-of-file (at  which  point  it
     returns the value 0) or one of its actions executes a _r_e_t_u_r_n
     statement.

     If the scanner reaches an end-of-file, subsequent calls  are
     undefined  unless either _y_y_i_n is pointed at a new input file
     (in which case scanning continues from that file), or yyyyyyyyrrrreeeessss----
     ttttaaaarrrrtttt(((())))  is called.  yyyyyyyyrrrreeeessssttttaaaarrrrtttt(((()))) takes one argument, a FFFFIIIILLLLEEEE ****
     pointer, and initializes _y_y_i_n for scanning from  that  file.
     Essentially  there  is  no difference between just assigning
     _y_y_i_n to a new input file or using yyyyyyyyrrrreeeessssttttaaaarrrrtttt(((()))) to do so;  the
     latter is available for compatibility with previous versions
     of _f_l_e_x, and because it can be used to switch input files in
     the  middle  of scanning.  It can also be used to throw away
     the current input buffer, by calling it with an argument  of
     _y_y_i_n.

     If yyyyyyyylllleeeexxxx(((()))) stops scanning due to executing a  _r_e_t_u_r_n  state-
     ment  in  one of the actions, the scanner may then be called
     again and it will resume scanning where it left off.

     By default (and for purposes  of  efficiency),  the  scanner
     uses  block-reads  rather  than  simple _g_e_t_c() calls to read
     characters from _y_y_i_n. The nature of how it  gets  its  input
     can   be   controlled   by   defining  the  YYYYYYYY____IIIINNNNPPPPUUUUTTTT  macro.
     YY_INPUT's           calling           sequence           is
     "YY_INPUT(buf,result,max_size)".   Its action is to place up
     to _m_a_x__s_i_z_e characters in the character array _b_u_f and return
     in  the integer variable _r_e_s_u_l_t either the number of charac-
     ters read or the constant YY_NULL (0  on  Unix  systems)  to
     indicate  EOF.   The  default YY_INPUT reads from the global
     file-pointer "yyin".



Version 2.4        Last change: November 1993                  13






FLEXDOC(1)                User Commands                FLEXDOC(1)



     A sample definition of YY_INPUT (in the definitions  section
     of the input file):

         %{
         #define YY_INPUT(buf,result,max_size) \
             { \
             int c = getchar(); \
             result = (c == EOF) ? YY_NULL : (buf[0] = c, 1); \
             }
         %}

     This definition will change the input  processing  to  occur
     one character at a time.

     You also can add in things like keeping track of  the  input
     line  number  this  way; but don't expect your scanner to go
     very fast.

     When the scanner receives  an  end-of-file  indication  from
     YY_INPUT, it then checks the yyyyyyyywwwwrrrraaaapppp(((()))) function.  If yyyyyyyywwwwrrrraaaapppp(((())))
     returns false (zero), then it is assumed that  the  function
     has  gone  ahead  and  set up _y_y_i_n to point to another input
     file, and scanning continues.   If  it  returns  true  (non-
     zero),  then  the  scanner  terminates,  returning  0 to its
     caller.

     The default yyyyyyyywwwwrrrraaaapppp(((()))) always returns 1.

     The scanner writes its  EEEECCCCHHHHOOOO  output  to  the  _y_y_o_u_t  global
     (default, stdout), which may be redefined by the user simply
     by assigning it to some other FFFFIIIILLLLEEEE pointer.

SSSSTTTTAAAARRRRTTTT CCCCOOOONNNNDDDDIIIITTTTIIIIOOOONNNNSSSS
     _f_l_e_x  provides  a  mechanism  for  conditionally  activating
     rules.   Any rule whose pattern is prefixed with "<sc>" will
     only be active when the scanner is in  the  start  condition
     named "sc".  For example,

         <STRING>[^"]*        { /* eat up the string body ... */
                     ...
                     }

     will be active only when the  scanner  is  in  the  "STRING"
     start condition, and

         <INITIAL,STRING,QUOTE>\.        { /* handle an escape ... */
                     ...
                     }

     will be active only when  the  current  start  condition  is
     either "INITIAL", "STRING", or "QUOTE".




Version 2.4        Last change: November 1993                  14






FLEXDOC(1)                User Commands                FLEXDOC(1)



     Start conditions are declared  in  the  definitions  (first)
     section  of  the input using unindented lines beginning with
     either %%%%ssss or %%%%xxxx followed by a list  of  names.   The  former
     declares  _i_n_c_l_u_s_i_v_e  start  conditions, the latter _e_x_c_l_u_s_i_v_e
     start conditions.  A start condition is activated using  the
     BBBBEEEEGGGGIIIINNNN  action.   Until  the  next  BBBBEEEEGGGGIIIINNNN action is executed,
     rules with the given start  condition  will  be  active  and
     rules  with other start conditions will be inactive.  If the
     start condition is _i_n_c_l_u_s_i_v_e, then rules with no start  con-
     ditions  at  all  will  also be active.  If it is _e_x_c_l_u_s_i_v_e,
     then _o_n_l_y rules qualified with the start condition  will  be
     active.   A  set  of  rules contingent on the same exclusive
     start condition describe a scanner which is  independent  of
     any  of the other rules in the _f_l_e_x input.  Because of this,
     exclusive start conditions make it easy  to  specify  "mini-
     scanners"  which scan portions of the input that are syntac-
     tically different from the rest (e.g., comments).

     If the distinction between  inclusive  and  exclusive  start
     conditions  is still a little vague, here's a simple example
     illustrating the connection between the  two.   The  set  of
     rules:

         %s example
         %%
         <example>foo           /* do something */

     is equivalent to

         %x example
         %%
         <INITIAL,example>foo   /* do something */


     Also note that the  special  start-condition  specifier  <<<<****>>>>
     matches  every  start  condition.   Thus,  the above example
     could also have been written;

         %x example
         %%
         <*>foo   /* do something */


     The default rule (to EEEECCCCHHHHOOOO any unmatched  character)  remains
     active in start conditions.

     BBBBEEEEGGGGIIIINNNN((((0000)))) returns to the original state where only the  rules
     with no start conditions are active.  This state can also be
     referred   to   as   the   start-condition   "INITIAL",   so
     BBBBEEEEGGGGIIIINNNN((((IIIINNNNIIIITTTTIIIIAAAALLLL))))  is  equivalent to BBBBEEEEGGGGIIIINNNN((((0000)))).... (The parentheses
     around the start condition name are  not  required  but  are
     considered good style.)



Version 2.4        Last change: November 1993                  15






FLEXDOC(1)                User Commands                FLEXDOC(1)



     BBBBEEEEGGGGIIIINNNN actions can also be given  as  indented  code  at  the
     beginning  of the rules section.  For example, the following
     will cause the scanner to enter the "SPECIAL"  start  condi-
     tion  whenever  _y_y_l_e_x()  is  called  and the global variable
     _e_n_t_e_r__s_p_e_c_i_a_l is true:

                 int enter_special;

         %x SPECIAL
         %%
                 if ( enter_special )
                     BEGIN(SPECIAL);

         <SPECIAL>blahblahblah
         ...more rules follow...


     To illustrate the  uses  of  start  conditions,  here  is  a
     scanner  which  provides  two different interpretations of a
     string like "123.456".  By default it will treat  it  as  as
     three  tokens,  the  integer  "123",  a  dot  ('.'), and the
     integer "456".  But if the string is preceded earlier in the
     line  by  the  string  "expect-floats" it will treat it as a
     single token, the floating-point number 123.456:

         %{
         #include <math.h>
         %}
         %s expect

         %%
         expect-floats        BEGIN(expect);

         <expect>[0-9]+"."[0-9]+      {
                     printf( "found a float, = %f\n",
                             atof( yytext ) );
                     }
         <expect>\n           {
                     /* that's the end of the line, so
                      * we need another "expect-number"
                      * before we'll recognize any more
                      * numbers
                      */
                     BEGIN(INITIAL);
                     }

         [0-9]+      {
                     printf( "found an integer, = %d\n",
                             atoi( yytext ) );
                     }

         "."         printf( "found a dot\n" );



Version 2.4        Last change: November 1993                  16






FLEXDOC(1)                User Commands                FLEXDOC(1)



     Here is a scanner which recognizes (and discards) C comments
     while maintaining a count of the current input line.

         %x comment
         %%
                 int line_num = 1;

         "/*"         BEGIN(comment);

         <comment>[^*\n]*        /* eat anything that's not a '*' */
         <comment>"*"+[^*/\n]*   /* eat up '*'s not followed by '/'s */
         <comment>\n             ++line_num;
         <comment>"*"+"/"        BEGIN(INITIAL);

     This scanner goes to a bit of trouble to match as much  text
     as  possible with each rule.  In general, when attempting to
     write a high-speed scanner try to match as much possible  in
     each rule, as it's a big win.

     Note that start-conditions names are really  integer  values
     and  can  be  stored  as  such.   Thus,  the  above could be
     extended in the following fashion:

         %x comment foo
         %%
                 int line_num = 1;
                 int comment_caller;

         "/*"         {
                      comment_caller = INITIAL;
                      BEGIN(comment);
                      }

         ...

         <foo>"/*"    {
                      comment_caller = foo;
                      BEGIN(comment);
                      }

         <comment>[^*\n]*        /* eat anything that's not a '*' */
         <comment>"*"+[^*/\n]*   /* eat up '*'s not followed by '/'s */
         <comment>\n             ++line_num;
         <comment>"*"+"/"        BEGIN(comment_caller);

     Furthermore, you can  access  the  current  start  condition
     using  the  integer-valued YYYYYYYY____SSSSTTTTAAAARRRRTTTT macro.  For example, the
     above assignments to _c_o_m_m_e_n_t__c_a_l_l_e_r could instead be written

         comment_caller = YY_START;





Version 2.4        Last change: November 1993                  17






FLEXDOC(1)                User Commands                FLEXDOC(1)



     Note that start conditions do not have their own name-space;
     %s's   and  %x's  declare  names  in  the  same  fashion  as
     #define's.

     Finally, here's an example of how to  match  C-style  quoted
     strings using exclusive start conditions, including expanded
     escape sequences (but not including checking  for  a  string
     that's too long):

         %x str

         %%
                 char string_buf[MAX_STR_CONST];
                 char *string_buf_ptr;


         \"      string_buf_ptr = string_buf; BEGIN(str);

         <str>\"        { /* saw closing quote - all done */
                 BEGIN(INITIAL);
                 *string_buf_ptr = '\0';
                 /* return string constant token type and
                  * value to parser
                  */
                 }

         <str>\n        {
                 /* error - unterminated string constant */
                 /* generate error message */
                 }

         <str>\\[0-7]{1,3} {
                 /* octal escape sequence */
                 int result;

                 (void) sscanf( yytext + 1, "%o", &result );

                 if ( result > 0xff )
                         /* error, constant is out-of-bounds */

                 *string_buf_ptr++ = result;
                 }

         <str>\\[0-9]+ {
                 /* generate error - bad escape sequence; something
                  * like '\48' or '\0777777'
                  */
                 }

         <str>\\n  *string_buf_ptr++ = '\n';
         <str>\\t  *string_buf_ptr++ = '\t';
         <str>\\r  *string_buf_ptr++ = '\r';



Version 2.4        Last change: November 1993                  18






FLEXDOC(1)                User Commands                FLEXDOC(1)



         <str>\\b  *string_buf_ptr++ = '\b';
         <str>\\f  *string_buf_ptr++ = '\f';

         <str>\\(.|\n)  *string_buf_ptr++ = yytext[1];

         <str>[^\\\n\"]+        {
                 char *yytext_ptr = yytext;

                 while ( *yytext_ptr )
                         *string_buf_ptr++ = *yytext_ptr++;
                 }


MMMMUUUULLLLTTTTIIIIPPPPLLLLEEEE IIIINNNNPPPPUUUUTTTT BBBBUUUUFFFFFFFFEEEERRRRSSSS
     Some scanners (such as those which support "include"  files)
     require   reading  from  several  input  streams.   As  _f_l_e_x
     scanners do a large amount of buffering, one cannot  control
     where  the  next input will be read from by simply writing a
     YYYYYYYY____IIIINNNNPPPPUUUUTTTT  which  is  sensitive  to  the  scanning   context.
     YYYYYYYY____IIIINNNNPPPPUUUUTTTT  is only called when the scanner reaches the end of
     its buffer, which may be a long time after scanning a state-
     ment such as an "include" which requires switching the input
     source.

     To negotiate  these  sorts  of  problems,  _f_l_e_x  provides  a
     mechanism  for creating and switching between multiple input
     buffers.  An input buffer is created by using:

         YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )

     which takes a _F_I_L_E pointer and a size and creates  a  buffer
     associated with the given file and large enough to hold _s_i_z_e
     characters (when in doubt, use YYYYYYYY____BBBBUUUUFFFF____SSSSIIIIZZZZEEEE  for  the  size).
     It  returns  a  YYYYYYYY____BBBBUUUUFFFFFFFFEEEERRRR____SSSSTTTTAAAATTTTEEEE  handle,  which  may then be
     passed to other routines:

         void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )

     switches the scanner's input  buffer  so  subsequent  tokens
     will  come  from _n_e_w__b_u_f_f_e_r. Note that yyyyyyyy____sssswwwwiiiittttcccchhhh____ttttoooo____bbbbuuuuffffffffeeeerrrr(((())))
     may be used by yywrap() to set things up for continued scan-
     ning, instead of opening a new file and pointing _y_y_i_n at it.

         void yy_delete_buffer( YY_BUFFER_STATE buffer )

     is used to reclaim the storage associated with a buffer.

     yyyyyyyy____nnnneeeewwww____bbbbuuuuffffffffeeeerrrr(((()))) is an alias for yyyyyyyy____ccccrrrreeeeaaaatttteeee____bbbbuuuuffffffffeeeerrrr(((()))),,,, provided
     for  compatibility  with  the  C++ use of _n_e_w and _d_e_l_e_t_e for
     creating and destroying dynamic objects.





Version 2.4        Last change: November 1993                  19






FLEXDOC(1)                User Commands                FLEXDOC(1)



     Finally,   the    YYYYYYYY____CCCCUUUURRRRRRRREEEENNNNTTTT____BBBBUUUUFFFFFFFFEEEERRRR    macro    returns    a
     YYYYYYYY____BBBBUUUUFFFFFFFFEEEERRRR____SSSSTTTTAAAATTTTEEEE handle to the current buffer.

     Here is an example of using these  features  for  writing  a
     scanner  which expands include files (the <<<<<<<<EEEEOOOOFFFF>>>>>>>> feature is
     discussed below):

         /* the "incl" state is used for picking up the name
          * of an include file
          */
         %x incl

         %{
         #define MAX_INCLUDE_DEPTH 10
         YY_BUFFER_STATE include_stack[MAX_INCLUDE_DEPTH];
         int include_stack_ptr = 0;
         %}

         %%
         include             BEGIN(incl);

         [a-z]+              ECHO;
         [^a-z\n]*\n?        ECHO;

         <incl>[ \t]*      /* eat the whitespace */
         <incl>[^ \t\n]+   { /* got the include file name */
                 if ( include_stack_ptr >= MAX_INCLUDE_DEPTH )
                     {
                     fprintf( stderr, "Includes nested too deeply" );
                     exit( 1 );
                     }

                 include_stack[include_stack_ptr++] =
                     YY_CURRENT_BUFFER;

                 yyin = fopen( yytext, "r" );

                 if ( ! yyin )
                     error( ... );

                 yy_switch_to_buffer(
                     yy_create_buffer( yyin, YY_BUF_SIZE ) );

                 BEGIN(INITIAL);
                 }

         <<EOF>> {
                 if ( --include_stack_ptr < 0 )
                     {
                     yyterminate();
                     }




Version 2.4        Last change: November 1993                  20






FLEXDOC(1)                User Commands                FLEXDOC(1)



                 else
                     {
                     yy_delete_buffer( YY_CURRENT_BUFFER );
                     yy_switch_to_buffer(
                          include_stack[include_stack_ptr] );
                     }
                 }


EEEENNNNDDDD----OOOOFFFF----FFFFIIIILLLLEEEE RRRRUUUULLLLEEEESSSS
     The special rule "<<EOF>>" indicates actions which are to be
     taken  when  an  end-of-file  is  encountered  and  yywrap()
     returns non-zero (i.e., indicates no further files  to  pro-
     cess).  The action must finish by doing one of four things:

     -    assigning _y_y_i_n to a new input file  (in  previous  ver-
          sions  of  flex,  after doing the assignment you had to
          call the special action YYYYYYYY____NNNNEEEEWWWW____FFFFIIIILLLLEEEE;;;; this is no  longer
          necessary);

     -    executing a _r_e_t_u_r_n statement;

     -    executing the special yyyyyyyytttteeeerrrrmmmmiiiinnnnaaaatttteeee(((()))) action;

     -    or,    switching    to    a    new     buffer     using
          yyyyyyyy____sssswwwwiiiittttcccchhhh____ttttoooo____bbbbuuuuffffffffeeeerrrr(((()))) as shown in the example above.

     <<EOF>> rules may not be used with other patterns; they  may
     only  be  qualified  with a list of start conditions.  If an
     unqualified <<EOF>> rule is given, it applies to  _a_l_l  start
     conditions  which  do  not already have <<EOF>> actions.  To
     specify an <<EOF>> rule for only the  initial  start  condi-
     tion, use

         <INITIAL><<EOF>>


     These rules are useful for  catching  things  like  unclosed
     comments.  An example:

         %x quote
         %%

         ...other rules for dealing with quotes...

         <quote><<EOF>>   {
                  error( "unterminated quote" );
                  yyterminate();
                  }
         <<EOF>>  {
                  if ( *++filelist )
                      yyin = fopen( *filelist, "r" );



Version 2.4        Last change: November 1993                  21






FLEXDOC(1)                User Commands                FLEXDOC(1)



                  else
                     yyterminate();
                  }


MMMMIIIISSSSCCCCEEEELLLLLLLLAAAANNNNEEEEOOOOUUUUSSSS MMMMAAAACCCCRRRROOOOSSSS
     The macro YY_USER_ACTION can be defined to provide an action
     which is always executed prior to the matched rule's action.
     For example, it could be #define'd to call a routine to con-
     vert yytext to lower-case.

     The macro YYYYYYYY____UUUUSSSSEEEERRRR____IIIINNNNIIIITTTT may be defined to provide  an  action
     which  is  always executed before the first scan (and before
     the scanner's internal initializations are done).  For exam-
     ple,  it  could  be used to call a routine to read in a data
     table or open a logging file.

     In the generated scanner, the actions are  all  gathered  in
     one  large  switch  statement  and separated using YYYYYYYY____BBBBRRRREEEEAAAAKKKK,,,,
     which may be redefined.  By default, it is simply a "break",
     to  separate  each  rule's action from the following rule's.
     Redefining  YYYYYYYY____BBBBRRRREEEEAAAAKKKK  allows,  for  example,  C++  users  to
     #define  YY_BREAK  to  do  nothing (while being very careful
     that every rule ends with a "break" or a "return"!) to avoid
     suffering  from unreachable statement warnings where because
     a rule's action ends with "return", the YYYYYYYY____BBBBRRRREEEEAAAAKKKK is inacces-
     sible.

IIIINNNNTTTTEEEERRRRFFFFAAAACCCCIIIINNNNGGGG WWWWIIIITTTTHHHH YYYYAAAACCCCCCCC
     One of the main uses of _f_l_e_x is as a companion to  the  _y_a_c_c
     parser-generator.   _y_a_c_c  parsers  expect  to call a routine
     named yyyyyyyylllleeeexxxx(((()))) to find the next input token.  The routine  is
     supposed  to  return  the  type of the next token as well as
     putting any associated value in the global  yyyyyyyyllllvvvvaaaallll....  To  use
     _f_l_e_x  with  _y_a_c_c,  one  specifies  the  ----dddd option to _y_a_c_c to
     instruct it to generate the file yyyy....ttttaaaabbbb....hhhh containing  defini-
     tions  of all the %%%%ttttooookkkkeeeennnnssss appearing in the _y_a_c_c input.  This
     file is then included in the _f_l_e_x scanner.  For example,  if
     one of the tokens is "TOK_NUMBER", part of the scanner might
     look like:

         %{
         #include "y.tab.h"
         %}

         %%

         [0-9]+        yylval = atoi( yytext ); return TOK_NUMBER;


OOOOPPPPTTTTIIIIOOOONNNNSSSS
     _f_l_e_x has the following options:



Version 2.4        Last change: November 1993                  22






FLEXDOC(1)                User Commands                FLEXDOC(1)



     ----bbbb    Generate backing-up information to _l_e_x._b_a_c_k_u_p. This is
          a  list  of scanner states which require backing up and
          the input characters on which they do  so.   By  adding
          rules   one  can  remove  backing-up  states.   If  all
          backing-up states are eliminated and ----CCCCffff  or   ---- CCCCFFFF  is
          used, the generated scanner will run faster (see the ----pppp
          flag).  Only users who wish to squeeze every last cycle
          out  of  their  scanners  need worry about this option.
          (See the section on Performance Considerations below.)

     ----cccc    is a do-nothing, deprecated option included for  POSIX
          compliance.

          NNNNOOOOTTTTEEEE:::: in previous releases of _f_l_e_x ----cccc specified  table-
          compression  options.   This functionality is now given
          by the ----CCCC flag.  To ease the the impact of this change,
          when  _f_l_e_x encounters ----cccc,,,, it currently issues a warning
          message and assumes that ----CCCC was  desired  instead.   In
          the future this "promotion" of ----cccc to ----CCCC will go away in
          the name of full POSIX  compliance  (unless  the  POSIX
          meaning is removed first).

     ----dddd    makes the generated scanner run in _d_e_b_u_g mode.   When-
          ever   a   pattern   is   recognized   and  the  global
          yyyyyyyy____fffflllleeeexxxx____ddddeeeebbbbuuuugggg is non-zero (which is the  default),  the
          scanner will write to _s_t_d_e_r_r a line of the form:

              --accepting rule at line 53 ("the matched text")

          The line number refers to the location of the  rule  in
          the  file defining the scanner (i.e., the file that was
          fed to flex).  Messages are  also  generated  when  the
          scanner backs up, accepts the default rule, reaches the
          end of its input buffer (or encounters a NUL;  at  this
          point,  the  two  look the same as far as the scanner's
          concerned), or reaches an end-of-file.

     ----ffff    specifies _f_a_s_t _s_c_a_n_n_e_r. No table compression  is  done
          and  stdio  is bypassed.  The result is large but fast.
          This option is equivalent to ----CCCCffffrrrr (see below).

     ----hhhh    generates a "help" summary of _f_l_e_x'_s options to _s_t_d_e_r_r
          and then exits.

     ----iiii    instructs _f_l_e_x to generate a _c_a_s_e-_i_n_s_e_n_s_i_t_i_v_e scanner.
          The  case  of  letters given in the _f_l_e_x input patterns
          will be ignored,  and  tokens  in  the  input  will  be
          matched  regardless of case.  The matched text given in
          _y_y_t_e_x_t will have the preserved case (i.e., it will  not
          be folded).

     ----llll    turns on maximum compatibility with the original  AT&T



Version 2.4        Last change: November 1993                  23






FLEXDOC(1)                User Commands                FLEXDOC(1)



          _l_e_x  implementation.  Note that this does not mean _f_u_l_l
          compatibility.  Use of this option costs a considerable
          amount of performance, and it cannot be used with the ----
          ++++,,,, ----ffff,,,, ----FFFF,,,, ----CCCCffff,,,, or ----CCCCFFFF options.   For  details  on  the
          compatibilities  it provides, see the section "Incompa-
          tibilities With Lex And POSIX" below.

     ----nnnn    is another do-nothing, deprecated option included only
          for POSIX compliance.

     ----pppp    generates a performance report to stderr.  The  report
          consists  of  comments  regarding  features of the _f_l_e_x
          input file which will cause a serious loss  of  perfor-
          mance  in  the resulting scanner.  If you give the flag
          twice, you will also get  comments  regarding  features
          that lead to minor performance losses.

          Note that the use of RRRREEEEJJJJEEEECCCCTTTT and variable trailing  con-
          text  (see  the Bugs section in flex(1)) entails a sub-
          stantial performance penalty; use of  _y_y_m_o_r_e(),  the  ^^^^
          operator,  and  the   ---- IIII flag entail minor performance
          penalties.

     ----ssss    causes the _d_e_f_a_u_l_t _r_u_l_e (that unmatched scanner  input
          is  echoed to _s_t_d_o_u_t) to be suppressed.  If the scanner
          encounters input that does not match any of its  rules,
          it  aborts  with  an  error.  This option is useful for
          finding holes in a scanner's rule set.

     ----tttt    instructs _f_l_e_x to write the scanner  it  generates  to
          standard output instead of lllleeeexxxx....yyyyyyyy....cccc....

     ----vvvv    specifies that _f_l_e_x should write to _s_t_d_e_r_r  a  summary
          of statistics regarding the scanner it generates.  Most
          of the statistics are meaningless to  the  casual  _f_l_e_x
          user, but the first line identifies the version of _f_l_e_x
          (same as reported by ----VVVV)))),,,, and the next line  the  flags
          used  when generating the scanner, including those that
          are on by default.

     ----wwww    suppresses warning messages.

     ----BBBB    instructs _f_l_e_x to generate a _b_a_t_c_h scanner, the  oppo-
          site  of  _i_n_t_e_r_a_c_t_i_v_e  scanners  generated  by  ----IIII (see
          below).  In general, you use ----BBBB when  you  are  _c_e_r_t_a_i_n
          that your scanner will never be used interactively, and
          you want to squeeze a _l_i_t_t_l_e more  performance  out  of
          it.   If your goal is instead to squeeze out a _l_o_t more
          performance, you should  be using the   ---- CCCCffff  or   ---- CCCCFFFF
          options  (discussed  below), which turn on ----BBBB automati-
          cally anyway.




Version 2.4        Last change: November 1993                  24






FLEXDOC(1)                User Commands                FLEXDOC(1)



     ----FFFF    specifies that the _f_a_s_t scanner  table  representation
          should  be used (and stdio bypassed).  This representa-
          tion is about as fast as the full table  representation
          ((((----ffff)))),,,,  and  for some sets of patterns will be consider-
          ably smaller (and for others, larger).  In general,  if
          the  pattern  set contains both "keywords" and a catch-
          all, "identifier" rule, such as in the set:

              "case"    return TOK_CASE;
              "switch"  return TOK_SWITCH;
              ...
              "default" return TOK_DEFAULT;
              [a-z]+    return TOK_ID;

          then you're better off using the full table representa-
          tion.  If only the "identifier" rule is present and you
          then use a hash table or some such to detect  the  key-
          words, you're better off using ----FFFF....

          This option is equivalent to ----CCCCFFFFrrrr (see below).  It can-
          not be used with ----++++....

     ----IIII    instructs _f_l_e_x to generate an _i_n_t_e_r_a_c_t_i_v_e scanner.  An
          interactive  scanner  is  one  that only looks ahead to
          decide what token has been  matched  if  it  absolutely
          must.  It turns out that always looking one extra char-
          acter ahead, even  if  the  scanner  has  already  seen
          enough text to disambiguate the current token, is a bit
          faster than only looking  ahead  when  necessary.   But
          scanners  that always look ahead give dreadful interac-
          tive performance; for example, when a user types a new-
          line,  it  is  not  recognized as a newline token until
          they enter _a_n_o_t_h_e_r token, which often means  typing  in
          another whole line.

          _F_l_e_x scanners default to _i_n_t_e_r_a_c_t_i_v_e unless you use the
           ---- CCCCffff  or   ---- CCCCFFFF table-compression options (see below).
          That's because if you're looking  for  high-performance
          you  should  be  using  one of these options, so if you
          didn't, _f_l_e_x assumes you'd rather trade off  a  bit  of
          run-time    performance   for   intuitive   interactive
          behavior.  Note also that you _c_a_n_n_o_t use ----IIII in conjunc-
          tion  with  ----CCCCffff or ----CCCCFFFF.... Thus, this option is not really
          needed; it is on by default  for  all  those  cases  in
          which it is allowed.

          You can force a scanner to _n_o_t be interactive by using
          ----BBBB (see above).

     ----LLLL    instructs  _f_l_e_x  not  to  generate  ####lllliiiinnnneeee  directives.
          Without this option, _f_l_e_x peppers the generated scanner
          with #line directives so error messages in the  actions



Version 2.4        Last change: November 1993                  25






FLEXDOC(1)                User Commands                FLEXDOC(1)



          will  be correctly located with respect to the original
          _f_l_e_x input file, and not to the fairly meaningless line
          numbers  of  lllleeeexxxx....yyyyyyyy....cccc....  (Unfortunately  _f_l_e_x  does  not
          presently generate the necessary directives to  "retar-
          get" the line numbers for those parts of lllleeeexxxx....yyyyyyyy....cccc which
          it generated.  So if there is an error in the generated
          code, a meaningless line number is reported.)

     ----TTTT    makes _f_l_e_x run in _t_r_a_c_e mode.  It will generate a  lot
          of  messages to _s_t_d_e_r_r concerning the form of the input
          and the resultant non-deterministic  and  deterministic
          finite  automata.   This  option  is  mostly for use in
          maintaining _f_l_e_x.

     ----VVVV    prints the version number to _s_t_d_e_r_r and exits.

     ----7777    instructs _f_l_e_x to generate a 7-bit scanner, i.e.,  one
          which  can  only  recognized  7-bit  characters  in its
          input.  The advantage of using ----7777 is that the scanner's
          tables  can  be  up to half the size of those generated
          using the ----8888 option (see below).  The  disadvantage  is
          that  such  scanners often hang or crash if their input
          contains an 8-bit character.

          Note, however, that unless you  generate  your  scanner
          using the ----CCCCffff or ----CCCCFFFF table compression options, use of
          ----7777 will save only a small amount of  table  space,  and
          make  your  scanner considerably less portable.  _F_l_e_x'_s
          default behavior is to generate an 8-bit scanner unless
          you  use the ----CCCCffff or ----CCCCFFFF,,,, in which case _f_l_e_x defaults to
          generating 7-bit scanners unless your site  was  always
          configured to generate 8-bit scanners (as will often be
          the case with non-USA sites).   You  can  tell  whether
          flex  generated a 7-bit or an 8-bit scanner by inspect-
          ing the flag summary in the  ---- vvvv  output  as  described
          above.

          Note that if you use ----CCCCffffeeee or ----CCCCFFFFeeee (those table compres-
          sion  options,  but  also  using equivalence classes as
          discussed see below), flex still defaults to generating
          an  8-bit scanner, since usually with these compression
          options full 8-bit tables are not much  more  expensive
          than 7-bit tables.

     ----8888    instructs _f_l_e_x to generate an 8-bit scanner, i.e., one
          which  can  recognize  8-bit  characters.  This flag is
          only needed for scanners generated using ----CCCCffff or ----CCCCFFFF,,,, as
          otherwise  flex defaults to generating an 8-bit scanner
          anyway.

          See the discussion of  ---- 7777  above  for  flex's  default
          behavior  and  the  tradeoffs  between  7-bit and 8-bit



Version 2.4        Last change: November 1993                  26






FLEXDOC(1)                User Commands                FLEXDOC(1)



          scanners.

     ----++++    specifies that you want flex to generate a C++ scanner
          class.   See  the  section  on  Generating C++ Scanners
          below for details.

     ----CCCC[[[[aaaaeeeeffffFFFFmmmmrrrr]]]]
          controls the degree of table compression and, more gen-
          erally,  trade-offs  between  small  scanners  and fast
          scanners.

          ----CCCCaaaa ("align") instructs flex to trade off larger tables
          in the generated scanner for faster performance because
          the elements of  the  tables  are  better  aligned  for
          memory  access and computation.  On some RISC architec-
          tures, fetching  and  manipulating  longwords  is  more
          efficient than with smaller-sized datums such as short-
          words.  This option can double the size of  the  tables
          used by your scanner.

          ----CCCCeeee directs  _f_l_e_x  to  construct  _e_q_u_i_v_a_l_e_n_c_e  _c_l_a_s_s_e_s,
          i.e.,  sets  of characters which have identical lexical
          properties (for example,  if  the  only  appearance  of
          digits  in  the  _f_l_e_x  input  is in the character class
          "[0-9]" then the digits '0', '1', ..., '9' will all  be
          put   in  the  same  equivalence  class).   Equivalence
          classes usually give dramatic reductions in  the  final
          table/object file sizes (typically a factor of 2-5) and
          are pretty cheap performance-wise  (one  array  look-up
          per character scanned).

          ----CCCCffff specifies that the _f_u_l_l scanner  tables  should  be
          generated - _f_l_e_x should not compress the tables by tak-
          ing advantages of similar transition functions for dif-
          ferent states.

          ----CCCCFFFF specifies that the alternate fast scanner represen-
          tation  (described  above  under the ----FFFF flag) should be
          used.  This option cannot be used with ----++++....

          ----CCCCmmmm directs _f_l_e_x to construct _m_e_t_a-_e_q_u_i_v_a_l_e_n_c_e _c_l_a_s_s_e_s,
          which  are  sets of equivalence classes (or characters,
          if equivalence classes are not  being  used)  that  are
          commonly  used  together.  Meta-equivalence classes are
          often a big win when using compressed tables, but  they
          have  a  moderate  performance  impact (one or two "if"
          tests and one array look-up per character scanned).

          ----CCCCrrrr causes the generated scanner to _b_y_p_a_s_s use  of  the
          standard  I/O  library  (stdio)  for input.  Instead of
          calling ffffrrrreeeeaaaadddd(((()))) or ggggeeeettttcccc(((()))),,,, the  scanner  will  use  the
          rrrreeeeaaaadddd(((())))  system  call,  resulting  in a performance gain



Version 2.4        Last change: November 1993                  27






FLEXDOC(1)                User Commands                FLEXDOC(1)



          which varies from system to system, but in  general  is
          probably  negligible unless you are also using ----CCCCffff or ----
          CCCCFFFF.... Using ----CCCCrrrr can cause strange behavior if, for  exam-
          ple,  you  read  from _y_y_i_n using stdio prior to calling
          the scanner (because the  scanner  will  miss  whatever
          text  your  previous  reads  left  in  the  stdio input
          buffer).

          ----CCCCrrrr has no effect if you define YYYYYYYY____IIIINNNNPPPPUUUUTTTT (see The  Gen-
          erated Scanner above).

          A lone ----CCCC specifies that the scanner tables  should  be
          compressed  but  neither  equivalence classes nor meta-
          equivalence classes should be used.

          The options ----CCCCffff or ----CCCCFFFF and   ---- CCCCmmmm  do  not  make  sense
          together - there is no opportunity for meta-equivalence
          classes if the table is not being  compressed.   Other-
          wise  the  options may be freely mixed, and are cumula-
          tive.

          The default setting is ----CCCCeeeemmmm,,,, which specifies that  _f_l_e_x
          should   generate   equivalence   classes   and   meta-
          equivalence classes.  This setting provides the highest
          degree   of  table  compression.   You  can  trade  off
          faster-executing scanners at the cost of larger  tables
          with the following generally being true:

              slowest & smallest
                    -Cem
                    -Cm
                    -Ce
                    -C
                    -C{f,F}e
                    -C{f,F}
                    -C{f,F}a
              fastest & largest

          Note that scanners with the smallest tables are usually
          generated and compiled the quickest, so during develop-
          ment you will usually want to use the default,  maximal
          compression.

          ----CCCCffffeeee is often a good compromise between speed and  size
          for production scanners.

     ----PPPPpppprrrreeeeffffiiiixxxx
          changes the default _y_y prefix  used  by  _f_l_e_x  for  all
          globally-visible variable and function names to instead
          be _p_r_e_f_i_x. For example,  ---- PPPPffffoooooooo  changes  the  name  of
          yyyyyyyytttteeeexxxxtttt  to  ffffooooooootttteeeexxxxtttt....  It  also  changes the name of the
          default output file from lllleeeexxxx....yyyyyyyy....cccc  to  lllleeeexxxx....ffffoooooooo....cccc....  Here



Version 2.4        Last change: November 1993                  28






FLEXDOC(1)                User Commands                FLEXDOC(1)



          are all of the names affected:

              yyFlexLexer
              yy_create_buffer
              yy_delete_buffer
              yy_flex_debug
              yy_init_buffer
              yy_load_buffer_state
              yy_switch_to_buffer
              yyin
              yyleng
              yylex
              yyout
              yyrestart
              yytext
              yywrap

          Within your scanner itself, you can still refer to  the
          global  variables and functions using either version of
          their name; but eternally, they have the modified name.

          This option lets you easily link together multiple _f_l_e_x
          programs  into the same executable.  Note, though, that
          using this option also renames  yyyyyyyywwwwrrrraaaapppp(((()))),,,,  so  you  now
          _m_u_s_t  provide your own (appropriately-named) version of
          the routine for your scanner, as linking with ---- llllffffllll  no
          longer provides one for you by default.

     ----SSSSsssskkkkeeeelllleeeettttoooonnnn____ffffiiiilllleeee
          overrides the default skeleton  file  from  which  _f_l_e_x
          constructs its scanners.  You'll never need this option
          unless you are doing _f_l_e_x maintenance or development.

PPPPEEEERRRRFFFFOOOORRRRMMMMAAAANNNNCCCCEEEE CCCCOOOONNNNSSSSIIIIDDDDEEEERRRRAAAATTTTIIIIOOOONNNNSSSS
     The main design goal of  _f_l_e_x  is  that  it  generate  high-
     performance  scanners.   It  has  been optimized for dealing
     well with large sets of rules.  Aside from  the  effects  on
     scanner  speed  of the table compression ----CCCC options outlined
     above, there are a number of options/actions  which  degrade
     performance.  These are, from most expensive to least:

         REJECT

         pattern sets that require backing up
         arbitrary trailing context

         yymore()
         '^' beginning-of-line operator

     with the first three all being quite expensive and the  last
     two  being  quite  cheap.   Note also that uuuunnnnppppuuuutttt(((()))) is imple-
     mented as a routine call that potentially does quite  a  bit



Version 2.4        Last change: November 1993                  29






FLEXDOC(1)                User Commands                FLEXDOC(1)



     of  work,  while yyyyyyyylllleeeessssssss(((()))) is a quite-cheap macro; so if just
     putting back some excess text you scanned, use yyyyyyyylllleeeessssssss(((())))....

     RRRREEEEJJJJEEEECCCCTTTT should be avoided at all costs  when  performance  is
     important.  It is a particularly expensive option.

     Getting rid of backing up is messy and often may be an enor-
     mous  amount  of work for a complicated scanner.  In princi-
     pal, one begins  by  using  the   ---- bbbb  flag  to  generate  a
     _l_e_x._b_a_c_k_u_p file.  For example, on the input

         %%
         foo        return TOK_KEYWORD;
         foobar     return TOK_KEYWORD;

     the file looks like:

         State #6 is non-accepting -
          associated rule line numbers:
                2       3
          out-transitions: [ o ]
          jam-transitions: EOF [ \001-n  p-\177 ]

         State #8 is non-accepting -
          associated rule line numbers:
                3
          out-transitions: [ a ]
          jam-transitions: EOF [ \001-`  b-\177 ]

         State #9 is non-accepting -
          associated rule line numbers:
                3
          out-transitions: [ r ]
          jam-transitions: EOF [ \001-q  s-\177 ]

         Compressed tables always back up.

     The first few lines tell us that there's a scanner state  in
     which  it  can  make  a  transition on an 'o' but not on any
     other character,  and  that  in  that  state  the  currently
     scanned text does not match any rule.  The state occurs when
     trying to match the rules found at lines  2  and  3  in  the
     input  file.  If the scanner is in that state and then reads
     something other than an 'o', it will have to back up to find
     a  rule  which is matched.  With a bit of headscratching one
     can see that this must be the state it's in when it has seen
     "fo".   When  this  has  happened,  if  anything  other than
     another 'o' is seen, the scanner will have  to  back  up  to
     simply match the 'f' (by the default rule).

     The comment regarding State #8 indicates there's  a  problem
     when  "foob"  has  been  scanned.   Indeed, on any character



Version 2.4        Last change: November 1993                  30






FLEXDOC(1)                User Commands                FLEXDOC(1)



     other than an 'a', the scanner  will  have  to  back  up  to
     accept  "foo".  Similarly, the comment for State #9 concerns
     when "fooba" has been scanned and an 'r' does not follow.

     The final comment reminds us that there's no point going  to
     all the trouble of removing backing up from the rules unless
     we're using ----CCCCffff or ----CCCCFFFF,,,, since there's  no  performance  gain
     doing so with compressed scanners.

     The way to remove the backing up is to add "error" rules:

         %%
         foo         return TOK_KEYWORD;
         foobar      return TOK_KEYWORD;

         fooba       |
         foob        |
         fo          {
                     /* false alarm, not really a keyword */
                     return TOK_ID;
                     }


     Eliminating backing up among a list of keywords can also  be
     done using a "catch-all" rule:

         %%
         foo         return TOK_KEYWORD;
         foobar      return TOK_KEYWORD;

         [a-z]+      return TOK_ID;

     This is usually the best solution when appropriate.

     Backing up messages tend to cascade.  With a complicated set
     of  rules it's not uncommon to get hundreds of messages.  If
     one can decipher them, though, it often only takes  a  dozen
     or so rules to eliminate the backing up (though it's easy to
     make a mistake and have an error rule accidentally  match  a
     valid  token.   A  possible  future  _f_l_e_x feature will be to
     automatically add rules to eliminate backing up).

     _V_a_r_i_a_b_l_e trailing context (where both the leading and trail-
     ing  parts  do  not  have a fixed length) entails almost the
     same performance loss as  RRRREEEEJJJJEEEECCCCTTTT  (i.e.,  substantial).   So
     when possible a rule like:

         %%
         mouse|rat/(cat|dog)   run();

     is better written:




Version 2.4        Last change: November 1993                  31






FLEXDOC(1)                User Commands                FLEXDOC(1)



         %%
         mouse/cat|dog         run();
         rat/cat|dog           run();

     or as

         %%
         mouse|rat/cat         run();
         mouse|rat/dog         run();

     Note that here the special '|' action does _n_o_t  provide  any
     savings, and can even make things worse (see

     A final note regarding performance: as  mentioned  above  in
     the  section  How the Input is Matched, dynamically resizing
     yyyyyyyytttteeeexxxxtttt to accomodate huge tokens is a slow  process  because
     it  presently  requires  that  the (huge) token be rescanned
     from the beginning.   Thus  if  performance  is  vital,  you
     should  attempt  to match "large" quantities of text but not
     "huge" quantities, where the cutoff between the  two  is  at
     about 8K characters/token.

     Another area where the user can increase a scanner's perfor-
     mance  (and  one that's easier to implement) arises from the
     fact that the longer the  tokens  matched,  the  faster  the
     scanner will run.  This is because with long tokens the pro-
     cessing of most input characters takes place in the  (short)
     inner  scanning  loop, and does not often have to go through
     the additional work of setting up the  scanning  environment
     (e.g.,  yyyyyyyytttteeeexxxxtttt))))  for  the  action.  Recall the scanner for C
     comments:

         %x comment
         %%
                 int line_num = 1;

         "/*"         BEGIN(comment);

         <comment>[^*\n]*
         <comment>"*"+[^*/\n]*
         <comment>\n             ++line_num;
         <comment>"*"+"/"        BEGIN(INITIAL);

     This could be sped up by writing it as:

         %x comment
         %%
                 int line_num = 1;

         "/*"         BEGIN(comment);

         <comment>[^*\n]*



Version 2.4        Last change: November 1993                  32






FLEXDOC(1)                User Commands                FLEXDOC(1)



         <comment>[^*\n]*\n      ++line_num;
         <comment>"*"+[^*/\n]*
         <comment>"*"+[^*/\n]*\n ++line_num;
         <comment>"*"+"/"        BEGIN(INITIAL);

     Now instead of each  newline  requiring  the  processing  of
     another  action,  recognizing  the newlines is "distributed"
     over the other rules to keep the matched  text  as  long  as
     possible.   Note  that  _a_d_d_i_n_g  rules does _n_o_t slow down the
     scanner!  The speed of the scanner  is  independent  of  the
     number  of  rules or (modulo the considerations given at the
     beginning of this section) how  complicated  the  rules  are
     with regard to operators such as '*' and '|'.

     A final example in speeding up a scanner: suppose  you  want
     to  scan through a file containing identifiers and keywords,
     one per line and with no other  extraneous  characters,  and
     recognize all the keywords.  A natural first approach is:

         %%
         asm      |
         auto     |
         break    |
         ... etc ...
         volatile |
         while    /* it's a keyword */

         .|\n     /* it's not a keyword */

     To eliminate the back-tracking, introduce a catch-all rule:

         %%
         asm      |
         auto     |
         break    |
         ... etc ...
         volatile |
         while    /* it's a keyword */

         [a-z]+   |
         .|\n     /* it's not a keyword */

     Now, if it's guaranteed that there's exactly  one  word  per
     line,  then  we  can reduce the total number of matches by a
     half by merging in the recognition of newlines with that  of
     the other tokens:

         %%
         asm\n    |
         auto\n   |
         break\n  |
         ... etc ...



Version 2.4        Last change: November 1993                  33






FLEXDOC(1)                User Commands                FLEXDOC(1)



         volatile\n |
         while\n  /* it's a keyword */

         [a-z]+\n |
         .|\n     /* it's not a keyword */

     One has to be careful here,  as  we  have  now  reintroduced
     backing  up  into the scanner.  In particular, while _w_e know
     that there will never be any characters in the input  stream
     other  than letters or newlines, _f_l_e_x can't figure this out,
     and it will plan for possibly needing to back up when it has
     scanned  a  token like "auto" and then the next character is
     something other than a newline or a letter.   Previously  it
     would  then  just match the "auto" rule and be done, but now
     it has no "auto" rule, only a "auto\n" rule.   To  eliminate
     the possibility of backing up, we could either duplicate all
     rules but without final newlines, or, since we never  expect
     to  encounter  such  an  input  and therefore don't how it's
     classified, we can introduce one more catch-all  rule,  this
     one which doesn't include a newline:

         %%
         asm\n    |
         auto\n   |
         break\n  |
         ... etc ...
         volatile\n |
         while\n  /* it's a keyword */

         [a-z]+\n |
         [a-z]+   |
         .|\n     /* it's not a keyword */

     Compiled with ----CCCCffff,,,, this is about as fast as one  can  get  a
     _f_l_e_x scanner to go for this particular problem.

     A final note:  _f_l_e_x is slow when  matching  NUL's,  particu-
     larly  when  a  token contains multiple NUL's.  It's best to
     write rules which match _s_h_o_r_t amounts of text if it's  anti-
     cipated that the text will often include NUL's.

GGGGEEEENNNNEEEERRRRAAAATTTTIIIINNNNGGGG CCCC++++++++ SSSSCCCCAAAANNNNNNNNEEEERRRRSSSS
     _f_l_e_x provides two different ways to  generate  scanners  for
     use  with C++.  The first way is to simply compile a scanner
     generated by _f_l_e_x using a C++ compiler instead of a  C  com-
     piler.   You  should  not  encounter any compilations errors
     (please report any you find to the email  address  given  in
     the  Author  section  below).   You can then use C++ code in
     your rule actions instead of C code.  Note that the  default
     input  source  for  your  scanner  remains _y_y_i_n, and default
     echoing is still done to _y_y_o_u_t. Both of these remain _F_I_L_E  *
     variables and not C++ _s_t_r_e_a_m_s.



Version 2.4        Last change: November 1993                  34






FLEXDOC(1)                User Commands                FLEXDOC(1)



     You can also use _f_l_e_x to generate a C++ scanner class, using
     the  ----++++ option, which is automatically specified if the name
     of the flex executable ends in a '+', such as  _f_l_e_x++.  When
     using  this  option, flex defaults to generating the scanner
     to the file lllleeeexxxx....yyyyyyyy....cccccccc instead  of  lllleeeexxxx....yyyyyyyy....cccc....  The  generated
     scanner  includes the header file _F_l_e_x_L_e_x_e_r._h, which defines
     the interface to two C++ classes.

     The first class, FFFFlllleeeexxxxLLLLeeeexxxxeeeerrrr,,,, provides an abstract base  class
     defining  the  general scanner class interface.  It provides
     the following member functions:

     ccccoooonnnnsssstttt cccchhhhaaaarrrr**** YYYYYYYYTTTTeeeexxxxtttt(((())))
          returns the text of the most  recently  matched  token,
          the equivalent of yyyyyyyytttteeeexxxxtttt....

     iiiinnnntttt YYYYYYYYLLLLeeeennnngggg(((())))
          returns the length of the most recently matched  token,
          the equivalent of yyyyyyyylllleeeennnngggg....

     Also   provided   are   member   functions   equivalent   to
     yyyyyyyy____sssswwwwiiiittttcccchhhh____ttttoooo____bbbbuuuuffffffffeeeerrrr(((()))),,,,  yyyyyyyy____ccccrrrreeeeaaaatttteeee____bbbbuuuuffffffffeeeerrrr(((()))) (though the first
     argument is an iiiissssttttrrrreeeeaaaammmm**** object pointer  and  not  a  FFFFIIIILLLLEEEE****)))),,,,
     yyyyyyyy____ddddeeeelllleeeetttteeee____bbbbuuuuffffffffeeeerrrr(((()))),,,,  and yyyyyyyyrrrreeeessssttttaaaarrrrtttt(((()))) (again, the first argu-
     ment is a iiiissssttttrrrreeeeaaaammmm**** object pointer).

     The second class  defined  in  _F_l_e_x_L_e_x_e_r._h  is  yyyyyyyyFFFFlllleeeexxxxLLLLeeeexxxxeeeerrrr,,,,
     which  is  derived  from FFFFlllleeeexxxxLLLLeeeexxxxeeeerrrr.... It defines the following
     additional member functions:

     yyyyyyyyFFFFlllleeeexxxxLLLLeeeexxxxeeeerrrr(((( iiiissssttttrrrreeeeaaaammmm**** aaaarrrrgggg____yyyyyyyyiiiinnnn ==== 0000,,,, oooossssttttrrrreeeeaaaammmm**** aaaarrrrgggg____yyyyyyyyoooouuuutttt ==== 0000 ))))
          constructs a yyyyyyyyFFFFlllleeeexxxxLLLLeeeexxxxeeeerrrr object using the given streams
          for  input  and  output.  If not specified, the streams
          default to cccciiiinnnn and ccccoooouuuutttt,,,, respectively.

     vvvviiiirrrrttttuuuuaaaallll iiiinnnntttt yyyyyyyylllleeeexxxx(((())))
          performs the same role is  yyyyyyyylllleeeexxxx(((())))  does  for  ordinary
          flex  scanners:  it  scans  the input stream, consuming
          tokens, until a rule's action returns a value.

     In addition, yyyyyyyyFFFFlllleeeexxxxLLLLeeeexxxxeeeerrrr  defines  the  following  protected
     virtual  functions which you can redefine in derived classes
     to tailor the scanner:

     vvvviiiirrrrttttuuuuaaaallll iiiinnnntttt LLLLeeeexxxxeeeerrrrIIIInnnnppppuuuutttt(((( cccchhhhaaaarrrr**** bbbbuuuuffff,,,, iiiinnnntttt mmmmaaaaxxxx____ssssiiiizzzzeeee ))))
          reads up to mmmmaaaaxxxx____ssssiiiizzzzeeee characters into  bbbbuuuuffff  and  returns
          the  number  of  characters  read.  To indicate end-of-
          input, return 0 characters.   Note  that  "interactive"
          scanners  (see  the   ----BBBB and ----IIII flags) define the macro
          YYYYYYYY____IIIINNNNTTTTEEEERRRRAAAACCCCTTTTIIIIVVVVEEEE.... If you redefine LLLLeeeexxxxeeeerrrrIIIInnnnppppuuuutttt(((())))  and  need
          to  take  different actions depending on whether or not
          the scanner might  be  scanning  an  interactive  input



Version 2.4        Last change: November 1993                  35






FLEXDOC(1)                User Commands                FLEXDOC(1)



          source,  you can test for the presence of this name via
          ####iiiiffffddddeeeeffff....

     vvvviiiirrrrttttuuuuaaaallll vvvvooooiiiidddd LLLLeeeexxxxeeeerrrrOOOOuuuuttttppppuuuutttt(((( ccccoooonnnnsssstttt cccchhhhaaaarrrr**** bbbbuuuuffff,,,, iiiinnnntttt ssssiiiizzzzeeee ))))
          writes out ssssiiiizzzzeeee characters from the buffer bbbbuuuuffff,,,,  which,
          while NUL-terminated, may also contain "internal" NUL's
          if the scanner's rules can match  text  with  NUL's  in
          them.

     vvvviiiirrrrttttuuuuaaaallll vvvvooooiiiidddd LLLLeeeexxxxeeeerrrrEEEErrrrrrrroooorrrr(((( ccccoooonnnnsssstttt cccchhhhaaaarrrr**** mmmmssssgggg ))))
          reports a fatal error message.  The default version  of
          this function writes the message to the stream cccceeeerrrrrrrr and
          exits.

     Note that a yyyyyyyyFFFFlllleeeexxxxLLLLeeeexxxxeeeerrrr object contains its _e_n_t_i_r_e  scanning
     state.   Thus  you  can use such objects to create reentrant
     scanners.  You can instantiate  multiple  instances  of  the
     same  yyyyyyyyFFFFlllleeeexxxxLLLLeeeexxxxeeeerrrr  class,  and you can also combine multiple
     C++ scanner classes together in the same program using the ----
     PPPP option discussed above.

     Finally, note that the %%%%aaaarrrrrrrraaaayyyy feature is  not  available  to
     C++ scanner classes; you must use %%%%ppppooooiiiinnnntttteeeerrrr (the default).

     Here is an example of a simple C++ scanner:

             // An example of using the flex C++ scanner class.

         %{
         int mylineno = 0;
         %}

         string  \"[^\n"]+\"

         ws      [ \t]+

         alpha   [A-Za-z]
         dig     [0-9]
         name    ({alpha}|{dig}|\$)({alpha}|{dig}|[_.\-/$])*
         num1    [-+]?{dig}+\.?([eE][-+]?{dig}+)?
         num2    [-+]?{dig}*\.{dig}+([eE][-+]?{dig}+)?
         number  {num1}|{num2}

         %%

         {ws}    /* skip blanks and tabs */

         "/*"    {
                 int c;

                 while((c = yyinput()) != 0)
                     {



Version 2.4        Last change: November 1993                  36






FLEXDOC(1)                User Commands                FLEXDOC(1)



                     if(c == '\n')
                         ++mylineno;

                     else if(c == '*')
                         {
                         if((c = yyinput()) == '/')
                             break;
                         else
                             unput(c);
                         }
                     }
                 }

         {number}  cout << "number " << YYText() << '\n';

         \n        mylineno++;

         {name}    cout << "name " << YYText() << '\n';

         {string}  cout << "string " << YYText() << '\n';

         %%

         int main( int /* argc */, char** /* argv */ )
             {
             FlexLexer* lexer = new yyFlexLexer;
             while(lexer->yylex() != 0)
                 ;
             return 0;
             }
     IMPORTANT: the present form of the scanning class is _e_x_p_e_r_i_-
     _m_e_n_t_a_l and may change considerably between major releases.

IIIINNNNCCCCOOOOMMMMPPPPAAAATTTTIIIIBBBBIIIILLLLIIIITTTTIIIIEEEESSSS WWWWIIIITTTTHHHH LLLLEEEEXXXX AAAANNNNDDDD PPPPOOOOSSSSIIIIXXXX
     _f_l_e_x is a rewrite of the AT&T Unix _l_e_x tool (the two  imple-
     mentations  do not share any code, though), with some exten-
     sions and incompatibilities, both of which are of concern to
     those who wish to write scanners acceptable to either imple-
     mentation.  The POSIX _l_e_x specification is closer to  _f_l_e_x'_s
     behavior  than  that of the original _l_e_x implementation, but
     there also remain some incompatibilities  between  _f_l_e_x  and
     POSIX.   The  intent  is  that ultimately _f_l_e_x will be fully
     POSIX-conformant.  In this section we  discuss  all  of  the
     known areas of incompatibility.

     _f_l_e_x'_s ----llll option turns on  maximum  compatibility  with  the
     original  AT&T  _l_e_x  implementation,  at the cost of a major
     loss in the generated scanner's performance.  We note  below
     which incompatibilities can be overcome using the ----llll option.

     _f_l_e_x is fully compatible with _l_e_x with the following  excep-
     tions:



Version 2.4        Last change: November 1993                  37






FLEXDOC(1)                User Commands                FLEXDOC(1)



     -    The undocumented _l_e_x scanner internal variable yyyyyyyylllliiiinnnneeeennnnoooo
          is not supported unless ----llll is used.

          yylineno is not part of the POSIX specification.

     -    The iiiinnnnppppuuuutttt(((()))) routine is not redefinable, though  it  may
          be  called  to  read  characters following whatever has
          been matched by a rule.  If iiiinnnnppppuuuutttt(((()))) encounters an  end-
          of-file  the  normal  yyyyyyyywwwwrrrraaaapppp(((())))  processing  is done.  A
          ``real'' end-of-file is returned by iiiinnnnppppuuuutttt(((()))) as _E_O_F.

          Input is instead controlled by  defining  the  YYYYYYYY____IIIINNNNPPPPUUUUTTTT
          macro.

          The _f_l_e_x restriction that iiiinnnnppppuuuutttt(((()))) cannot  be  redefined
          is  in  accordance  with the POSIX specification, which
          simply does not specify  any  way  of  controlling  the
          scanner's input other than by making an initial assign-
          ment to _y_y_i_n.

     -    _f_l_e_x scanners are not as reentrant as _l_e_x scanners.  In
          particular,  if  you have an interactive scanner and an
          interrupt handler which long-jumps out of the  scanner,
          and  the  scanner is subsequently called again, you may
          get the following message:

              fatal flex scanner internal error--end of buffer missed

          To reenter the scanner, first use

              yyrestart( yyin );

          Note that this call will throw away any buffered input;
          usually  this  isn't  a  problem  with  an  interactive
          scanner.

          Also note that flex C++ scanner classes _a_r_e  reentrant,
          so  if  using  C++ is an option for you, you should use
          them instead.  See "Generating C++ Scanners" above  for
          details.

     -    oooouuuuttttppppuuuutttt(((()))) is not supported.  Output from the EEEECCCCHHHHOOOO  macro
          is done to the file-pointer _y_y_o_u_t (default _s_t_d_o_u_t).

          oooouuuuttttppppuuuutttt(((()))) is not part of the POSIX specification.

     -    _l_e_x does not support exclusive start  conditions  (%x),
          though they are in the POSIX specification.

     -    When definitions are expanded, _f_l_e_x  encloses  them  in
          parentheses.  With lex, the following:




Version 2.4        Last change: November 1993                  38






FLEXDOC(1)                User Commands                FLEXDOC(1)



              NAME    [A-Z][A-Z0-9]*
              %%
              foo{NAME}?      printf( "Found it\n" );
              %%

          will not match the string "foo" because when the  macro
          is  expanded  the rule is equivalent to "foo[A-Z][A-Z0-
          9]*?"  and the precedence is such that the '?' is asso-
          ciated  with  "[A-Z0-9]*".  With _f_l_e_x, the rule will be
          expanded to "foo([A-Z][A-Z0-9]*)?" and  so  the  string
          "foo" will match.

          Note that if the definition begins with ^^^^ or ends  with
          $$$$  then  it  is _n_o_t expanded with parentheses, to allow
          these operators to appear in definitions without losing
          their  special  meanings.   But the <<<<ssss>>>>,,,, ////,,,, and <<<<<<<<EEEEOOOOFFFF>>>>>>>>
          operators cannot be used in a _f_l_e_x definition.

          Using ----llll results in the _l_e_x behavior of no  parentheses
          around the definition.

          The POSIX  specification  is  that  the  definition  be
          enclosed in parentheses.

     -    The _l_e_x %%%%rrrr (generate a Ratfor scanner)  option  is  not
          supported.  It is not part of the POSIX specification.

     -    After a call to uuuunnnnppppuuuutttt(((()))),,,, _y_y_t_e_x_t and  _y_y_l_e_n_g  are  unde-
          fined  until  the  next  token  is  matched, unless the
          scanner was built using %%%%aaaarrrrrrrraaaayyyy.... This is  not  the  case
          with  _l_e_x  or  the  POSIX specification.  The ----llll option
          does away with this incompatibility.

     -    The precedence of the {{{{}}}} (numeric  range)  operator  is
          different.   _l_e_x  interprets  "abc{1,3}" as "match one,
          two, or  three  occurrences  of  'abc'",  whereas  _f_l_e_x
          interprets  it  as "match 'ab' followed by one, two, or
          three occurrences of 'c'".  The latter is in  agreement
          with the POSIX specification.

     -    The precedence of the ^^^^  operator  is  different.   _l_e_x
          interprets  "^foo|bar"  as  "match  either 'foo' at the
          beginning of a line, or 'bar' anywhere",  whereas  _f_l_e_x
          interprets  it  as "match either 'foo' or 'bar' if they
          come at the beginning of a line".   The  latter  is  in
          agreement with the POSIX specification.

     -    _y_y_i_n is _i_n_i_t_i_a_l_i_z_e_d by _l_e_x to be _s_t_d_i_n;  _f_l_e_x,  on  the
          other  hand,  initializes _y_y_i_n to NULL and then _a_s_s_i_g_n_s
          it to _s_t_d_i_n the first time the scanner is called,  pro-
          viding _y_y_i_n has not already been assigned to a non-NULL
          value.  The difference is subtle, but the net effect is



Version 2.4        Last change: November 1993                  39






FLEXDOC(1)                User Commands                FLEXDOC(1)



          that  with  _f_l_e_x  scanners,  _y_y_i_n does not have a valid
          value until the scanner has been called.

          The ----llll option does away with this incompatibility.

     -    The special table-size declarations  such  as  %%%%aaaa  sup-
          ported  by  _l_e_x are not required by _f_l_e_x scanners; _f_l_e_x
          ignores them.

     -    The name FLEX_SCANNER is #define'd so scanners  may  be
          written for use with either _f_l_e_x or _l_e_x.

     The following _f_l_e_x features are not included in _l_e_x  or  the
     POSIX specification:

         yyterminate()
         <<EOF>>
         <*>
         YY_DECL
         YY_START
         YY_USER_ACTION
         #line directives
         %{}'s around actions
         multiple actions on a line

     plus almost all of the flex flags.  The last feature in  the
     list  refers to the fact that with _f_l_e_x you can put multiple
     actions on the same line, separated with semi-colons,  while
     with _l_e_x, the following

         foo    handle_foo(); ++num_foos_seen;

     is (rather surprisingly) truncated to

         foo    handle_foo();

     _f_l_e_x does not truncate the action.   Actions  that  are  not
     enclosed  in  braces are simply terminated at the end of the
     line.

DDDDIIIIAAAAGGGGNNNNOOOOSSSSTTTTIIIICCCCSSSS
     _w_a_r_n_i_n_g, _r_u_l_e _c_a_n_n_o_t _b_e _m_a_t_c_h_e_d  indicates  that  the  given
     rule  cannot  be matched because it follows other rules that
     will always match the same text as it.  For example, in  the
     following  "foo" cannot be matched because it comes after an
     identifier "catch-all" rule:

         [a-z]+    got_identifier();
         foo       got_foo();

     Using RRRREEEEJJJJEEEECCCCTTTT in a scanner suppresses this warning.




Version 2.4        Last change: November 1993                  40






FLEXDOC(1)                User Commands                FLEXDOC(1)



     _w_a_r_n_i_n_g, ----ssss _o_p_t_i_o_n _g_i_v_e_n _b_u_t _d_e_f_a_u_l_t  _r_u_l_e  _c_a_n  _b_e  _m_a_t_c_h_e_d
     means  that  it  is  possible  (perhaps only in a particular
     start condition) that the default  rule  (match  any  single
     character)  is  the  only  one  that will match a particular
     input.  Since ----ssss was given, presumably this is not intended.

     _r_e_j_e_c_t__u_s_e_d__b_u_t__n_o_t__d_e_t_e_c_t_e_d          _u_n_d_e_f_i_n_e_d           or
     _y_y_m_o_r_e__u_s_e_d__b_u_t__n_o_t__d_e_t_e_c_t_e_d  _u_n_d_e_f_i_n_e_d  -  These errors can
     occur at compile time.  They indicate that the scanner  uses
     RRRREEEEJJJJEEEECCCCTTTT  or yyyyyyyymmmmoooorrrreeee(((()))) but that _f_l_e_x failed to notice the fact,
     meaning that _f_l_e_x scanned the first two sections looking for
     occurrences  of  these  actions  and failed to find any, but
     somehow you snuck some in (via a #include  file,  for  exam-
     ple).  Make an explicit reference to the action in your _f_l_e_x
     input  file.   (Note  that  previously  _f_l_e_x   supported   a
     %%%%uuuusssseeeedddd////%%%%uuuunnnnuuuusssseeeedddd  mechanism for dealing with this problem; this
     feature is still supported but now deprecated, and  will  go
     away  soon unless the author hears from people who can argue
     compellingly that they need it.)

     _f_l_e_x _s_c_a_n_n_e_r _j_a_m_m_e_d - a scanner compiled with ----ssss has encoun-
     tered  an  input  string  which wasn't matched by any of its
     rules.  This error can also occur due to internal problems.

     _t_o_k_e_n _t_o_o _l_a_r_g_e, _e_x_c_e_e_d_s _Y_Y_L_M_A_X - your scanner  uses  %%%%aaaarrrrrrrraaaayyyy
     and one of its rules matched a string longer than the YYYYYYYYLLLLMMMMAAAAXXXX
     constant (8K bytes by default).  You can increase the  value
     by  #define'ing  YYYYYYYYLLLLMMMMAAAAXXXX  in  the definitions section of your
     _f_l_e_x input.

     _s_c_a_n_n_e_r _r_e_q_u_i_r_e_s -_8 _f_l_a_g _t_o _u_s_e _t_h_e  _c_h_a_r_a_c_t_e_r  '_x'  -  Your
     scanner specification includes recognizing the 8-bit charac-
     ter '_x' and you did not  specify  the  - 8  flag,  and  your
     scanner  defaulted  to 7-bit because you used the ----CCCCffff or ----CCCCFFFF
     table compression options.  See the discussion of  the   ---- 7777
     flag for details.

     _f_l_e_x _s_c_a_n_n_e_r _p_u_s_h-_b_a_c_k _o_v_e_r_f_l_o_w - you used uuuunnnnppppuuuutttt(((())))  to  push
     back  so  much text that the scanner's buffer could not hold
     both the pushed-back text and the current token  in  yyyyyyyytttteeeexxxxtttt....
     Ideally  the scanner should dynamically resize the buffer in
     this case, but at present it does not.

     _i_n_p_u_t _b_u_f_f_e_r _o_v_e_r_f_l_o_w, _c_a_n'_t _e_n_l_a_r_g_e _b_u_f_f_e_r _b_e_c_a_u_s_e  _s_c_a_n_n_e_r
     _u_s_e_s  _R_E_J_E_C_T  -  the  scanner  was  working  on  matching an
     extremely large token and needed to expand the input buffer.
     This doesn't work with scanners that use RRRREEEEJJJJEEEECCCCTTTT....

     _f_a_t_a_l _f_l_e_x _s_c_a_n_n_e_r _i_n_t_e_r_n_a_l _e_r_r_o_r--_e_n_d _o_f  _b_u_f_f_e_r  _m_i_s_s_e_d  -
     This  can  occur  in  an  scanner which is reentered after a
     long-jump has jumped out (or over) the scanner's  activation
     frame.  Before reentering the scanner, use:



Version 2.4        Last change: November 1993                  41






FLEXDOC(1)                User Commands                FLEXDOC(1)



         yyrestart( yyin );

     or, as noted above, switch to using the C++ scanner class.

     _t_o_o _m_a_n_y _s_t_a_r_t _c_o_n_d_i_t_i_o_n_s _i_n <> you listed more start condi-
     tions  in a <> construct than exist (so you must have listed
     at least one of them twice).

FFFFIIIILLLLEEEESSSS
     See flex(1).

DDDDEEEEFFFFIIIICCCCIIIIEEEENNNNCCCCIIIIEEEESSSS //// BBBBUUUUGGGGSSSS
     Again, see flex(1).

SSSSEEEEEEEE AAAALLLLSSSSOOOO
     flex(1), lex(1), yacc(1), sed(1), awk(1).

     M. E. Lesk and E. Schmidt, _L_E_X - _L_e_x_i_c_a_l _A_n_a_l_y_z_e_r _G_e_n_e_r_a_t_o_r

AAAAUUUUTTTTHHHHOOOORRRR
     Vern Paxson, with the help of many ideas and  much  inspira-
     tion  from Van Jacobson.  Original version by Jef Poskanzer.
     The fast table representation is a partial implementation of
     a  design done by Van Jacobson.  The implementation was done
     by Kevin Gong and Vern Paxson.

     Thanks to the many _f_l_e_x beta-testers, feedbackers, and  con-
     tributors,  especially Francois Pinard, Casey Leedom, Nelson
     H.F. Beebe, benson@odi.com, Peter A.  Bigot,  Keith  Bostic,
     Frederic  Brehm, Nick Christopher, Jason Coughlin, Bill Cox,
     Dave Curtis, Scott David Daniels, Chris G.  Demetriou,  Mike
     Donahue,  Chuck Doucette, Tom Epperly, Leo Eskin, Chris Fay-
     lor, Jon Forrest,  Kaveh  R.  Ghazi,  Eric  Goldman,  Ulrich
     Grepel,  Jan  Hajic,  Jarkko  Hietaniemi,  Eric Hughes, John
     Interrante, Ceriel Jacobs, Jeffrey R. Jones, Henry  Juengst,
     Amir  Katz,  ken@ken.hilco.com,  Kevin  B. Kenny, Marq Kole,
     Ronald Lamprecht, Greg Lee, Craig Leres, John Levine,  Steve
     Liddle,  Mohamed  el Lozy, Brian Madsen, Chris Metcalf, Luke
     Mewburn, Jim Meyering, G.T. Nicol, Landon Noll, Marc Nozell,
     Richard Ohnemus, Sven Panne, Roland Pesch, Walter Pelissero,
     Gaumond Pierre, Esmond  Pitt,  Jef  Poskanzer,  Joe  Rahmeh,
     Frederic  Raimbault,  Rick  Richardson,  Kevin  Rodgers, Jim
     Roskind, Doug Schmidt, Philippe Schnoebelen, Andreas Schwab,
     Alex  Siegel,  Mike  Stump, Paul Stuart, Dave Tallman, Chris
     Thewalt, Paul Tuinenga, Gary  Weik,  Frank  Whaley,  Gerhard
     Wilhelms,  Kent Williams, Ken Yap, Nathan Zelle, David Zuhn,
     and  those  whose  names  have  slipped  my  marginal  mail-
     archiving skills but whose contributions are appreciated all
     the same.

     Thanks to Keith Bostic, Jon  Forrest,  Noah  Friedman,  John
     Gilmore, Craig Leres, John Levine, Bob Mulcahy, G.T.  Nicol,



Version 2.4        Last change: November 1993                  42






FLEXDOC(1)                User Commands                FLEXDOC(1)



     Francois Pinard, Rich Salz, and Richard  Stallman  for  help
     with various distribution headaches.

     Thanks to Esmond Pitt and Earle Horton for  8-bit  character
     support; to Benson Margulies and Fred Burke for C++ support;
     to Kent Williams and Tom Epperly for C++ class  support;  to
     Ove  Ewerlid  for  support  of NUL's; and to Eric Hughes for
     support of multiple buffers.

     This work was primarily done when I was with the  Real  Time
     Systems  Group at the Lawrence Berkeley Laboratory in Berke-
     ley, CA.  Many  thanks  to  all  there  for  the  support  I
     received.

     Send comments to:

          Vern Paxson
          Systems Engineering
          Bldg. 46A, Room 1123
          Lawrence Berkeley Laboratory
          University of California
          Berkeley, CA 94720

          vern@ee.lbl.gov































Version 2.4        Last change: November 1993                  43



