


ar(1)                 GNU Development Tools                 ar(1)



NAME
     ar-create, modify, and extract from archives.


SYNOPSIS
     ar [-]{dmpqrtx}[abcilosuvV] [membername] archive files...


DESCRIPTION
     The GNU ar program creates, modifies, and extracts from  ar-
     chives.  An archive is a single file holding a collection of
     other files in a structure that makes  it  possible  to  re-
     trieve  the original individual files (called members of the
     archive).

     The original files' contents, mode (permissions), timestamp,
     owner,  and  group  are preserved in the archive, and may be
     reconstituted on extraction.

     GNU ar can maintain archives whose members have names of any
     length;  however,  depending on how ar is configured on your
     system, a limit on member-name length may  be  imposed  (for
     compatibility  with  archive  formats  maintained with other
     tools).  If it exists, the  limit  is  often  15  characters
     (typical of formats related to a.out) or 16 characters (typ-
     ical of formats related to coff).

     ar is considered a binary utility because archives  of  this
     sort are most often used as libraries holding commonly need-
     ed subroutines.

     ar will create an index to the symbols defined  in  relocat-
     able  object  modules  in  the  archive when you specify the
     modifier `s'.  Once created, this index is  updated  in  the
     archive whenever ar makes a change to its contents (save for
     the `q' update operation).  An archive with  such  an  index
     speeds up linking to the library, and allows routines in the
     library to call each other without regard to their placement
     in the archive.

     You may use `nm -s' or `nm --print-armap' to list this index
     table.   If  an  archive lacks the table, another form of ar
     called ranlib can be used to add just the table.

     ar insists  on  at  least  two  arguments  to  execute:  one
     keyletter  specifying  the operation (optionally accompanied
     by other keyletters specifying modifiers), and  the  archive
     name to act on.

     Most operations can also  accept  further  files  arguments,
     specifying particular files to operate on.




cygnus support    Last change: 5 November 1991                  1






ar(1)                 GNU Development Tools                 ar(1)



OPTIONS
     GNU ar allows you to mix the operation code p  and  modifier
     flags  mod in any order, within the first command-line argu-
     ment.

     If you wish, you may begin the first  command-line  argument
     with a dash.

     The p keyletter specifies what operation to execute; it  may
     be  any  of  the following, but you must specify only one of
     them:


     d    Delete modules from the archive.  Specify the names  of
          modules  to  be  deleted  as  files; the archive is un-
          touched if you specify no files to delete.

          If you specify the `v'  modifier,  ar  will  list  each
          module as it is deleted.


     m    Use this operation to move members in an archive.

          The ordering of  members  in  an  archive  can  make  a
          difference  in  how  programs  are linked using the li-
          brary, if a symbol is defined in more than one member.

          If no modifiers are used with m, any members  you  name
          in  the files arguments are moved to the end of the ar-
          chive; you can use the `a', `b', or  `i'  modifiers  to
          move them to a specified place instead.


     p    Print the specified members  of  the  archive,  to  the
          standard  output  file.   If the `v' modifier is speci-
          fied, show the member name before copying its  contents
          to standard output.

          If you specify no files, all the files in  the  archive
          are printed.


     q    Quick append; add files to the end of archive,  without
          checking for replacement.

          The modifiers `a', `b', and  `i'  do  not  affect  this
          operation;  new members are always placed at the end of
          the archive.

          The modifier `v' makes ar list each file as it  is  ap-
          pended.




cygnus support    Last change: 5 November 1991                  2






ar(1)                 GNU Development Tools                 ar(1)



          Since  the  point  of  this  operation  is  speed,  the
          archive's symbol table index is not updated, even if it
          already existed; you can use `ar s' or ranlib explicit-
          ly to update the symbol table index.


     r    Insert files  into  archive  (with  replacement).  This
          operation  differs  from `q' in that any previously ex-
          isting members are deleted if their names  match  those
          being added.

          If one of the files named in files  doesn't  exist,  ar
          displays  an  error message, and leaves undisturbed any
          existing members of the archive matching that name.

          By default, new members are added at  the  end  of  the
          file; but you may use one of the modifiers `a', `b', or
          `i' to request  placement  relative  to  some  existing
          member.

          The modifier `v' used with  this  operation  elicits  a
          line  of  output for each file inserted, along with one
          of the letters `a' or `r' to indicate whether the  file
          was appended (no old member deleted) or replaced.


     t    Display a table listing the  contents  of  archive,  or
          those  of the files listed in files that are present in
          the archive.  Normally only the member name  is  shown;
          if you also want to see the modes (permissions), times-
          tamp, owner, group, and size, you can request  that  by
          also specifying the `v' modifier.

          If you do not specify any files, all files in  the  ar-
          chive are listed.

          If there is more than one file with the same name (say,
          `fie')  in  an archive (say `b.a'), `ar t b.a fie' will
          list only the first instance; to see them all, you must
          ask for a complete listing-in our example, `ar t b.a'.


     x    Extract members (named files) from  the  archive.   You
          can  use  the  `v' modifier with this operation, to re-
          quest that ar list each name as it extracts it.

          If you do not specify any files, all files in  the  ar-
          chive are extracted.


     A number of modifiers (mod) may  immediately  follow  the  p
     keyletter, to specify variations on an operation's behavior:



cygnus support    Last change: 5 November 1991                  3






ar(1)                 GNU Development Tools                 ar(1)



     a    Add new files after an existing member of the  archive.
          If  you use the modifier a, the name of an existing ar-
          chive member must be present as  the  membername  argu-
          ment, before the archive specification.


     b    Add new files before an existing member of the archive.
          If  you use the modifier b, the name of an existing ar-
          chive member must be present as  the  membername  argu-
          ment, before the archive specification.  (same as `i').


     c    Create the archive.  The specified  archive  is  always
          created if it didn't exist, when you request an update.
          But a warning is issued unless you specify  in  advance
          that you expect to create it, by using this modifier.


     i    Insert new files before an existing member of  the  ar-
          chive.   If  you use the modifier i, the name of an ex-
          isting archive member must be present as the membername
          argument,  before  the archive specification.  (same as
          `b').


     l    This modifier is accepted but not used.


     o    Preserve the original dates of members when  extracting
          them.   If  you do not specify this modifier, files ex-
          tracted from the archive will be stamped with the  time
          of extraction.


     s    Write an object-file index into the archive, or  update
          an existing one, even if no other change is made to the
          archive.  You may use this modifier  flag  either  with
          any  operation, or alone.  Running `ar s' on an archive
          is equivalent to running `ranlib' on it.


     u    Normally, ar r... inserts all files listed into the ar-
          chive.   If  you would like to insert only those of the
          files you list that are newer than existing members  of
          the same names, use this modifier.  The `u' modifier is
          allowed only for the operation `r' (replace).  In  par-
          ticular,  the  combination  `qu'  is not allowed, since
          checking the timestamps would lose any speed  advantage
          from the operation `q'.


     v    This modifier requests the verbose version of an opera-



cygnus support    Last change: 5 November 1991                  4






ar(1)                 GNU Development Tools                 ar(1)



          tion.
           Many operations display additional  information,  such
          as  filenames  processed,  when the modifier `v' is ap-
          pended.


     V    This modifier shows the version number of ar.


SEE ALSO
     `binutils' entry in info; The GNU Binary  Utilities,  Roland
     H. Pesch (October 1991).  nm(1), ranlib(1).


COPYING
     Copyright (c) 1991 Free Software Foundation, Inc.

     Permission is granted to make and distribute verbatim copies
     of  this  manual provided the copyright notice and this per-
     mission notice are preserved on all copies.

     Permission is granted to copy and distribute  modified  ver-
     sions of this manual under the conditions for verbatim copy-
     ing, provided that the entire resulting derived work is dis-
     tributed under the terms of a permission notice identical to
     this one.

     Permission is granted to copy and distribute translations of
     this  manual  into  another language, under the above condi-
     tions for modified versions, except that this permission no-
     tice  may  be  included in translations approved by the Free
     Software Foundation instead of in the original English.























cygnus support    Last change: 5 November 1991                  5



