


CI(1)                    USER COMMANDS                      CI(1)



NAME
     ci - check in RCS revisions

SYNOPSIS
     ci [options] file ...

DESCRIPTION
     ci stores new revisions into RCS files.  Each file name end-
     ing  in  ,v  is  taken  to  be  an RCS file.  All others are
     assumed to be working files containing  new  revisions.   ci
     deposits   the  contents  of  each  working  file  into  the
     corresponding RCS file.  If only a working file is given, ci
     tries to find the corresponding RCS file in an RCS subdirec-
     tory and then in the working  file's  directory.   For  more
     details, see FILE NAMING below.

     For ci to work, the caller's login must  be  on  the  access
     list,  except  if  the access list is empty or the caller is
     the superuser or the owner of the file.   To  append  a  new
     revision  to  an  existing  branch, the tip revision on that
     branch must be locked by the caller.  Otherwise, only a  new
     branch can be created.  This restriction is not enforced for
     the owner of the file if non-strict  locking  is  used  (see
     rcs(1)).  A lock held by someone else may be broken with the
     rcs command.

     Normally, ci checks whether the revision to be deposited  is
     different  from  the preceding one.  If it is not different,
     ci aborts the deposit, asking  beforehand  if  possible.   A
     deposit can be forced with the -f option.

     For each revision deposited, ci prompts for a  log  message.
     The log message should summarize the change and must be ter-
     minated by end-of-file or by a line containing . by  itself.
     If several files are checked in ci asks whether to reuse the
     previous log message.  If the standard input is not a termi-
     nal,  ci suppresses the prompt and uses the same log message
     for all files.  See also -m.

     The number of the deposited revision can be given by any  of
     the options -f, -I, -k, -l, -q, -r, or -u.

     If the RCS file does not exist, ci creates it  and  deposits
     the  contents  of  the  working file as the initial revision
     (default number: 1.1).  The access list  is  initialized  to
     empty.   Instead of the log message, ci requests descriptive
     text (see -t below).

OPTIONS
     -r[rev]
          assigns the revision number rev to the checked-in revi-
          sion,  releases the corresponding lock, and deletes the



GNU                  Last change: 1990/12/04                    1






CI(1)                    USER COMMANDS                      CI(1)



          working file.  This is the default.  rev  may  be  sym-
          bolic, numeric, or mixed.

          If rev is a revision number, it must be higher than the
          latest  one on the branch to which rev belongs, or must
          start a new branch.

          If rev is a branch rather than a revision  number,  the
          new  revision  is  appended  to that branch.  The level
          number is obtained by  incrementing  the  tip  revision
          number of that branch.  If rev indicates a non-existing
          branch, that branch is created with the  initial  revi-
          sion numbered rev.1.

          If rev is omitted, ci tries to derive the new  revision
          number  from the caller's last lock.  If the caller has
          locked the tip revision of a branch, the  new  revision
          is appended to that branch.  The new revision number is
          obtained by incrementing the tip revision  number.   If
          the  caller  locked a non-tip revision, a new branch is
          started at that revision by  incrementing  the  highest
          branch  number  at  that revision.  The default initial
          branch and level numbers are 1.

          If rev is omitted and the caller has no lock, but  owns
          the  file  and  locking  is not set to strict, then the
          revision is appended to the  default  branch  (normally
          the trunk; see the -b option of rcs(1)).

          Exception: On the trunk, revisions can be  appended  to
          the end, but not inserted.

     -f[rev]
          forces a deposit; the new revision is deposited even it
          is not different from the preceding one.

     -k[rev]
          searches the working file for keyword values to  deter-
          mine  its  revision  number,  creation date, state, and
          author (see co(1)), and assigns  these  values  to  the
          deposited revision, rather than computing them locally.
          It also generates a default login  message  noting  the
          login  of the caller and the actual checkin date.  This
          option is useful for software distribution.  A revision
          that is sent to several sites should be checked in with
          the -k option at these sites to preserve  the  original
          number, date, author, and state.  The extracted keyword
          values and the default log message  may  be  overridden
          with  the  options  -d, -m, -s, -w, and any option that
          carries a revision number.

     -l[rev]



GNU                  Last change: 1990/12/04                    2






CI(1)                    USER COMMANDS                      CI(1)



          works like -r, except it performs an  additional  co -l
          for  the deposited revision.  Thus, the deposited revi-
          sion is immediately checked out again and locked.  This
          is  useful  for saving a revision although one wants to
          continue editing it after the checkin.

     -u[rev]
          works like -l, except that the  deposited  revision  is
          not  locked.   This  lets  one  read  the  working file
          immediately after checkin.

     -q[rev]
          quiet mode; diagnostic output is not printed.  A  revi-
          sion  that  is  not different from the preceding one is
          not deposited, unless -f is given.

     -I[rev]
          interactive mode; the user is prompted  and  questioned
          even if the standard input is not a terminal.

     -d[date]
          uses date for the checkin date and time.  The  date  is
          specified  in  free format as explained in co(1).  This
          is useful for lying about the checkin date, and for  -k
          if no date is available.  If date is empty, the working
          file's time of last modification is used.

     -mmsg
          uses the string msg as the log message  for  all  revi-
          sions checked in.

     -nname
          assigns the symbolic name name to  the  number  of  the
          checked-in  revision.   ci  prints  an error message if
          name is already assigned to another number.

     -Nname
          same as -n, except that it overrides a previous assign-
          ment of name.

     -sstate
          sets the state of the checked-in revision to the  iden-
          tifier state.  The default state is Exp.

     -tfile
          writes descriptive text from the contents of the  named
          file  into  the  RCS  file, deleting the existing text.
          The file name may not begin with -.

     -t-string
          Write descriptive text from the  string  into  the  RCS
          file, deleting the existing text.



GNU                  Last change: 1990/12/04                    3






CI(1)                    USER COMMANDS                      CI(1)



          The -t option, in both its forms, has effect only  dur-
          ing  an  initial checkin; it is silently ignored other-
          wise.

          During the initial checkin, if  -t  is  not  given,  ci
          obtains  the  text  from  standard input, terminated by
          end-of-file or by a line containing . by  itself.   The
          user  is prompted for the text if interaction is possi-
          ble; see -I.

          For backward compatibility with older versions of  RCS,
          a bare -t option is ignored.

     -wlogin
          uses login for the author field of the deposited  revi-
          sion.  Useful for lying about the author, and for -k if
          no author is available.

     -Vn  Emulate RCS version n.  See co(1) for details.

FILE NAMING
     Pairs of RCS files and working files  may  be  specified  in
     three ways (see also the example section of co(1)).

     1) Both the RCS file and the working file  are  given.   The
     RCS  file name is of the form path1/workfile,v and the work-
     ing file name is of the form path2/workfile where path1/ and
     path2/  are (possibly different or empty) paths and workfile
     is a file name.

     2) Only the RCS file is given.  Then  the  working  file  is
     created  in  the  current  directory and its name is derived
     from the name of the RCS file by  removing  path1/  and  the
     suffix ,v.

     3) Only the working file is given.  Then ci looks for an RCS
     file  of  the  form path2/RCS/workfile,v or path2/workfile,v
     (in this order).

     If the RCS file is specified without a path in  1)  and  2),
     then  ci looks for the RCS file first in the directory ./RCS
     and then in the current directory.

FILE MODES
     An RCS file created by ci inherits the read and execute per-
     missions  from  the  working  file.   If the RCS file exists
     already, ci preserves its read and execute permissions.   ci
     always turns off all write permissions of RCS files.

FILES
     Several temporary files may be created.  A semaphore file is
     created  in  the  directory  containing  the  RCS file.  The



GNU                  Last change: 1990/12/04                    4






CI(1)                    USER COMMANDS                      CI(1)



     effective user+group must be able to read the RCS  file  and
     to  search  and write the directory containing the RCS file.
     Normally, the real user+group must be able to read the work-
     ing  file  and  to search and write the directory containing
     the working file; however, some older hosts that do not con-
     form  to Posix 1003.1-1990 cannot easily switch between real
     and  effective  ids,  so  on  these  hosts   the   effective
     user+group   is   used  for  all  accesses.   The  effective
     user+group is the same as the real  user+group  unless  your
     copy   of  RCS  has  setuid  or  setgid  privileges.   These
     privileges yield extra security if RCS files  are  protected
     so  that  only the effective user+group can write RCS direc-
     tories.  Further protection  can  be  achieved  by  granting
     access only to the effective user+group.

     ci never changes an RCS or working file; instead, it unlinks
     the  file  and creates a new one.  This strategy breaks hard
     links to such files, but does not affect symbolic links.

DIAGNOSTICS
     For each revision, ci prints the RCS file, the working file,
     and the number of both the deposited and the preceding revi-
     sion.  The exit status is zero if and only if all operations
     were successful.

IDENTIFICATION
     Author: Walter F. Tichy.
     Revision Number: 5.4; Release Date: 1990/12/04.
     Copyright (c) 1982, 1988, 1989 by Walter F. Tichy.
     Copyright (c) 1990 by Paul Eggert.

SEE ALSO
     co(1),   ident(1),    rcs(1),    rcsdiff(1),    rcsintro(1),
     rcsmerge(1), rlog(1), rcsfile(5)
     Walter  F.  Tichy,  RCS--A  System  for   Version   Control,
     Software--Practice & Experience 15, 7 (July 1985), 637-654.



















GNU                  Last change: 1990/12/04                    5



