


CPIO(1L)          MISC. REFERENCE MANUAL PAGES           CPIO(1L)



NAME
     cpio - copy files to and from archives

SYNOPSIS
     cpio {-o|--create} [-0acvABLV] [-C bytes]  [-H  format]  [-M
     message]        [-O        [[user@]host:]archive]        [-F
     [[user@]host:]archive]        [--file=[[user@]host:]archive]
     [--format=format]   [--message=message]  [--null]  [--reset-
     access-time]  [--verbose]   [--dot]   [--append]   [--block-
     size=blocks]   [--dereference]   [--io-size=bytes]  [--help]
     [--version] < name-list [> archive]

     cpio {-i|--extract} [-bcdfmnrtsuvBSV] [-C bytes]  [-E  file]
     [-H   format]   [-M   message]  [-R  [user][:.][group]]  [-I
     [[user@]host:]archive]      [-F       [[user@]host:]archive]
     [--file=[[user@]host:]archive]  [--make-directories] [--non-
     matching] [--preserve-modification-time] [--numeric-uid-gid]
     [--rename]    [--list]   [--swap-bytes]   [--swap]   [--dot]
     [--unconditional]     [--verbose]      [--block-size=blocks]
     [--swap-halfwords]  [--io-size=bytes]  [--pattern-file=file]
     [--format=format]     [--owner=[user][:.][group]]     [--no-
     preserve-owner]   [--message=message]  [--help]  [--version]
     [pattern...] [< archive]

     cpio {-p|--pass-through} [-0adlmuvLV] [-R [user][:.][group]]
     [--null] [--reset-access-time] [--make-directories] [--link]
     [--preserve-modification-time] [--unconditional] [--verbose]
     [--dot]  [--dereference]  [--owner=[user][:.][group]] [--no-
     preserve-owner] [--help] [--version] destination-directory <
     name-list

DESCRIPTION
     This manual page documents the GNU version  of  cpio.   cpio
     copies  files into or out of a cpio or tar archive, which is
     a file that contains  other  files  plus  information  about
     them,  such as their pathname, owner, timestamps, and access
     permissions.  The archive can be another file on the disk, a
     magnetic tape, or a pipe.  cpio has three operating modes.

     In copy-out mode, cpio copies files  into  an  archive.   It
     reads  a  list  of  filenames, one per line, on the standard
     input, and writes the archive onto the standard  output.   A
     typical  way  to  generate the list of filenames is with the
     find command; you should give  find  the  -depth  option  to
     minimize  problems  with permissions on directories that are
     unwritable or not searchable.

     In copy-in mode, cpio copies files  out  of  an  archive  or
     lists  the  archive contents.  It reads the archive from the
     standard input.  Any non-option command line  arguments  are
     shell  globbing  patterns;  only  files in the archive whose
     names match one or more of those patterns  are  copied  from



Sun Release 4.1           Last change:                          1






CPIO(1L)          MISC. REFERENCE MANUAL PAGES           CPIO(1L)



     the  archive.   Unlike  in  the  shell,  an initial `.' in a
     filename does match a wildcard at the start  of  a  pattern,
     and a `/' in a filename can match wildcards.  If no patterns
     are given, all files are extracted.

     In copy-pass mode, cpio copies files from one directory tree
     to another, combining the copy-out and copy-in steps without
     actually using an archive.  It reads the list  of  files  to
     copy  from  the  standard input; the directory into which it
     will copy them is given as a non-option argument.

     cpio supports the following  archive  formats:  binary,  old
     ASCII, new ASCII, crc, HPUX binary, HPUX old ASCII, old tar,
     and POSIX.1 tar. The binary format is  obsolete  because  it
     encodes  information  about  the  files in a way that is not
     portable between different machine architectures.   The  old
     ASCII format is portable between different machine architec-
     tures, but should not be used on file systems with more than
     65536  i-nodes.   The  new  ASCII format is portable between
     different machine architectures and can be used on any  size
     file  system,  but is not supported by all versions of cpio;
     currently, it is only supported by GNU and Unix System V R4.
     The  crc  format is like the new ASCII format, but also con-
     tains a checksum for each file which  cpio  calculates  when
     creating  an archive and verifies when the file is extracted
     from the archive.  The HPUX formats are provided for  compa-
     tibility  with  HPUX's  cpio  which stores device files dif-
     ferently.

     The tar format is provided for compatability  with  the  tar
     program.   It  can  not  be used to archive files with names
     longer than 100 characters, and can not be used  to  archive
     "special"  (block  or character devices) files.  The POSIX.1
     tar format can not be  used  to  archive  files  with  names
     longer  than  255 characters (less unless they have a "/" in
     just the right place).

     By default, cpio creates binary format archives, for  compa-
     tibility  with  older  cpio  programs.  When extracting from
     archives,  cpio  automatically  recognizes  which  kind   of
     archive  it  is  reading  and  can  read archives created on
     machines with a different byte-order.

     Some of the options to cpio apply only to certain  operating
     modes;  see the SYNOPSIS section for a list of which options
     are allowed in which modes.

  OPTIONS
     -0, --null
          In  copy-out  and  copy-pass  modes,  read  a  list  of
          filenames  terminated  by a null character instead of a
          newline, so that files whose names contain newlines can



Sun Release 4.1           Last change:                          2






CPIO(1L)          MISC. REFERENCE MANUAL PAGES           CPIO(1L)



          be  archived.  GNU find is one way to produce a list of
          null-terminated filenames.

     -a, --reset-access-time
          Reset the access times of files after reading them,  so
          that it does not look like they have just been read.

     -A, --append
          Append to an existing archive.  Only works in  copy-out
          mode.   The  archive must be a disk file specified with
          the -O or -F (--file) option.

     -b, --swap
          In copy-in mode, swap both halfwords of words and bytes
          of halfwords in the data.  Equivalent to -sS.  Use this
          option to convert 32-bit  integers  between  big-endian
          and little-endian machines.

     -B   Set the I/O block size to 5120  bytes.   Initially  the
          block size is 512 bytes.

     --block-size=BLOCK-SIZE
          Set the I/O block size to BLOCK-SIZE * 512 bytes.

     -c   Use the old portable (ASCII) archive format.

     -C IO-SIZE, --io-size=IO-SIZE
          Set the I/O block size to IO-SIZE bytes.

     -d, --make-directories
          Create leading directories where needed.

     -E FILE, --pattern-file=FILE
          In copy-in mode, read  additional  patterns  specifying
          filenames  to  extract or list from FILE.  The lines of
          FILE are treated as if they had been  non-option  argu-
          ments to cpio.

     -f, --nonmatching
          Only copy files that do not match any of the given pat-
          terns.

     -F, --file=archive
          Archive filename to use instead of  standard  input  or
          output.   To use a tape drive on another machine as the
          archive, use a filename that starts  with  `HOSTNAME:'.
          The  hostname  can be preceded by a username and an `@'
          to access the remote tape drive as that  user,  if  you
          have  permission  to  do so (typically an entry in that
          user's `~/.rhosts' file).

     --force-local



Sun Release 4.1           Last change:                          3






CPIO(1L)          MISC. REFERENCE MANUAL PAGES           CPIO(1L)



          With -F, -I, or -O, take the archive file name to be  a
          local  file  even  if  it contains a colon, which would
          ordinarily indicate a remote host name.

     -H FORMAT, --format=FORMAT
          Use archive  format  FORMAT.   The  valid  formats  are
          listed  below;  the  same  names are also recognized in
          all-caps.  The default in copy-in mode is to  automati-
          cally  detect  the archive format, and in copy-out mode
          is "bin".

          bin  The obsolete binary format.

          odc  The old (POSIX.1) portable format.

          newc The new (SVR4)  portable  format,  which  supports
               file systems having more than 65536 i-nodes.

          crc  The new (SVR4) portable  format  with  a  checksum
               added.

          tar  The old tar format.

          ustar
               The POSIX.1 tar format.  Also recognizes  GNU  tar
               archives, which are similar but not identical.

          hpbin
               The obsolete binary format  used  by  HPUX's  cpio
               (which stores device files differently).

          hpodc
               The portable format used  by  HPUX's  cpio  (which
               stores device files differently).

     -i, --extract
          Run in copy-in mode.

     -I archive
          Archive filename to use instead of standard input.   To
          use a tape drive on another machine as the archive, use
          a filename that starts with `HOSTNAME:'.  The  hostname
          can  be preceded by a username and an `@' to access the
          remote tape drive as that user, if you have  permission
          to do so (typically an entry in that user's `~/.rhosts'
          file).

     -k   Ignored; for compatibility with other versions of cpio.

     -l, --link
          Link files instead of copying them, when possible.




Sun Release 4.1           Last change:                          4






CPIO(1L)          MISC. REFERENCE MANUAL PAGES           CPIO(1L)



     -L, --dereference
          Dereference symbolic links (copy the  files  that  they
          point to instead of copying the links).

     -m, --preserve-modification-time
          Retain previous file modification times  when  creating
          files.

     -M MESSAGE, --message=MESSAGE
          Print MESSAGE when the end of a volume  of  the  backup
          media  (such as a tape or a floppy disk) is reached, to
          prompt the user to insert a  new  volume.   If  MESSAGE
          contains the string "%d", it is replaced by the current
          volume number (starting at 1).

     -n, --numeric-uid-gid
          In the verbose table of contents listing, show  numeric
          UID and GID instead of translating them into names.

      --no-preserve-owner
          In copy-in mode and copy-pass mode, do not  change  the
          ownership  of  the  files; leave them owned by the user
          extracting them.  This  is  the  default  for  non-root
          users,  so  that  users on System V don't inadvertantly
          give away files.

     -o, --create
          Run in copy-out mode.

     -O archive
          Archive filename to use instead of standard output.  To
          use a tape drive on another machine as the archive, use
          a filename that starts with `HOSTNAME:'.  The  hostname
          can  be preceded by a username and an `@' to access the
          remote tape drive as that user, if you have  permission
          to do so (typically an entry in that user's `~/.rhosts'
          file).

     -p, --pass-through
          Run in copy-pass mode.

     -r, --rename
          Interactively rename files.

     -R [user][:.][group], --owner [user][:.][group]
          In copy-out and copy-pass modes, set the  ownership  of
          all  files  created to the specified user and/or group.
          Either the user or the group, or both, must be present.
          If the group is omitted but the ":" or "." separator is
          given, use the given  user's  login  group.   Only  the
          super-user can change files' ownership.




Sun Release 4.1           Last change:                          5






CPIO(1L)          MISC. REFERENCE MANUAL PAGES           CPIO(1L)



     -s, --swap-bytes
          In copy-in mode, swap the bytes of each halfword  (pair
          of bytes) in the files.

     -S, --swap-halfwords
          In copy-in mode, swap the halfwords  of  each  word  (4
          bytes) in the files.

     -t, --list
          Print a table of contents of the input.

     -u, --unconditional
          Replace all files, without asking  whether  to  replace
          existing newer files with older files.

     -v, --verbose
          List the files processed, or with -t, give an  `ls  -l'
          style table of contents listing.  In a verbose table of
          contents of a ustar archive, user and  group  names  in
          the  archive  that do not exist on the local system are
          replaced by the names that correspond  locally  to  the
          numeric UID and GID stored in the archive.

     -V --dot
          Print a "." for each file processed.

     --version
          Print the cpio program version number and exit.



























Sun Release 4.1           Last change:                          6



