


GPROF(1)                 USER COMMANDS                   GPROF(1)



NAME
     gprof - display call graph profile data

SYNOPSIS
     gprof [ -abcsz ] [ -e|-E name ] [ -f|-F name ] [ -k fromname
     toname ] [ objfile [ gmon.out ] ]

DESCRIPTION
     gprof produces an execution profile of C,  Pascal,  or  For-
     tran77  programs.   The  effect of called routines is incor-
     porated in the profile of each caller.  The profile data  is
     taken  from the call graph profile file (`gmon.out' default)
     which is created by programs that are compiled with the  -pg
     option  of  cc(1),  pc(1),  and f77(1).  The -pg option also
     links in versions of the library routines that are  compiled
     for  profiling.   Gprof  reads  the  given  object file (the
     default is `a.out') and establishes the relation between its
     symbol table and the call graph profile from `gmon.out'.  If
     more than one profile file is specified,  the  gprof  output
     shows  the  sum of the profile information in the given pro-
     file files.

     Gprof calculates the amount of time spent in  each  routine.
     Next, these times are propagated along the edges of the call
     graph.  Cycles are discovered, and calls into  a  cycle  are
     made  to  share  the  time  of the cycle.  The first listing
     shows the  functions  sorted  according  to  the  time  they
     represent  including  the  time  of their call graph descen-
     dents.  Below each function entry is shown its (direct) call
     graph  children,  and how their times are propagated to this
     function.  A similar display above the  function  shows  how
     this function's time and the time of its descendents is pro-
     pagated to its (direct) call graph parents.

     Cycles are also shown, with an entry  for  the  cycle  as  a
     whole  and  a  listing of the members of the cycle and their
     contributions to the time and call counts of the cycle.

     Second, a flat profile is given, similar to that provided by
     prof(1).   This listing gives the total execution times, the
     call counts, the time in milleseconds the call spent in  the
     routine  itself, and the time in milleseconds the call spent
     in the routine itself including its descendents.

     Finally, an index of the function names is provided.

OPTIONS
     The following options are available:

     -a   suppresses the printing of  statically  declared  func-
          tions.   If this option is given, all relevant informa-
          tion about the static  function  (e.g.,  time  samples,



Sun Release 4.1   Last change: January 29, 1993                 1






GPROF(1)                 USER COMMANDS                   GPROF(1)



          calls  to  other functions, calls from other functions)
          belongs to the function loaded just before  the  static
          function in the `objfile' file.

     -b   suppresses the printing of a description of each  field
          in the profile.

     -c   the static call graph of the program is discovered by a
          heuristic  that  examines  the text space of the object
          file.  Static-only parents or children are  shown  with
          call counts of 0.

     -e name
          suppresses the printing of the graph profile entry  for
          routine  name and all its descendants (unless they have
          other ancestors that aren't suppressed).  More than one
          -e  option  may  be  given.  Only one name may be given
          with each -e option.

     -E name
          suppresses the printing of the graph profile entry  for
          routine  name  (and its descendants) as -e , above, and
          also excludes the time spent in name (and  its  descen-
          dants) from the total and percentage time computations.
          (For example, -E mcount -E mcleanup is the default.)

     -f name
          prints the graph profile entry of  only  the  specified
          routine  name  and  its  descendants.  More than one -f
          option may be given.  Only one name may be  given  with
          each -f option.

     -F name
          prints the graph profile entry of only the routine name
          and  its descendants (as -f , above) and also uses only
          the times of the printed routines  in  total  time  and
          percentage  computations.   More than one -F option may
          be given.  Only one name may  be  given  with  each  -F
          option.  The -F option overrides the -E option.

     -k fromname toname
          will delete any arcs from routine fromname  to  routine
          toname.   This  can  be used to break undesired cycles.
          More than one -k option may be given.  Only one pair of
          routine names may be given with each -k option.

     -s   a profile file `gmon.sum' is produced  that  represents
          the sum of the profile information in all the specified
          profile files.  This summary profile file may be  given
          to  later executions of gprof (probably also with a -s)
          to accumulate profile data across several  runs  of  an
          `objfile' file.



Sun Release 4.1   Last change: January 29, 1993                 2






GPROF(1)                 USER COMMANDS                   GPROF(1)



     -z   displays routines that have zero  usage  (as  shown  by
          call counts and accumulated time).  This is useful with
          the -c option for discovering which routines were never
          called.

FILES
     a.out    the namelist and text space.
     gmon.out dynamic call graph and profile.
     gmon.sum summarized dynamic call graph and profile.

SEE ALSO
     monitor(3), profil(2), cc(1), prof(1)

     ``An Execution Profiler for Modular Programs'', by  S.  Gra-
     ham,  P.  Kessler,  M.  McKusick;  Software  -  Practice and
     Experience, Vol. 13, pp. 671-685, 1983.

     ``gprof: A Call Graph Execution Profiler'', by S. Graham, P.
     Kessler,  M. McKusick; Proceedings of the SIGPLAN '82 Sympo-
     sium on Compiler Construction, SIGPLAN Notices, Vol. 17,  No
     6, pp. 120-126, June 1982.

HISTORY
     Gprof appeared in 4.2 BSD.

BUGS
     The granularity of the sampling is shown, but  remains  sta-
     tistical  at  best.  We assume that the time for each execu-
     tion of a function can be expressed by the  total  time  for
     the  function divided by the number of times the function is
     called.  Thus the time propagated along the call graph  arcs
     to  the  function's  parents is directly proportional to the
     number of times that arc is traversed.

     Parents that are not themselves profiled will have the  time
     of their profiled children propagated to them, but they will
     appear to be spontaneously invoked in the call  graph  list-
     ing, and will not have their time propagated further.  Simi-
     larly, signal catchers, even though profiled, will appear to
     be  spontaneous  (although  for  more obscure reasons).  Any
     profiled children of signal catchers should have their times
     propagated  properly,  unless the signal catcher was invoked
     during the execution of the profiling routine, in which case
     all is lost.

     The profiled program must call exit(2)  or  return  normally
     for  the profiling information to be saved in the `gmon.out'
     file.







Sun Release 4.1   Last change: January 29, 1993                 3



