


ld(1)                 GNU Development Tools                 ld(1)



NAME
     ld - the GNU linker


SYNOPSIS
     ld   [-o output] objfiles...
          [-Aarchitecture] [-b input-format] [-Bstatic]
          [-c commandfile] [-d|-dc|-dp]
          [-defsym symbol = expression] [-e entry] [-F]
          [-F format] [-format input-format] [-g] [-i] [-lar]
          [-Lsearchdir] [-M|-m] [-n|-N] [-noinhibit-exec]
          [-R filename] [-relax] [-r|-Ur] [-S] [-s]
          [-T commandfile] [-Ttext textorg] [-Tdata dataorg]
          [-Tbss bssorg] [-t] [-u sym] [-v] [-X] [-x] [{script}]

DESCRIPTION
     ld combines a number of object and archive files,  relocates
     their  data  and  ties  up symbol references. Often the last
     step in building a new compiled program to run is a call  to
     ld.

     ld accepts Linker Command Language files to provide explicit
     and  total  control over the linking process.  This man page
     does not describe the command language; see the  `ld'  entry
     in  `info',  or the manual ld: the GNU linker , for full de-
     tails on the command language and on other  aspects  of  the
     GNU linker.

     This version of ld uses the general purpose BFD libraries to
     operate  on  object  files. This allows ld to read, combine,
     and write object files in many different  formats-for  exam-
     ple, COFF or a.out.  Different formats may be linked togeth-
     er to produce any available kind of object  file.   You  can
     use `objdump -i' to get a list of formats supported on vari-
     ous architectures; see objdump(1).

     Aside from its flexibility, the GNU linker is  more  helpful
     than  other  linkers  in  providing  diagnostic information.
     Many linkers abandon execution immediately upon encountering
     an  error; whenever possible, ld continues executing, allow-
     ing you to identify other errors (or, in some cases, to  get
     an output file in spite of the error).

     The GNU linker ld is meant to cover a broad range of  situa-
     tions,  and to be as compatible as possible with other link-
     ers.  As a result, you have  many  choices  to  control  its
     behavior  through  the command line, and through environment
     variables.


OPTIONS
     The plethora of command-line options may seem  intimidating,



cygnus support     Last change: 17 August 1992                  1






ld(1)                 GNU Development Tools                 ld(1)



     but  in actual practice few of them are used in any particu-
     lar context.  For instance, a frequent use of ld is to  link
     standard  Unix  object  files  on a standard, supported Unix
     system.  On such a system, to link a file hello.o:

     $ ld -o output /lib/crt0.o hello.o -lc

     This tells ld to produce a file called output as the  result
     of linking the file /lib/crt0.o with hello.o and the library
     libc.a which will come from the standard search directories.

     The command-line options to ld may be specified in any  ord-
     er, and may be repeated at will.  For the most part, repeat-
     ing an option with a different argument will either have  no
     further effect, or override prior occurrences (those further
     to the left on the command line) of an option.

     The exceptions-which may  meaningfully  be  used  more  than
     once-are  -A,  -b (or its synonym -format), -defsym, -L, -l,
     -R, and -u.

     The list of object files to be  linked  together,  shown  as
     objfiles,  may follow, precede, or be mixed in with command-
     line options; save that an  objfiles  argument  may  not  be
     placed between an option flag and its argument.

     Usually the linker is invoked with at least one object file,
     but  other forms of binary input files can also be specified
     with -l, -R, and the script command language.  If no  binary
     input  files  at all are specified, the linker does not pro-
     duce any output, and issues the message `No input files'.

     Option  arguments  must  either  follow  the  option  letter
     without  intervening whitespace, or be given as separate ar-
     guments immediately following the option that requires them.


     objfiles...
          The object files objfiles to be linked.


     -Aarchitecture
           In the current release of ld, this  option  is  useful
          only  for  the  Intel  960 family of architectures.  In
          that ld configuration, the architecture argument is one
          of  the two-letter names identifying members of the 960
          family; the option specifies the desired output target,
          and warns of any incompatible instructions in the input
          files.  It also modifies the linker's  search  strategy
          for  archive libraries, to support the use of libraries
          specific to each particular architecture, by  including
          in the search loop names suffixed with the string iden-



cygnus support     Last change: 17 August 1992                  2






ld(1)                 GNU Development Tools                 ld(1)



          tifying the architecture.

          For example, if your ld command line included `-ACA' as
          well as `-ltry', the linker would look (in its built-in
          search paths, and in any paths you specify with -L) for
          a library with the names

          try
          libtry.a
          tryca
          libtryca.a


          The first two possibilities would be considered in  any
          event; the last two are due to the use of `-ACA'.

          Future releases of ld may support similar functionality
          for other architecture families.

          You can meaningfully use -A more than once on a command
          line,  if  an architecture family allows combination of
          target architectures; each use will add another pair of
          name  variants  to  search  for when -l specifies a li-
          brary.


     -b input-format
           Specify the binary format for input object files  that
          follow this option on the command line.  You don't usu-
          ally need to specify this, as ld is configured  to  ex-
          pect as a default input format the most usual format on
          each machine.  input-format is a text string, the  name
          of  a particular format supported by the BFD libraries.
          -format input-format has the same effect.

          You may want to use this  option  if  you  are  linking
          files  with an unusual binary format.  You can also use
          -b to switch formats explicitly  (when  linking  object
          files  of  different  formats),  by including -b input-
          format before each group of object files in a  particu-
          lar format.

          The default format is taken from the environment  vari-
          able  GNUTARGET.   You can also define the input format
          from a script, using the command TARGET.


     -Bstatic
          This flag is accepted  for  command-line  compatibility
          with the SunOS linker, but has no effect on ld.





cygnus support     Last change: 17 August 1992                  3






ld(1)                 GNU Development Tools                 ld(1)



     -c commandfile
           Directs ld to read link commands from  the  file  com-
          mandfile.  These commands will completely override ld's
          default link format (rather than adding  to  it);  com-
          mandfile  must specify everything necessary to describe
          the target format.


          You may also include a script of link commands directly
          in  the  command  line by bracketing it between `{' and
          `}' characters.


     -d

     -dc

     -dp  These three options are equivalent; multiple forms  are
          supported  for  compatibility  with other linkers.  Use
          any of them to make ld assign space to  common  symbols
          even  if  a  relocatable output file is specified (-r).
          The script command FORCE_COMMON_ALLOCATION has the same
          effect.


     -defsym symbol
           = expression Create a  global  symbol  in  the  output
          file,  containing the absolute address given by expres-
          sion.  You may use this option as many times as  neces-
          sary to define multiple symbols in the command line.  A
          limited form of arithmetic is supported for the expres-
          sion  in  this context: you may give a hexadecimal con-
          stant or the name of an existing symbol, or use + and -
          to  add  or  subtract hexadecimal constants or symbols.
          If you need more elaborate expressions, consider  using
          the linker command language from a script.


     -e entry
           Use entry as the explicit symbol for beginning  execu-
          tion  of  your  program,  rather than the default entry
          point.  for a discussion of defaults and other ways  of
          specifying the entry point.


     -F

     -Fformat
           Some older linkers used this option throughout a  com-
          pilation  toolchain  for  specifying object-file format
          for both input and output object files.   ld's  mechan-
          isms  (the  -b  or -format options for input files, the



cygnus support     Last change: 17 August 1992                  4






ld(1)                 GNU Development Tools                 ld(1)



          TARGET command in linker scripts for output files,  the
          GNUTARGET  environment variable) are more flexible, but
          but it accepts (and ignores) the  -F  option  flag  for
          compatibility  with  scripts  written  to  call the old
          linker.


     -format input-format
           Synonym for -b input-format.


     -g   Accepted, but ignored; provided for compatibility  with
          other tools.


     -i   Perform an incremental link (same as option -r).


     -lar  Add an archive file ar to the list of files  to  link.
          This  option  may be used any number of times.  ld will
          search its path-list for  occurrences  of  libar.a  for
          every ar specified.


     -Lsearchdir
           This command adds path searchdir to the list of  paths
          that ld will search for archive libraries.  You may use
          this option any number of times.

          The default set of paths searched (without being speci-
          fied  with -L) depends on what emulation mode ld is us-
          ing, and in some cases also on how it  was  configured.
          The  paths  can also be specified in a link script with
          the SEARCH_DIR command.


     -M

     -m   Print  (to  the  standard  output  file)  a  link  map-
          diagnostic  information  about where symbols are mapped
          by ld, and information on global common storage alloca-
          tion.


     -N   specifies readable and writable text and data sections.
          If the output format supports Unix style magic numbers,
          the output is marked as OMAGIC.

          When you use the  `-N'  option,  the  linker  does  not
          page-align the data segment.





cygnus support     Last change: 17 August 1992                  5






ld(1)                 GNU Development Tools                 ld(1)



     -n   sets the text segment to be read only,  and  NMAGIC  is
          written if possible.


     -noinhibit-exec
          Normally, the linker will not produce an output file if
          it  encounters  errors  during  the link process.  With
          this flag, you can specify that  you  wish  the  output
          file retained even after non-fatal errors.


     -o output
           output output is a name for the  program  produced  by
          ld;  if  this option is not specified, the name `a.out'
          is used by default.  The script command OUTPUT can also
          specify the output file name.


     -R filename
           file  Read  symbol  names  and  their  addresses  from
          filename,  but  do not relocate it or include it in the
          output.  This allows your output file to refer symboli-
          cally  to absolute locations of memory defined in other
          programs.


     -relax
          An option with machine  dependent  effects.   Currently
          this option is only supported on the H8/300.

          On some platforms, use this option  to  perform  global
          optimizations  that  become  possible  when  the linker
          resolves addressing in your program, such  as  relaxing
          address  modes and synthesizing new instructions in the
          output object file.

          On platforms where this is not supported,  `-relax'  is
          accepted, but has no effect.


     -r   Generates relocatable output-i.e., generate  an  output
          file  that  can  in turn serve as input to ld.  This is
          often called partial linking.  As a side effect, in en-
          vironments  that  support  standard Unix magic numbers,
          this option also sets the output file's magic number to
          OMAGIC.   If  this option is not specified, an absolute
          file is produced.  When linking C++ programs, this  op-
          tion  will  not resolve references to constructors; -Ur
          is an alternative.

          This option does the same as -i.




cygnus support     Last change: 17 August 1992                  6






ld(1)                 GNU Development Tools                 ld(1)



     -S   Omits debugger symbol information (but not all symbols)
          from the output file.


     -s   Omits all symbol information from the output file.


     { script }
          You can, if you wish, include a script of  linker  com-
          mands directly in the command line instead of referring
          to it via an input file.  When the character `{' occurs
          on  the command line, the linker switches to interpret-
          ing the command language until the end of the  list  of
          commands  is  reached-flagged with a closing brace `}'.
          Other command-line options will not be recognized while
          parsing  the  script.  See the `ld' entry in `info', or
          the manual ld: the GNU linker , for  a  description  of
          the command language.


     -Tbss org

     -Tdata org

     -Ttext org
          Use org as the  starting  address  for-respectively-the
          bss,  data,  or  the  text  segment of the output file.
          textorg must be a hexadecimal integer.


     -T commandfile


     -Tcommandfile
          Equivalent to -c commandfile; supported for compatibil-
          ity with other tools.


     -t   Prints names of input files as ld processes them.


     -u sym
          Forces sym to be entered in the output file as an unde-
          fined  symbol.   This may, for example, trigger linking
          of additional modules from standard libraries.  -u  may
          be  repeated  with  different option arguments to enter
          additional undefined symbols.


     -Ur  For anything other than C++ programs,  this  option  is
          equivalent to -r: it generates relocatable output-i.e.,
          an output file that can in turn serve as input  to  ld.



cygnus support     Last change: 17 August 1992                  7






ld(1)                 GNU Development Tools                 ld(1)



          When  linking C++ programs, -Ur will resolve references
          to constructors, unlike -r.


     -v   Display the version number for ld.


     -X   If -s or -S is also specified, delete only  local  sym-
          bols beginning with `L'.


     -x   If -s or -S is also specified, delete  all  local  sym-
          bols, not just those beginning with `L'.


ENVIRONMENT
     ld always consults two environment variables: GNUTARGET  and
     LDEMULATION.   Depending on the setting of the latter, other
     environment variables may be used as well.

     GNUTARGET determines the input-file  object  format  if  you
     don't  use -b (or its synonym -format).  Its value should be
     one of the BFD names for an input format.  If  there  is  no
     GNUTARGET  in the environment, ld uses the natural format of
     the host. If GNUTARGET is set to default then  BFD  attempts
     to  discover  the  input  format  by  examining binary input
     files; this method often succeeds, but there  are  potential
     ambiguities,  since  there is no method of ensuring that the
     magic number used to flag  object-file  formats  is  unique.
     However,  the configuration procedure for BFD on each system
     places the conventional format for that system first in  the
     search-list, so ambiguities are resolved in favor of conven-
     tion.

     LDEMULATION controls some aspects of ld's dominant personal-
     ity.   Although  ld  is flexible enough to permit its use in
     many contexts regardless of configuration, you can use  this
     variable to make it act more like one or another older link-
     er by default.

     In particular, the value of LDEMULATION  controls  what  de-
     fault linker script is used (thereby controlling the default
     input and output formats; ; what default paths are  searched
     for  archive libraries; and in some cases whether additional
     linker script commands are available.

     Here is the current set of emulations available:


     LDEMULATION=gld
          Emulate the older GNU linker.  When this  emulation  is
          selected, the default library search paths are



cygnus support     Last change: 17 August 1992                  8






ld(1)                 GNU Development Tools                 ld(1)



          /lib
          /usr/lib
          /usr/local/lib/lib


          The default output format is set to  a.out-generic-big,
          and  the default machine is the system's configured BFD
          default.


     LDEMULATION=gld68k
          A variant of the gld emulation; only differs in specif-
          ically setting the default BFD machine as m68k.


     LDEMULATION=gld960
          Emulate the Intel port of the older gld  for  the  i960
          architectures.   The  default  library search paths are
          taken from two other environment variables, G960LIB and
          G960BASE.   The  default architecture is i960.  The de-
          fault output format is set to b.out.big,  and  in  fact
          the  default  output file name (if -o is not specified)
          is b.out, to reflect this variant format, for this emu-
          lation.

          This emulation can behave slightly differently  depend-
          ing  on  the  setting  of  the  ld  compile-time switch
          GNU960.  If ld is compiled with GNU960 defined, then an
          additional environment variable-GNUTARGET-is available;
          its value, if available, specifies some  other  default
          output format than b.out.big.


     LDEMULATION=gldm88kbcs
          Sets the output format to m88kbcs and the  architecture
          to m88k.  Default library search paths are

          /lib
          /usr/lib
          /usr/local/lib



     LDEMULATION=lnk960
          Emulate the Intel linker lnk960.   The  default  output
          format is coff-Intel-big.  With this emulation, ld sup-
          ports the additional script commands HLL and SYSLIB for
          specification  of  library  archives.  This is the only
          emulation with extensive support for the -A  (architec-
          ture)  command-line  option.  By default, the architec-
          ture CORE is assumed, but  you  can  choose  additional
          features from the i960 architecture family by using one



cygnus support     Last change: 17 August 1992                  9






ld(1)                 GNU Development Tools                 ld(1)



          of the following with -A (or by using  the  OUTPUT_ARCH
          command from a script):

          CORE
          KB
          SB
          MC
          XA
          CA
          KA
          SA


          The default libraries are chosen with some attention to
          the architecture selected; the core library `cg' is al-
          ways included, but the library  fpg  is  also  used  if
          you've  specified  any  of the architectures KA, SA, or
          CA.

          Like gld960, this emulation uses additional environment
          variables  to  set  the  default  library search paths.
          Also like gld960, the behavior  of  this  emulation  is
          slightly  different  depending on whether ld itself was
          compiled with GNU960 defined.

          If your ld was compiled with GNU960  defined,  the  de-
          fault  paths  are  taken  from  all  three  of G960LIB,
          G960BASE, and I960BASE.  For the first two,  paths  you
          supply  are automatically suffixed with `/lib/libcoff';
          for the last, your path is automatically suffixed  with
          `/lib'.

          If your ld was not compiled with  GNU960  defined,  the
          default  paths are taken from I960BASE, and G960BASE is
          only consulted if I960BASE is undefined.  In this  case
          G960LIB is not used at all.


     LDEMULATION=vanilla
          This is the least specific setting for ld.  You can set
          LDEMULATION=vanilla to disable emulation of other link-
          ers.  This setting makes ld take  the  default  machine
          from  the  BFD  configuration  on  your  system; a.out-
          generic-big is the default target.  No  other  defaults
          are specified.


SEE ALSO
     objdump(1)
     `ld' and `binutils' entries in info
     ld: the GNU linker, Steve Chamberlain and Roland Pesch;  The
     GNU Binary Utilities, Roland H. Pesch.



cygnus support     Last change: 17 August 1992                 10






ld(1)                 GNU Development Tools                 ld(1)



COPYING
     Copyright (c) 1991, 1992 Free Software Foundation, Inc.

     Permission is granted to make and distribute verbatim copies
     of  this  manual provided the copyright notice and this per-
     mission notice are preserved on all copies.

     Permission is granted to copy and distribute  modified  ver-
     sions of this manual under the conditions for verbatim copy-
     ing, provided that the entire resulting derived work is dis-
     tributed under the terms of a permission notice identical to
     this one.

     Permission is granted to copy and distribute translations of
     this  manual  into  another language, under the above condi-
     tions for modified versions, except that this permission no-
     tice  may  be  included in translations approved by the Free
     Software Foundation instead of in the original English.





































cygnus support     Last change: 17 August 1992                 11



