


RCS(1)                   USER COMMANDS                     RCS(1)



NAME
     rcs - change RCS file attributes

SYNOPSIS
     rcs [ options ] file ...

DESCRIPTION
     rcs creates new RCS files or changes attributes of  existing
     ones.   An  RCS file contains multiple revisions of text, an
     access list, a change log, descriptive text, and  some  con-
     trol  attributes.   For rcs to work, the caller's login name
     must be on the access list, except if  the  access  list  is
     empty, the caller is the owner of the file or the superuser,
     or the -i option is present.

     File names ending in ,v denote RCS files; all others  denote
     working  files.   If  a  working file is given, rcs tries to
     find the corresponding RCS file first in an RCS subdirectory
     and  then  in  the working file's directory, as explained in
     co(1).

OPTIONS
     -i   Create and initialize a new RCS file, but do not  depo-
          sit  any revision.  If the RCS file has no path prefix,
          try to place it first into the subdirectory ./RCS,  and
          then  into  the  current  directory.   If  the RCS file
          already exists, print an error message.

     -alogins
          Append the login names appearing in the comma-separated
          list logins to the access list of the RCS file.

     -Aoldfile
          Append the access list of oldfile to the access list of
          the RCS file.

     -e[logins]
          Erase the login names appearing in the  comma-separated
          list  logins  from the access list of the RCS file.  If
          logins is omitted, erase the entire access list.

     -b[rev]
          Set the default branch to rev.  If rev is omitted,  the
          default  branch  is  reset to the (dynamically) highest
          branch on the trunk.

     -cstring
          sets the comment leader to string.  The comment  leader
          is  printed  before every log message line generated by
          the keyword $Log$ during checkout (see co(1)).  This is
          useful  for  programming  languages  without multi-line
          comments.  An initial ci , or  an  rcs -i  without  -c,



GNU                  Last change: 1990/12/04                    1






RCS(1)                   USER COMMANDS                     RCS(1)



          guesses the comment leader from the suffix of the work-
          ing file.

     -ksubst
          Set the default keyword  substitution  to  subst.   The
          effect  of  keyword substitution is described in co(1).
          Giving an  explicit  -k  option  to  co,  rcsdiff,  and
          rcsmerge   overrides  this  default.   Beware  rcs -kv,
          because -kv is incompatible with co -l.   Use  rcs -kkv
          to restore the normal default keyword substitution.

     -l[rev]
          Lock the revision with number  rev.   If  a  branch  is
          given, lock the latest revision on that branch.  If rev
          is omitted, lock the latest  revision  on  the  default
          branch.   Locking prevents overlapping changes.  A lock
          is removed with ci or rcs -u (see below).

     -u[rev]
          Unlock the revision with number rev.  If  a  branch  is
          given,  unlock  the latest revision on that branch.  If
          rev is omitted, remove the  latest  lock  held  by  the
          caller.   Normally,  only  the locker of a revision may
          unlock it.  Somebody else unlocking a  revision  breaks
          the lock.  This causes a mail message to be sent to the
          original locker.  The  message  contains  a  commentary
          solicited  from  the  breaker.   The commentary is ter-
          minated by end-of-file or by  a  line  containing  . by
          itself.

     -L   Set locking to strict.  Strict locking means  that  the
          owner  of  an  RCS  file is not exempt from locking for
          checkin.  This option should be used for files that are
          shared.

     -U   Set locking to non-strict.   Non-strict  locking  means
          that  the  owner of a file need not lock a revision for
          checkin.  This option should not be used for files that
          are  shared.   Whether  default  locking  is  strict is
          determined by your system administrator, but it is nor-
          mally strict.

     -nname[:rev]
          Associate the symbolic name name  with  the  branch  or
          revision  rev.   Print  an  error  message  if  name is
          already associated with  another  number.   If  rev  is
          omitted, the symbolic name is deleted.

     -Nname[:rev]
          Act like -n, except override any previous assignment of
          name.




GNU                  Last change: 1990/12/04                    2






RCS(1)                   USER COMMANDS                     RCS(1)



     -orange
          deletes ("outdates") the revisions given by  range.   A
          range consisting of a single revision number means that
          revision.  A range consisting of a branch number  means
          the  latest  revision  on  that branch.  A range of the
          form rev1-rev2 means revisions rev1 to rev2 on the same
          branch,  -rev  means  from  the beginning of the branch
          containing rev up to and including rev, and rev-  means
          from  revision  rev to the end of the branch containing
          rev.  None of the outdated revisions may have  branches
          or locks.

     -q   Run quietly; do not print diagnostics.

     -I   Run interactively, even if the standard input is not  a
          terminal.

     -sstate[:rev]
          Set the state attribute of the revision rev to state  .
          If  rev  is a branch number, assume the latest revision
          on that branch.  If rev is omitted, assume  the  latest
          revision  on  the  default  branch.   Any identifier is
          acceptable for state.  A useful set of  states  is  Exp
          (for  experimental),  Stab  (for  stable), and Rel (for
          released).  By default, ci(1) sets the state of a revi-
          sion to Exp.

     -t[file]
          Write descriptive text from the contents of  the  named
          file  into  the  RCS  file, deleting the existing text.
          The file name may not begin with -.  If file  is  omit-
          ted, obtain the text from standard input, terminated by
          end-of-file  or  by  a  line  containing  . by  itself.
          Prompt for the text if interaction is possible; see -I.
          With -i, descriptive text is obtained even if -t is not
          given.

     -t-string
          Write descriptive text from the  string  into  the  RCS
          file, deleting the existing text.

     -Vn  Emulate RCS version n.  See co(1) for details.

COMPATIBILITY
     The -brev option generates an RCS file that cannot be parsed
     by RCS version 3 or earlier.

     The -ksubst options (except -kkv) generate an RCS file  that
     cannot be parsed by RCS version 4 or earlier.

     Use rcs -Vn to make an RCS file acceptable to RCS version  n
     by discarding information that would confuse version n.



GNU                  Last change: 1990/12/04                    3






RCS(1)                   USER COMMANDS                     RCS(1)



DIAGNOSTICS
     The RCS file name and the revisions outdated are written  to
     the  diagnostic output.  The exit status is zero if and only
     if all operations were successful.

FILES
     rcs accesses files much as ci(1) does, except that  it  does
     not need to access the working file or its directory.

IDENTIFICATION
     Author: Walter F. Tichy.
     Revision Number: 5.3; Release Date: 1990/12/04.
     Copyright (c) 1982, 1988, 1989 by Walter F. Tichy.
     Copyright (c) 1990 by Paul Eggert.

SEE ALSO
     co(1),    ci(1),    ident(1),    rcsdiff(1),    rcsintro(1),
     rcsmerge(1), rlog(1), rcsfile(5)
     Walter  F.  Tichy,  RCS--A  System  for   Version   Control,
     Software--Practice & Experience 15, 7 (July 1985), 637-654.



































GNU                  Last change: 1990/12/04                    4



