


RCSMERGE(1)              USER COMMANDS                RCSMERGE(1)



NAME
     rcsmerge - merge RCS revisions

SYNOPSIS
     rcsmerge [options] file

DESCRIPTION
     rcsmerge incorporates the changes between two  revisions  of
     an RCS file into the corresponding working file.

     A file name ending in ,v is an RCS file  name,  otherwise  a
     working  file  name.  rcsmerge derives the working file name
     from the RCS file name  and  vice  versa,  as  explained  in
     co(1).   A pair consisting of both an RCS and a working file
     name may also be specified.

     At least one revision must be  specified  with  one  of  the
     options  described below, usually -r.  At most two revisions
     may be specified.  If only one revision  is  specified,  the
     latest is omitted, the latest revision on the default branch
     (normally the highest branch on the trunk)  is  assumed  for
     the second revision.  Revisions may be specified numerically
     or symbolically.

     rcsmerge prints a warning if there are overlaps, and  delim-
     its the overlapping regions as explained in co -j.  The com-
     mand is useful for incorporating changes into a  checked-out
     revision.

OPTIONS
     -ksubst
          Use subst style keyword substitution.   See  co(1)  for
          details.   For example, -kk -r1.1 -r1.2 ignores differ-
          ences in keyword values when merging the  changes  from
          1.1 to 1.2.

     -p[rev]
          Send the result to standard output instead of overwrit-
          ing the working file.

     -q[rev]
          Run quietly; do not print diagnostics.

     -r[rev]
          Merge with respect to revision rev.

     -Vn  Emulate RCS version n.  See co(1) for details.

EXAMPLES
     Suppose you have  released  revision  2.8  of  f.c.   Assume
     furthermore  that  after you complete an unreleased revision
     3.4, you receive updates to release 2.8 from  someone  else.



GNU                  Last change: 1990/08/29                    1






RCSMERGE(1)              USER COMMANDS                RCSMERGE(1)



     To  combine  the updates to 2.8 and your changes between 2.8
     and 3.4, put the updates to 2.8 into file f.c and execute

         rcsmerge  -p  -r2.8  -r3.4  f.c  >f.merged.c

     Then examine f.merged.c.  Alternatively, if you want to save
     the  updates  to 2.8 in the RCS file, check them in as revi-
     sion 2.8.1.1 and execute co -j:

         ci  -r2.8.1.1  f.c
         co  -r3.4  -j2.8:2.8.1.1  f.c

     As another example, the following command undoes the changes
     between  revision  2.4 and 2.8 in your currently checked out
     revision in f.c.

         rcsmerge  -r2.8  -r2.4  f.c

     Note the order of  the  arguments,  and  that  f.c  will  be
     overwritten.

DIAGNOSTICS
     Exit status is 0 for no overlaps, 1 for some overlaps, 2 for
     trouble.

IDENTIFICATION
     Author: Walter F. Tichy.
     Revision Number: 5.1; Release Date: 1990/08/29.
     Copyright (c) 1982, 1988, 1989 by Walter F. Tichy.
     Copyright (c) 1990 by Paul Eggert.

SEE ALSO
     ci(1), co(1), ident(1), merge(1), rcs(1), rcsdiff(1), rcsin-
     tro(1), rlog(1), rcsfile(5)
     Walter  F.  Tichy,  RCS--A  System  for   Version   Control,
     Software--Practice & Experience 15, 7 (July 1985), 637-654.



















GNU                  Last change: 1990/08/29                    2



