CSPLIT(1L)                                             CSPLIT(1L)


NAME
       csplit  - split a file into sections determined by context
       lines

SYNOPSIS
       csplit [-sqkz] [-f prefix] [-b suffix] [-n digits] [--pre-
       fix=prefix]   [--suffix-format=suffix]   [--digits=digits]
       [--quiet] [--silent] [--keep-files]  [--elide-empty-files]
       [--help] [--version] file pattern...

DESCRIPTION
       This  manual  page  documents  the  GNU version of csplit.
       csplit creates zero or more output files  containing  sec-
       tions  of  the  given input file, or the standard input if
       the name `-' is given.  By default, csplit prints the num-
       ber of bytes written to each output file after it has been
       created.

       The contents of the output files  are  determined  by  the
       pattern  arguments.  An error occurs if a pattern argument
       refers to a nonexistent line of the input file, such as if
       no  remaining  line  matches  a  given regular expression.
       After all  the  given  patterns  have  been  matched,  any
       remaining output is copied into one last output file.  The
       types of pattern arguments are:

              line
                     Create an output file containing the current
                     line  up to (but not including) line line (a
                     positive integer) of  the  input  file.   If
                     followed  by  a repeat count, also create an
                     output file containing the next  line  lines
                     of the input file once for each repeat.

              /regexp/[offset]
                     Create an output file containing the current
                     line up to (but not including) the next line
                     of  the input file that contains a match for
                     regexp.  The optional offset is a `+' or `-'
                     followed  by  a  positive integer.  If it is
                     given, the input up  to  the  matching  line
                     plus  or minus offset is put into the output
                     file, and the line  after  that  begins  the
                     next section of input.

              %regexp%[offset]
                     Like  the previous type, except that it does
                     not create an output file, so  that  section
                     of the input file is effectively ignored.

              {repeat-count}
                     Repeat  the previous pattern repeat-count (a
                     positive  integer)  additional   times.   An
                     asterisk  may  be  given  in  place  of  the


FSF                     GNU Text Utilities                      1
CSPLIT(1L)                                             CSPLIT(1L)


                     (integer) repeat count, in  which  case  the
                     preceeding pattern is repeated as many times
                     as necessary until the input is exausted.

       The output file names consist of a prefix  followed  by  a
       suffix.   By  default,  the  suffix is merely an ascending
       linear sequence of two-digit decimal numbers starting with
       00 and ranging up to 99, however this default may be over-
       ridden by either the --digits  option  or  by  the  --suf-
       fix-format option.  (See below.)  In any case, concatenat-
       ing the output files in sorted order by file name produces
       the  original  input  file,  in order.  The default output
       file name prefix is `xx'.

       By default, if csplit encounters an error  or  receives  a
       hangup,  interrupt,  quit, or terminate signal, it removes
       any output files that it has  created  so  far  before  it
       exits.

   OPTIONS
       -f, --prefix=prefix
              Use prefix as the output file name prefix string.

       -b, --suffix-format=suffix
              Use  suffix  as the output file name suffix string.
              When this option is specified,  the  suffix  string
              must include exactly one printf(3) style conversion
              specification (such as %d, possibly including  for-
              mat specification flags, a field width, a precision
              specifications, or all  of  these  kinds  of  modi-
              fiers).  The conversion specification must be suit-
              able for converting a binary  integer  argument  to
              readable form.  Thus, only `d', 'i', `u', `o', `x',
              and `X' format specifiers are allowed.  The  entire
              suffix  string  is  given  (with the current output
              file number) to sprintf(3) to form  the  file  name
              suffixes for each of the individual output files in
              turn.  Note that when  this  option  is  used,  the
              --digits option is ignored.

       -n, --digits=digits
              Use  output  file names containing numbers that are
              digits digits long instead of the default 2.

       -k, --keep-files
              Do not remove output files when errors are  encoun-
              tered.

       -z, --elide-empty-files
              Suppress   the  generation  of  zero-length  output
              files.  (In cases where the section  delimiters  of
              the input file are supposed to mark the first lines
              of each of the sections, the first output file will
              generally be a zero-length file unless you use this


FSF                     GNU Text Utilities                      2
CSPLIT(1L)                                             CSPLIT(1L)


              option.)  Note that the output file  sequence  num-
              bers  will  always run consecutively, starting from
              0, even in cases where zero-length output  sections
              are suppressed due to the use of this option.

       -s, -q, --silent, --quiet
              Do not print counts of output file sizes.

       --help Print a usage message and exit with a non-zero sta-
              tus.

       --version
              Print version information on standard  output  then
              exit.










































FSF                     GNU Text Utilities                      3
