typedef struct
   {
   POINT from;
   POINT to;
   } LINEX;

typedef struct
   {
   HBITMAP CutMemoryBitMap; /* Used to store cut and paste */
   int CutHeight;           /* current cut height */
   int CutWidth;            /* current cut width */
   long CutFlag;            /* flag to signal something in cut buffer */
   } CUTMAP;

class TMyFileWindow : public TxFileWindow
   {
   NODE *args_list;

   public:
   HGLOBAL hEditHeap;

   TMyFileWindow(PTWindowsObject, LPSTR, LPSTR, NODE *);
   ~TMyFileWindow();

   virtual BOOL CanClose();
   virtual void DefWndProc(RTMessage Msg);
   virtual void ContextHelp();

   virtual void CMExit(RTMessage Msg)
   = [CM_FIRST + CM_EXIT];
   virtual void CMHelpEdit(RTMessage Msg)
   = [CM_FIRST + CM_HELPEDIT];
   virtual void CMHelpEditTopic(RTMessage Msg)
   = [CM_FIRST + CM_HELPEDIT_TOPIC];
   virtual void CMTest(RTMessage Msg)
   = [CM_FIRST + CM_TEST];
   };

class TMyEditboxWindow : public TEdit
   {
   public:
   TMyEditboxWindow(PTWindowsObject, int, WORD);
   ~TMyEditboxWindow();

   virtual void WMKeyDown(RTMessage Msg)
   = [WM_FIRST + WM_KEYDOWN];
   virtual void WMGetDlgCode(RTMessage Msg)
   = [WM_FIRST + WM_GETDLGCODE];
   };

class TMyListboxWindow : public TListBox
   {
   public:
   TMyListboxWindow(PTWindowsObject, int);
   ~TMyListboxWindow();

   virtual void WMKeyDown(RTMessage Msg)
   = [WM_FIRST + WM_KEYDOWN];
   virtual void WMGetDlgCode(RTMessage Msg)
   = [WM_FIRST + WM_GETDLGCODE];
   };

class TMyCommandWindow : public TDialog
   {
   public:
   TMyCommandWindow(PTWindowsObject, LPSTR);
   ~TMyCommandWindow();
   
   virtual void GetWindowClass(WNDCLASS& WndClass);
   virtual void DefWndProc(RTMessage Msg);
   
   virtual void WMSize(RTMessage Msg)
   = [WM_FIRST + WM_SIZE];
   virtual void DoListBox(RTMessage Msg)
   = [ID_FIRST + ID_LISTBOX];
   virtual void DoEditBox(RTMessage Msg)
   = [ID_FIRST + ID_EDITINPUT];
   virtual void DoButtonExecute(RTMessage Msg)
   = [ID_FIRST + ID_EXECUTE];
   virtual void DoButtonHalt(RTMessage Msg)
   = [ID_FIRST + ID_HALT];
   virtual void DoButtonStatus(RTMessage Msg)
   = [ID_FIRST + ID_STATUS];
   virtual void DoButtonYield(RTMessage Msg)
   = [ID_FIRST + ID_YIELD];
   virtual void DoButtonPause(RTMessage Msg)
   = [ID_FIRST + ID_PAUSE];
   virtual void DoButtonTrace(RTMessage Msg)
   = [ID_FIRST + ID_TRACE];
   virtual void DoButtonReset(RTMessage Msg)
   = [ID_FIRST + ID_RESET];
   };

class TMyStatusWindow : public TDialog
   {
   public:
   TMyStatusWindow(PTWindowsObject, LPSTR);
   ~TMyStatusWindow();
   };

class TMyPrinterAreaWindow : public TDialog
   {
   public:
   TMyPrinterAreaWindow(PTWindowsObject, LPSTR);
   ~TMyPrinterAreaWindow();
   
   virtual void WMInitDialog(RTMessage Msg)
   = [WM_FIRST + WM_INITDIALOG];
   
   virtual void DoXLow(RTMessage Msg)
   = [ID_FIRST + ID_XLOW];
   virtual void DoXHigh(RTMessage Msg)
   = [ID_FIRST + ID_XHIGH];
   virtual void DoYLow(RTMessage Msg)
   = [ID_FIRST + ID_YLOW];
   virtual void DoYHigh(RTMessage Msg)
   = [ID_FIRST + ID_YHIGH];
   virtual void DoFullImage(RTMessage Msg)
   = [ID_FIRST + ID_FULLIMAGE];
   virtual void DoCustomImage(RTMessage Msg)
   = [ID_FIRST + ID_CUSTOMIMAGE];
   };

class TMyFileEditWindow : public TDialog
   {
   public:

   int FileEditAll;

   TMyFileEditWindow(PTWindowsObject, LPSTR);
   ~TMyFileEditWindow();
   
   virtual BOOL CanClose();
//   virtual void DefWndProc(RTMessage Msg);

   virtual void WMInitDialog(RTMessage Msg)
   = [WM_FIRST + WM_INITDIALOG];
   virtual void DoAll(RTMessage Msg)
   = [ID_FIRST + ID_FILEEDITALL];
   virtual void DoCombo(RTMessage Msg)
   = [ID_FIRST + ID_FILEEDITCOMBO];
   };

class TMyApp : public TApplication
   {
   public:
   HDC TempDC;
   RECT RR;
   
   TMyApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,LPSTR lpCmdLine, int nCmdShow)
   : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
   virtual void InitMainWindow();
   virtual void InitInstance();
   virtual void IdleAction();
   virtual BOOL TMyApp::ProcessAppMsg(LPMSG msg);
   };

_CLASSDEF(TMyWindow)
class TMyWindow : public TWindow
   {
   public:
   PTPrinter Printer;    // Pointer to a TPrinter object
   //   HBITMAP BitmapHandle;
   
   WORD bitCount;
   WORD size;
   BITMAPINFO *BitmapInfo;
   
   TMyFileWindow *EditWindow;
   PTDialog CommandWindow;
   TMyEditboxWindow *EditboxWindow;
   TMyListboxWindow *ListboxWindow;
   PTDialog StatusWindow;
   PTDialog PrinterAreaWindow;
   HICON HIcon;
   TMyFileEditWindow *FileEditWindow;
   DLGPROC lpProcAbout;
   HDC ScreenDC;
   HDC MemDC;
   HDC PrintMemDC;
   RECT R;
   RECT RR;
   long ii;
   int PenSize;
   char FileName[MAXPATH];
   char BitmapName[MAXPATH];
   BOOL IsNewFile;
   BOOL IsNewBitmap;
   TMyWindow(PTWindowsObject AParent, LPSTR ATitle);
   ~TMyWindow();
   
   void MyPopupEdit(char *FileName,NODE *args);
   void MyPopupCommander();
   void MyPopupStatus();
   void MyPopupStatusKill();
   int MyPopupInput(char *str,char *pmt);
   
   BOOL LoadBitmapFile(LPSTR);
   BOOL OpenDIB(int);
   void GetBitmapData(int TheFile, HANDLE, long);
   
   BOOL DumpBitmapFile(LPSTR);
   BOOL WriteDIB(int TheFile);
   void PutBitmapData(int TheFile, HANDLE, long);
   
   virtual BOOL CanClose();
   virtual void GetWindowClass(WNDCLASS& WndClass);
   virtual void Paint(HDC DC, PAINTSTRUCT& PS);
   virtual void Printit(HDC DC);
   virtual void SaveFile();
   virtual void SaveFileAs();
   virtual void SaveBitmap();
   virtual void SaveBitmapAs();
   virtual void SetupWindow();

   virtual void WMKeyDown(RTMessage Msg)
   = [WM_FIRST + WM_KEYDOWN];
   virtual void WMKeyUp(RTMessage Msg)
   = [WM_FIRST + WM_KEYUP];
   virtual void WMChar(RTMessage Msg)
   = [WM_FIRST + WM_CHAR];
   virtual void WMGetDlgCode(RTMessage Msg)
   = [WM_FIRST + WM_GETDLGCODE];
   virtual void WMLButtonDown(RTMessage Msg)
   = [WM_FIRST + WM_LBUTTONDOWN];
   virtual void WMLButtonUp(RTMessage Msg)
   = [WM_FIRST + WM_LBUTTONUP];
   virtual void WMRButtonDown(RTMessage Msg)
   = [WM_FIRST + WM_RBUTTONDOWN];
   virtual void WMRButtonUp(RTMessage Msg)
   = [WM_FIRST + WM_RBUTTONUP];
   virtual void WMMouseMove(RTMessage Msg)
   = [WM_FIRST + WM_MOUSEMOVE];

#ifdef ISWIN31
   virtual void MMMCINotify(RTMessage Msg)
   = [WM_FIRST + MM_MCINOTIFY];
#endif
   virtual void WMTIMER(RTMessage Msg)
   = [WM_FIRST + WM_TIMER];

   virtual void CMFileNew(RTMessage Msg)
   = [CM_FIRST + CM_FILENEW];
   virtual void CMFileOpen(RTMessage Msg)
   = [CM_FIRST + CM_FILEOPEN];
   virtual void CMFileSave(RTMessage Msg)
   = [CM_FIRST + CM_FILESAVE];
   virtual void CMFileSaveAs(RTMessage Msg)
   = [CM_FIRST + CM_FILESAVEAS];
   virtual void CMFileEdit(RTMessage Msg)
   = [CM_FIRST + CM_FILEEDIT];
   virtual void CMFileErase(RTMessage Msg)
   = [CM_FIRST + CM_FILEERASE];
   virtual void CMExit(RTMessage Msg)
   = [CM_FIRST + CM_EXIT];

   virtual void CMBitmapNew(RTMessage Msg)
   = [CM_FIRST + CM_BITMAPNEW];
   virtual void CMBitmapOpen(RTMessage Msg)
   = [CM_FIRST + CM_BITMAPOPEN];
   virtual void CMBitmapSave(RTMessage Msg)
   = [CM_FIRST + CM_BITMAPSAVE];
   virtual void CMBitmapSaveAs(RTMessage Msg)
   = [CM_FIRST + CM_BITMAPSAVEAS];
   virtual void CMBitmapPrint(RTMessage Msg)
   = [CM_FIRST + CM_BITMAPPRINT];
   virtual void CMBitmapPrinterSetup(RTMessage Msg)
   = [CM_FIRST + CM_BITMAPPRINTERSETUP];
   virtual void CMBitmapPrinterArea(RTMessage Msg)
   = [CM_FIRST + CM_BITMAPPRINTERAREA];

   virtual void CMHelp(RTMessage Msg)
   = [CM_FIRST + CM_HELP];
   virtual void CMHelpMCI(RTMessage Msg)
   = [CM_FIRST + CM_HELP_MCI];
   virtual void CMHelpHelp(RTMessage Msg)
   = [CM_FIRST + CM_HELP_HELP];
   virtual void CMHelpAbout(RTMessage Msg)
   = [CM_FIRST + CM_ABOUT];

   virtual void CMControlHalt(RTMessage Msg)
   = [CM_FIRST + CM_CONTROLHALT];
   virtual void CMControlExecute(RTMessage Msg)
   = [CM_FIRST + CM_CONTROLEXECUTE];

   virtual void CMSetFont(RTMessage Msg)
   = [CM_FIRST + CM_SETFONT];
   virtual void CMSetPenColor(RTMessage Msg)
   = [CM_FIRST + CM_SETPENCOLOR];
   virtual void CMSetFloodColor(RTMessage Msg)
   = [CM_FIRST + CM_SETFLOODCOLOR];
   virtual void CMSetScreenColor(RTMessage Msg)
   = [CM_FIRST + CM_SETSCREENCOLOR];

   virtual void WMSize(RTMessage Msg)
   = [WM_FIRST + WM_SIZE];

   virtual void WMCheckQueue(RTMessage Msg)
   = [WM_FIRST + WM_CHECKQUEUE];

   virtual void DefWndProc(RTMessage Msg);
   
   protected:
   TMyWindow(StreamableInit) : TWindow(streamableInit) {};
   
   private:
   const Pchar streamableName() const { return "TMyWindow"; }
   };

_CLASSDEF(TRulerOut)
class TRulerOut : public TPrintout
   {
   public:
   TRulerOut(Pchar ATitle) : TPrintout(ATitle) {}
   virtual void PrintPage(HDC DC, WORD Page, POINT Size, LPRECT Rect,
   WORD Flags);
   void SetBanding( BOOL b ) { Banding = b; }
   };

_CLASSDEF(TMyScroller)
class TMyScroller : public TScroller
   {
   public:
   long XPos;
   long YPos;
   };

typedef void* ent;

class qlink
   {
   friend class qlist;
   
   qlink *next;
   qlink *prev;
   int type;
   ent e;
   
   qlink(ent a, qlink* n, qlink* p, int t)
      {
      e=a;
      next=n;
      prev=p;
      type=t;
      }
   };

class qlist
   {
   qlink* last;
   public:
   void insert(ent a, int t);
   ent  get();
   void zap();
   void clear();
   
   qlist()
      {
      last = NULL;
      }
   
   qlist(ent a, int t)
      {
      last=new qlink(a, NULL, NULL, t);
      last->next=last;
      last->prev=last;
      }
   
   ~qlist()
      {
      clear();
      }
   };

typedef struct callthing
   {
   char *func;
   int	arg1;
   int  arg2;
   int  kind;
   };

struct calllist : qlist
   {
   void insert(callthing* a, int t) { qlist::insert(a, t); }
   callthing* get()                 { return(callthing*)qlist::get(); }
   };

extern HANDLE HashHandle;
extern HANDLE StackHandle;   

extern calllist calllists;

extern HBITMAP MemoryBitMap;
extern HBITMAP AreaMemoryBitMap;

extern HICON hCursor;
extern HICON hCursorWait;

extern HPALETTE ThePalette;

extern LPLOGPALETTE MyLogPalette;

extern NUMBER the_zoom;
extern NUMBER ibmoldx;
extern NUMBER ibmoldy;

extern NODE *current_line;

extern char LibPathName[];
extern char TempPathName[];
extern char szHelpFileName[];
extern char MCIHelpFileName[];
extern char SelectedText[];
extern char YABuffer[];

extern HINSTANCE ModulehInstance;

extern HWND MainHWindow;
extern HWND CmdHWindow;
extern HWND StatusHWindow;
extern HWND EdtHWindow;

extern HWND ListHWindow;
extern HWND EditHWindow;
extern HWND ExecuteHWindow;
extern HWND HaltHWindow;
extern HWND TraceHWindow;
extern HWND PauseHWindow;
extern HWND StatHWindow;
extern HWND YieldHWindow;
extern HWND ResetHWindow;

extern HBITMAP OldBitmap;
extern HBITMAP OldBitmap2;

extern HPALETTE OldPalette;
extern HPALETTE OldPalette2;

extern HPEN OldPen;

extern HBRUSH OldBrush;

extern HFONT OldFont;

extern LOGFONT FontRec;

extern LOGPEN NormalPen;
extern LOGPEN ErasePen;

extern LOGBRUSH FloodBrush;
extern LOGBRUSH ScreenBrush;

extern RECT FullRect;
extern RECT TempRect;

extern PTWindowsObject MainWindowx;

extern int PrinterAreaXLow;
extern int PrinterAreaXHigh;
extern int PrinterAreaYLow;
extern int PrinterAreaYHigh;
extern int TPrinterAreaXLow;
extern int TPrinterAreaXHigh;
extern int TPrinterAreaYLow;
extern int TPrinterAreaYHigh;

extern CUTMAP *CutBmp;
extern int CutIndex;
//extern int CutHeight;
//extern int CutWidth;
extern int dpenr;
extern int dpeng;
extern int dpenb;
extern int dfldr;
extern int dfldg;
extern int dfldb;
extern int dscnr;
extern int dscng;
extern int dscnb;
extern int IsDirty;
extern int NumFonts;
extern int BitMapWidth ;
extern int BitMapHeight;
extern int EnablePalette;
extern int CustomFlag;
extern int TCustomFlag;
extern int Command_OK;
extern int halt_flag;
extern int traceflag;
extern int pause_flag;
extern int MaxWidth;
extern int MaxHeight;
extern int JustDidEdit;
extern int Time_To_Pause;
extern int Time_To_Halt;
extern int MaxX;
extern int MaxY;
extern int BaseUnitsx;
extern int BaseUnitsy;

extern long scolor;
extern long fcolor;
extern long pcolor;
extern long width;
extern long zoom_flag;
extern long MaxColors;
extern long first_init;

extern LINEX TurtlePoints[];

extern void MakeHelpPathName(char *szFileName,char *); /*routine*/
extern BOOL FAR PASCAL About(HWND, unsigned, WORD, LONG);
extern int current_write_mode; /* State of pen */
