/*
 *      coms.c	  program execution control module	dvb
 *
 *	Copyright (C) 1989 The Regents of the University of California
 *	This Software may be copied and distributed for educational,
 *	research, and not for profit purposes provided that this
 *	copyright and statement are included in all such copies.
 *
 */

#include "logo.h"
#include "globals.h"
#ifdef ibm
#include "process.h"
#include <time.h>
#endif
#ifdef mac
#include <console.h>
#endif

FIXNUM ift_iff_flag = -1;

NODE *make_cont(enum labels cont, NODE *val) {
#ifdef __ZTC__
    union { enum labels lll;
    	   NODE *ppp;} cast;
#endif
    NODE *retval = cons(NIL, val);
#ifdef __ZTC__
    cast.lll = cont;
    retval->n_car = cast.ppp;
#else
    retval->n_car = (NODE *)cont;
#endif
    settype(retval, CONT);
    return retval;
}

NODE *loutput(NODE *arg)
{
    if (NOT_THROWING) {
	stopping_flag = OUTPUT;
	output_node = reref(output_node, car(arg));
    }
    return(UNBOUND);
}

NODE *lstop()
{
    if (NOT_THROWING)
	stopping_flag = STOP;
    return(UNBOUND);
}

NODE *lthrow(NODE *arg)
{
    if (NOT_THROWING) {
	if (compare_node(car(arg),Error,TRUE) == 0) {
	    if (cdr(arg) != NIL)
		err_logo(USER_ERR, cadr(arg));
	    else
		err_logo(USER_ERR, UNBOUND);
	} else {
	    stopping_flag = THROWING;
	    throw_node = reref(throw_node, car(arg));
	    if (cdr(arg) != NIL)
		output_node = reref(output_node, cadr(arg));
	    else
		output_node = reref(output_node, UNBOUND);
	}
    }
    return(UNBOUND);
}

NODE *lcatch(NODE *args)
{
    return make_cont(catch_continuation, cons(car(args), lrun(cdr(args))));
}

int torf_arg(NODE *args)
{
    NODE *arg = car(args);

    while (NOT_THROWING) {
	if (compare_node(arg, Truex, TRUE) == 0) return TRUE;
	if (compare_node(arg, Falsex, TRUE) == 0) return FALSE;
	setcar(args, err_logo(BAD_DATA, arg));
	arg = car(args);
    }
    return -1;
}

NODE *lnot(NODE *args)
{
    int arg = torf_arg(args);

    if (NOT_THROWING) {
	if (arg) return(Falsex);
	else return(Truex);
    }
    return(UNBOUND);
}

NODE *land(NODE *args)
{
    int arg;

    if (args == NIL) return(Truex);
    while (NOT_THROWING) {
	arg = torf_arg(args);
	if (arg == FALSE)
	    return(Falsex);
	args = cdr(args);
	if (args == NIL) break;
    }
    if (NOT_THROWING) return(Truex);
    else return(UNBOUND);
}

NODE *lor(NODE *args)
{
    int arg;

    if (args == NIL) return(Falsex);
    while (NOT_THROWING) {
	arg = torf_arg(args);
	if (arg == TRUE)
	    return(Truex);
	args = cdr(args);
	if (args == NIL) break;
    }
    if (NOT_THROWING) return(Falsex);
    else return(UNBOUND);
}

NODE *runnable_arg(NODE *args) {
    NODE *arg = car(args);

    if (!aggregate(arg)) {
	setcar(args, parser(arg, TRUE));
	arg = car(args);
    }
    while (!is_list(arg) && NOT_THROWING) {
	setcar(args, err_logo(BAD_DATA, arg));
	arg = car(args);
    }
    return(arg);
}

NODE *lif(NODE *args)	/* macroized */
{
    NODE *yes;
    int pred;

    if (cddr(args) != NIL) return(lifelse(args));

    pred = torf_arg(args);
    yes = runnable_arg(cdr(args));
    if (NOT_THROWING) {
	if (pred) return(yes);
	return(NIL);
    }
    return(UNBOUND);
}

NODE *lifelse(NODE *args)    /* macroized */
{
    NODE *yes, *no;
    int pred;

    pred = torf_arg(args);
    yes = runnable_arg(cdr(args));
    no = runnable_arg(cddr(args));
    if (NOT_THROWING) {
	if (pred) return(yes);
	return(no);
    }
    return(UNBOUND);
}

NODE *lrun(NODE *args)    /* macroized */
{
    NODE *arg = runnable_arg(args);

    if (NOT_THROWING) return(arg);
    return(UNBOUND);
}

NODE *lrunresult(NODE *args)
{
    return make_cont(runresult_continuation, lrun(args));
}

NODE *pos_int_arg(NODE *args)
{
    NODE *arg = car(args), *val;

    val = cnv_node_to_numnode(arg);
    while ((nodetype(val) != INT || getint(val) < 0) && NOT_THROWING) {
	gcref(val);
	setcar(args, err_logo(BAD_DATA, arg));
	arg = car(args);
	val = cnv_node_to_numnode(arg);
    }
    setcar(args,val);
    if (nodetype(val) == INT) return(val);
    return UNBOUND;
}

NODE *lrepeat(NODE *args)
{
    NODE *cnt, *torpt, *retval = NIL;

    global_repcount_index++;
    global_repcount[global_repcount_index] = 1;
    cnt = pos_int_arg(args);
    torpt = lrun(cdr(args));
    if (NOT_THROWING) {
	retval = make_cont(repeat_continuation, cons(cnt,torpt));
    }
    return(retval);
}

NODE *lrepcount()
{
    return(make_intnode((FIXNUM)global_repcount[global_repcount_index]));
}

NODE *lforever(NODE *args)
{
    NODE *torpt = lrun(args);

    if (NOT_THROWING)
    return make_cont(repeat_continuation, cons(make_intnode(-1), torpt));
    return NIL;
}

NODE *ltest(NODE *args)
{
    int arg = torf_arg(args);

    if (tailcall != 0) return UNBOUND;
    if (NOT_THROWING) {
	ift_iff_flag = arg;
        dont_fix_ift = 1;
    }
    return(UNBOUND);
}

NODE *liftrue(NODE *args)
{
    if (ift_iff_flag < 0)
	return(err_logo(NO_TEST,NIL));
    else if (ift_iff_flag > 0)
	return(lrun(args));
    else
	return(NIL);
}

NODE *liffalse(NODE *args)
{
    if (ift_iff_flag < 0)
	return(err_logo(NO_TEST,NIL));
    else if (ift_iff_flag == 0)
	return(lrun(args));
    else
	return(NIL);
}

void prepare_to_exit(BOOLEAN okay)
{
#ifdef mac
    if (okay) {
	console_options.pause_atexit = 0;
	exit(0);
    }
#endif
#ifdef ibm
    exit_program();
    ltextscreen();
    ibm_plain_mode();
#endif
#ifdef unix
    extern int getpid();
    char ef[30];

    charmode_off();
    sprintf(ef, "/tmp/logo%d", getpid());
    unlink(ef);
#endif
}

NODE *lbye()
{
    prepare_to_exit(TRUE);
//    if (ufun != NIL || loadstream != stdin) exit(0);
//    if (isatty(0) && isatty(1)) lcleartext();
//    printf("Thank you for using Logo.\n");
//    printf("Have a nice day.\n");
    return(UNBOUND);
}

NODE *ltime(void) /*routine*/
/* LOGO time */
   {
   NODE *arg, *val = UNBOUND;
   char *Xtim;
   time_t tvec;
   
   time(&tvec);
   Xtim = ctime(&tvec);

   arg = make_strnode(Xtim, NULL, strlen(Xtim)-1, STRING, strnzcpy);
   val = parser(arg, FALSE);
   return(val);

//   return(make_strnode(Xtim, NULL, strlen(Xtim), STRING, strnzcpy));
//   return(make_static_strnode(Xtim));
   }

NODE *lwait(NODE *args)
{
    NODE *num;
    unsigned int n;
//    long itim;
    clock_t NumTicksToWait;

    num = pos_int_arg(args);
    if (NOT_THROWING) {
//	fflush(stdout); /* csls v. 1 p. 7 */
#ifdef __ZTC__
	zflush();
#endif
	if (getint(num) > 0) {
#ifdef bsd
#ifdef ultrix
	    n = (unsigned int)getint(num) / 60;
	    sleep(n);
#else
	    n = (unsigned int)getint(num) * 16667;
	    usleep(n);
#endif
#else
   NumTicksToWait = (((unsigned int)getint(num)*CLK_TCK) / 60) + clock();
   while (NumTicksToWait > clock()) MyMessageScan();
#endif
	}
    }
    return(UNBOUND);
}

NODE *lshell(NODE *args)
{
#ifdef mac
    printf("Sorry, no shell on the Mac.\n");
    return(UNBOUND);
#else
#ifdef ibm
    NODE *arg;
    char in[5][40] = { "\0", "\0", "\0", "\0", "\0" };
    int count = 0;

    arg = car(args);
    while (!is_list(arg) && NOT_THROWING) {
	setcar(args, err_logo(BAD_DATA, arg));
	arg = car(args);
    }
    if (arg == NIL) {
	ndprintf(stdout,"Type EXIT to return to Logo.\n");
	if (1
//spawnlp(P_WAIT, "command", "command", NULL)
)
	    err_logo(FILE_ERROR,
	      make_static_strnode
		 ("Could not open shell (probably due to low memory)"));
    }
    else {
	print_stringlen = 39;
	while (arg != NIL && count < 5) {
	    print_stringptr = in[count++];
	    ndprintf((FILE *)NULL,"%s",car(arg));
	    *print_stringptr = '\0';
	    arg = cdr(arg);
	}
	if (1
//spawnlp(P_WAIT, in[0], in[0], in[1], in[2], in[3], in[4], NULL)
)
	    err_logo(FILE_ERROR,
	      make_static_strnode
		 ("Could not open shell (probably due to low memory)"));
    }
    return(UNBOUND);
#else
    extern FILE *popen();
    char cmdbuf[MAX_BUFFER_SIZE];
    FILE *strm;
    NODE *head = NIL, *tail, *this;
    BOOLEAN wordmode = FALSE;
    int len;

    if (cdr(args) != NIL) wordmode = TRUE;
    print_stringptr = cmdbuf;
    print_stringlen = MAX_BUFFER_SIZE;
    ndprintf((FILE *)NULL,"%p\n",car(args));
    *print_stringptr = '\0';
    strm = popen(cmdbuf,"r");
    fgets(cmdbuf,MAX_BUFFER_SIZE,strm);
    while (!feof(strm)) {
	len = (int)strlen(cmdbuf);
	if (cmdbuf[len-1] == '\n')
	    cmdbuf[--len] = '\0';
	if (wordmode)
	    this = make_strnode(cmdbuf, (char *)NULL, len,
			STRING, strnzcpy);
	else
	    this = parser(make_static_strnode(cmdbuf), FALSE);
	if (head == NIL) {
	    tail = head = cons(this,NIL);
	    ref(head);
	} else {
	    setcdr(tail, cons(this,NIL));
	    tail = cdr(tail);
	}
	fgets(cmdbuf,MAX_BUFFER_SIZE,strm);
    }
    pclose(strm);
    return(unref(head));
#endif
#endif
}
