#include "allwind.h"

int ComId = -1;

NODE *lmouseon(NODE *args)
   {
   char lbuttondown[MAX_BUFFER_SIZE];
   char lbuttonup[MAX_BUFFER_SIZE];
   char rbuttondown[MAX_BUFFER_SIZE];
   char rbuttonup[MAX_BUFFER_SIZE];
   char mousemove[MAX_BUFFER_SIZE];
   
   // get args
   
   cnv_strnode_string(lbuttondown, args);
   cnv_strnode_string(lbuttonup, args=cdr(args));
   cnv_strnode_string(rbuttondown, args=cdr(args));
   cnv_strnode_string(rbuttonup, args=cdr(args));
   cnv_strnode_string(mousemove, args=cdr(args));
   
   // most of mouse code is in DEFWNDPROC when this flag is on
   
   mouse_on = 1;
   
   if (mouse_lbuttondown == NULL)
     {
     mouse_lbuttondown = (char *)malloc(MAX_BUFFER_SIZE);
     mouse_lbuttonup   = (char *)malloc(MAX_BUFFER_SIZE);
     mouse_rbuttondown = (char *)malloc(MAX_BUFFER_SIZE);
     mouse_rbuttonup   = (char *)malloc(MAX_BUFFER_SIZE);
     mouse_mousemove   = (char *)malloc(MAX_BUFFER_SIZE);
     }

   // these really should be NODEs but not yet
   
   strcpy(mouse_lbuttondown,lbuttondown);
   strcpy(mouse_lbuttonup,lbuttonup);
   strcpy(mouse_rbuttondown,rbuttondown);
   strcpy(mouse_rbuttonup,rbuttonup);
   strcpy(mouse_mousemove,mousemove);
   
   return (UNBOUND);
   }

NODE *lmouseoff(void)
   {

   // tell handler not to do anything with messages for mouse

   mouse_on = 0;
   
   return (UNBOUND);
   }

NODE *lkeyboardon(NODE *args)
   {
   char keyboarddown[MAX_BUFFER_SIZE];
   char keyboardup[MAX_BUFFER_SIZE];
   
   if (keyboard_keyup == NULL)
     {
     keyboard_keyup = (char *)malloc(MAX_BUFFER_SIZE);
     keyboard_keydown = (char *)malloc(MAX_BUFFER_SIZE);
     }

   // get args
   
   if (cdr(args) == NIL)
      {
      cnv_strnode_string(keyboardup, args);
      
      // most keyboard processing is done in DEFWNDPROC
      
      keyboard_on = 1;
      
      strcpy(keyboard_keyup,keyboardup);
      }
   else
      {
      
      cnv_strnode_string(keyboarddown, args);
      cnv_strnode_string(keyboardup, cdr(args));
      
      // most keyboard processing is done in DEFWNDPROC
      
      keyboard_on = 2;
      
      strcpy(keyboard_keydown,keyboarddown);
      strcpy(keyboard_keyup,keyboardup);
      }
   
   return (UNBOUND);
   }

NODE *lkeyboardoff(void)
   {

   // tell handler not to do anything with messages for keyboard

   keyboard_on = 0;
   
   return (UNBOUND);
   }

NODE *lmousepos()
   {

   // return current mouse position

   return(
   cons(make_intnode( mouse_posx+((TMyWindow *)MainWindowx)->Scroller->XPos*the_zoom-xoffset),
   cons(make_intnode(-(mouse_posy+((TMyWindow *)MainWindowx)->Scroller->YPos*the_zoom-yoffset)), NIL))
   );
   }

NODE *lkeyboardvalue()
   {

   // return current keyboard value

   return(make_intnode(keyboard_value));
   }

int min(int a, int b)
   {
   if (a < b) return (a); else return(b);
   }

NODE *lportclose(void)
   {
   
   // if port closed output error else close it

   if (ComId < 0)
      {
      MessageBox(CmdHWindow, "Could not CLOSE port", "Error", MB_OK);
      }
   else
      {
      CloseComm(ComId);
      ComId = -1;
      }
   
   return (UNBOUND);
   }

NODE *lportopen(NODE *args)
   {
   char comport[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(comport, args);
   
   // if port open output error else open it

   if (ComId >= 0)
      {
      MessageBox(CmdHWindow, "PORT already open", "Error", MB_OK);
      }
   else
      {
      
      ComId = OpenComm(comport, 1024, 1024);
      
      if (ComId < 0)
         {
         MessageBox(CmdHWindow, "Could not open PORT", "Error", MB_OK);
         }
      }   
   
   return (UNBOUND);
   }

NODE *lportflush(NODE *args)
   {
   
   int que;
   int err;
   
   que = getint(pos_int_arg(args));
   
   if (ComId < 0)
      {
      MessageBox(CmdHWindow, "PORT not open", "Error", MB_OK);
      }
   else
      {
      err = FlushComm(ComId,que);
      
      if (err < 0)
         {
         MessageBox(CmdHWindow, "Could not flush PORT", "Error", MB_OK);
         }
      
      }
   
   return (UNBOUND);
   }

NODE *lportmode(NODE *args)
   {
   char commode[MAX_BUFFER_SIZE];
   
   DCB dcb;
   
   int err;
   
   cnv_strnode_string(commode, args);
   
   // if closed output error else set mode

   if (ComId < 0)
      {
      MessageBox(CmdHWindow, "PORT not open", "Error", MB_OK);
      }
   else
      {
      
      // build dcb, if no error continue

      err = BuildCommDCB(commode, &dcb);
      
      if (err < 0)
         {
         MessageBox(CmdHWindow, "Could not build dcb on PORT", "Error", MB_OK);
         }
      else
         {
         // now set Id in dcb and set the state

         dcb.Id = ComId;
         
         err = SetCommState(&dcb);
         
         if (err < 0)
            {
            MessageBox(CmdHWindow, "Could not set PORT", "Error", MB_OK);
            }
         }   
      }
   
   return (UNBOUND);
   }

NODE *lportwritearray(NODE *args)
   {
   char txbuffer[MAX_BUFFER_SIZE]; 
   
   int i;
   int count;
   int status;  
   
   NODE *obj;
   NODE *val;
   NODE *item;
   
   val = pos_int_arg(args);
   obj = cadr(args);
   
   while ((obj == NIL || obj == Null_Word) && NOT_THROWING)
      {
      setcar(cdr(args), err_logo(BAD_DATA, obj));
      obj = cadr(args);
      }
   
   if (NOT_THROWING)
      {
      if (nodetype(obj) == ARRAY)
         {
         
         // if closed the error, else continue

         if (ComId < 0)
            {
            MessageBox(CmdHWindow, "PORT not open", "Error", MB_OK);
            }
         else
            {
            
            // get min of max array and the array

            count = min(min(getint(val),getarrdim(obj)),sizeof(txbuffer));
            
            // fill buffer with elements of the array

            for (i=0;i<count;i++)
               {
               item = litem(cons(make_intnode(i+getarrorg(obj)),cons(obj,NIL)));
               txbuffer[i] = getint(cnv_node_to_numnode(item));
               }
            
            // now write buffer

            status = WriteComm(ComId, txbuffer, count);
            
            // if problem GetComError will Put up Message box

            if (status < 0) GetCommError(ComId, NULL);
            
            // return byte count sent

            return(make_intnode(status));
            }   
         }
      else
         {
         MessageBox(CmdHWindow, "First arg must be an array", "Error", MB_OK);
         }
      }
   
   return(make_intnode(0));
   }

NODE *lportreadarray(NODE *args)
   {
   char rxbuffer[MAX_BUFFER_SIZE];
   
   int count;
   int i;
   
   NODE *val;
   NODE *obj;
   
   COMSTAT Stat;  
   
   val = pos_int_arg(args);
   obj = cadr(args);
   
   while ((obj == NIL || obj == Null_Word) && NOT_THROWING)
      {
      setcar(cdr(args), err_logo(BAD_DATA, obj));
      obj = cadr(args);
      }
   
   if (NOT_THROWING)
      {
      if (nodetype(obj) == ARRAY)
         {
         
         // if closed the error, else continue

         if (ComId < 0)
            {
            MessageBox(CmdHWindow, "PORT not open", "Error", MB_OK);
            }
         else
            {

            // get status on port (returns pending bytes)

            GetCommError(ComId, &Stat);
            
            // if something pending continue

            if (Stat.cbInQue)
               {
               
               // don't overflow buffer

               count = min(min(min(getarrdim(obj),getint(val)),Stat.cbInQue), sizeof(rxbuffer));
               
               // do the read

               ReadComm(ComId, rxbuffer, count);
               
               // now fill in the array

               for (i=0;i<count;i++)
                  {
                  lsetitem(
                  cons(make_intnode(i+getarrorg(obj)),
                  cons(obj,
                  cons(make_intnode(rxbuffer[i]),
                  NIL))));
                  }
               
               // return actual transfered

               return(make_intnode(count));
               }
            else
               {
               return(make_intnode(0));
               }
            }
         }
      }   
   
   return(make_intnode(0));
   
   }

NODE *lportwritechar(NODE *args)
   {
   char txchar[1];  
   
   int status;   
   
   // get arg

   txchar[0] = getint(pos_int_arg(args));
   
   // if not open output error, else continue

   if (ComId < 0)
      {
      MessageBox(CmdHWindow, "PORT not open", "Error", MB_OK);
      }
   else
      {     

      // write the 1 byte

      status = WriteComm(ComId, txchar, 1);
      
      // if problem GetComError will Put up Message box

      if (status < 0) GetCommError(ComId, NULL);
      
      // return byte count sent

      return(make_intnode(status));
      }   
   
   return(make_intnode(0));
   }

NODE *lportreadchar(void)
   {
   char rxchar[1];
   
   COMSTAT Stat;
   
   // if closed output error, else continue

   if (ComId < 0)
      {
      MessageBox(CmdHWindow, "PORT not open", "Error", MB_OK);
      }
   else
      {
      // get status on port (returns pending bytes)

      GetCommError(ComId, &Stat);
      
      // if a byte the read it and return it

      if (Stat.cbInQue)
         {
         ReadComm(ComId, rxchar, min(1,Stat.cbInQue));
         
         return(make_intnode(rxchar[0]));
         }
      else
         {
         return(make_intnode(-1));
         }
      }   
   
   return(make_intnode(-1));
   }
