/*****************************************************************
Module name: Meter.C
Programmer : Jeffrey M. Richter.
*****************************************************************/

#include <windows.h>
#include <windowsx.h>

#include "meter.h"

extern const HINSTANCE _cdecl _hInstance;

char _szControlName[] = "Meter";

#define CBWNDEXTRA         (6)
#define GWW_PARTSINJOB     (0)
#define GWW_PARTSCOMPLETE  (2)
#define GWW_FONT           (4)

ATOM NEAR RegisterControlClass (HINSTANCE hInstance);
LRESULT CALLBACK MeterWndFn
         (HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

/******** Dynamic-Link Library Initialization Routines **********/

#pragma argsused
BOOL WINAPI LibMain (HINSTANCE hInstance, WORD wDataSeg,
   WORD wHeapSize, LPSTR lpszCmdLine) {
   BOOL fOk;
   if (wHeapSize != 0) UnlockData(0);  // Let data segment move
   fOk = (RegisterControlClass(hInstance) != NULL);
   return(fOk);   // return TRUE if initialization is successful
}

int WINAPI WEP (int nSystemExit) {
   switch (nSystemExit) {
      case WEP_SYSTEM_EXIT:   // System is shutting down.
         break;

      case WEP_FREE_DLL:      // Usage count is zero (0).
         break;
   }
   UnregisterClass(_szControlName, _hInstance);
   return(1);                 // WEP function successful.
}

ATOM NEAR RegisterControlClass (HINSTANCE hInstance) {
   WNDCLASS wc;
   wc.style         = CS_GLOBALCLASS | CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc   = MeterWndFn;
   wc.cbClsExtra    = 0;
   wc.cbWndExtra    = CBWNDEXTRA;
   wc.hInstance     = hInstance;
   wc.hIcon         = (HICON) NULL;
   wc.hCursor       = LoadCursor((HCURSOR) NULL, IDC_ARROW);
   wc.hbrBackground = (HBRUSH) NULL;
   wc.lpszMenuName  = NULL;
   wc.lpszClassName = _szControlName;
   return(RegisterClass(&wc));
}

LRESULT CALLBACK MeterWndFn
       (HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
   LRESULT lResult = 0;
   char szPercentage[10];
   RECT rcClient, rcPrcnt;
   PAINTSTRUCT ps;
   WORD wPartsInJob, wPartsComplete;
   HBRUSH hBrush;
   DWORD dwColor;
   HFONT hFont;

   switch (uMsg) {
      case WM_GETDLGCODE:
         lResult = DLGC_STATIC;
         break;

      case WM_SETFONT:
         SetWindowWord(hWnd, GWW_FONT, (HFONT) wParam);
         if (lParam) // Redraw the control immediately
            InvalidateRect(hWnd, NULL, FALSE);

         break;

      case WM_GETFONT:
         lResult = GetWindowWord(hWnd, GWW_FONT);
         break;

      case WM_ENABLE:
         InvalidateRect(hWnd, NULL, FALSE);
         break;

      case WM_CREATE:   // lParam == &CreateStruct
         SendMessage(hWnd, MM_SETPARTSINJOB, 100, 0l);
         SendMessage(hWnd, MM_SETPARTSCOMPLETE, 50, 0);
         break;

      case WM_PAINT:
         wPartsInJob = (WORD)
            SendMessage(hWnd, MM_GETPARTSINJOB,  0, 0l);
         wPartsComplete = (WORD)
            SendMessage(hWnd, MM_GETPARTSCOMPLETE, 0, 0l);

         if (wPartsInJob == 0) {
            wPartsInJob = 1;
            wPartsComplete = 0;
         }

         wsprintf(szPercentage, "%d%%",
            (100 * wPartsComplete) / wPartsInJob);

         BeginPaint(hWnd, &ps);
         hFont = GetWindowFont(hWnd);
         if (hFont != NULL)
            SelectObject(ps.hdc, hFont);

         // Set-up default foreground and background text colors.
         SetBkColor(ps.hdc, GetSysColor(COLOR_WINDOW));
         SetTextColor(ps.hdc, GetSysColor(COLOR_WINDOWTEXT));

         // Send WM_CTLCOLOR message to parent in case parent
         // want touse a different color in the Meter control.
         hBrush = FORWARD_WM_CTLCOLOR(GetParent(hWnd),
            ps.hdc, hWnd, CTLCOLOR_METER, SendMessage);

         // Always use brush returned by parent.
         SelectObject(ps.hdc, hBrush);

         // Invert the foreground and background colors.
         dwColor = GetBkColor(ps.hdc);
         SetBkColor(ps.hdc, SetTextColor(ps.hdc, dwColor));

         // Set rectangle coordinates to include only left
         // percentage of the window.
         GetClientRect(hWnd, &rcClient);
         SetRect(&rcPrcnt, 0, 0,
            (rcClient.right * wPartsComplete) / wPartsInJob,
            rcClient.bottom);

         // Output the percentage value in the window.
         // Function also paints left part of window.
         SetTextAlign(ps.hdc, TA_CENTER | TA_TOP);
         ExtTextOut(ps.hdc, rcClient.right / 2,
            (rcClient.bottom -
            HIWORD(GetTextExtent(ps.hdc, "X", 1))) / 2,
            ETO_OPAQUE | ETO_CLIPPED, &rcPrcnt,
            szPercentage, lstrlen(szPercentage), NULL);

         // Adjust rectangle so that it includes the remaining
         // percentage of the window.
         rcPrcnt.left = rcPrcnt.right;
         rcPrcnt.right = rcClient.right;

         // Invert the foreground and background colors.
         dwColor = GetBkColor(ps.hdc);
         SetBkColor(ps.hdc, SetTextColor(ps.hdc, dwColor));

         // Output the percentage value a second time.
         // Function also paints right part of window.
         ExtTextOut(ps.hdc, rcClient.right / 2,
            (rcClient.bottom -
            HIWORD(GetTextExtent(ps.hdc, "X", 1))) / 2,
            ETO_OPAQUE | ETO_CLIPPED, &rcPrcnt,
            szPercentage, lstrlen(szPercentage), NULL);

         EndPaint(hWnd, &ps);
         break;

      case MM_SETPARTSINJOB:
         SetWindowWord(hWnd, GWW_PARTSINJOB, wParam);
         InvalidateRect(hWnd, NULL, FALSE);
         UpdateWindow(hWnd);
         break;

      case MM_GETPARTSINJOB:
         lResult = (LONG) GetWindowWord(hWnd, GWW_PARTSINJOB);
         break;

      case MM_SETPARTSCOMPLETE:
         SetWindowWord(hWnd, GWW_PARTSCOMPLETE, wParam);
         InvalidateRect(hWnd, NULL, FALSE);
         UpdateWindow(hWnd);
         break;

      case MM_GETPARTSCOMPLETE:
         lResult = (LONG) GetWindowWord(hWnd, GWW_PARTSCOMPLETE);
         break;

      default:
         lResult = DefWindowProc(hWnd, uMsg, wParam, lParam);
         break;
   }
   return(lResult);
}
