/*****************************************************************
Module name: MeterDlg.C
Programmer : Jeffrey M. Richter.
*****************************************************************/

#include <windows.h>
#include <custcntl.h>

#include "cntl-de.h"

#include "meter.h"

extern const HINSTANCE _cdecl _hInstance;

extern char _szControlName[];

BOOL CALLBACK MeterDlgFn
         (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);


HGLOBAL WINAPI MeterInfo (void) {
   HGLOBAL hGlblCtlInfo = (HGLOBAL) NULL;

   hGlblCtlInfo =
      ControlInfo(0x0100, _szControlName, _szControlName);
   if (hGlblCtlInfo == NULL) return(hGlblCtlInfo);
   AddControlType(hGlblCtlInfo, 0, 40, 12,
      WS_BORDER | WS_CHILD, _szControlName);
   return(hGlblCtlInfo);

}

BOOL WINAPI MeterStyle (HWND hWnd, HGLOBAL hGlblCtlStyle,
         LPFNSTRTOID lpfnStrToId, LPFNIDTOSTR lpfnIdToStr) {
   return(ShowStyleDlg(_hInstance, MAKEINTRESOURCE(DLG_STYLEDLG),
      hWnd, (DLGPROC) MeterDlgFn, 0, hGlblCtlStyle,
      lpfnStrToId, lpfnIdToStr));
}

BOOL CALLBACK MeterDlgFn
         (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
   BOOL fResult = TRUE;
   char szId[20];
   DWORD dwResult;

   switch (uMsg) {
      case WM_INITDIALOG:
         GetIdString(hDlg, szId, sizeof(szId));
         SetDlgItemText(hDlg, ID_VALUE, szId);
         break;

      case WM_COMMAND:
         switch (wParam) {
            case IDOK:
               GetDlgItemText(hDlg, ID_VALUE, szId, sizeof(szId));
               dwResult = SetIdValue(hDlg, szId);
               if (LOWORD(dwResult) == 0) break;
               // Fall through to IDCANCEL case

            case IDCANCEL:
               EndDialog(hDlg, wParam);
               break;

            case ID_VALUE:
               if (HIWORD(lParam) == EN_CHANGE)
                  EnableWindow(GetDlgItem(hDlg, IDOK),
                     SendMessage(LOWORD(lParam),
                         WM_GETTEXTLENGTH, 0, 0L) ? TRUE : FALSE);
               break;

            default: fResult = FALSE; break;
         }
         break;

      default: fResult = FALSE; break;
   }
   return(fResult);
}


#pragma argsused
WORD WINAPI MeterFlags
         (DWORD dwFlags, LPSTR szString, WORD wMaxString) {
   WORD x;
   *szString = 0;
   x = lstrlen(szString);
   if (x > 0) { x -= sizeof(" | ") - 1; *(szString + x) = 0; }
   return(x);
}
