/*****************************************************************
Module name: SetupPM.C
Programmer : Jeffrey M. Richter.
*****************************************************************/

#include <windows.h>
#include <dde.h>
#include <stdlib.h>
#include <string.h>
#include "Setup.h"
#include "SetupInf.h"

char _szClassName[] = "DDEClient";

typedef struct {
   HWND hWndServer;
} WNDEB;

#define WM_DDECLIENT_EXECUTE  (WM_USER + 0)

LPARAM CALLBACK DDEClientWndProc (HWND hWnd, UINT wMsg,
   WPARAM wParam, LPARAM lParam) {

   LRESULT lResult = 0;
   BOOL fCallDefProc = FALSE;
   HWND hWndServer = (HWND) GETWNDEB(hWnd, WNDEB, hWndServer);
   char szBuf[100]; MSG Msg;

   switch (wMsg) {

      case WM_CREATE:
         SendMessage(-1, WM_DDE_INITIATE, hWnd,
            (LONG) ((LPCREATESTRUCT) lParam)->lpCreateParams);

         if (GETWNDEB(hWnd, WNDEB, hWndServer) != NULL)
            break;


         // A conversation was not able to be established. 
         // Attempt to execute the desired application.
         GlobalGetAtomName(LOWORD(
            (LONG) ((LPCREATESTRUCT) lParam)->lpCreateParams),
            szBuf, sizeof(szBuf));
         WinExec(szBuf, SW_RESTORE);

         SendMessage(-1, WM_DDE_INITIATE, hWnd,
            (LONG) ((LPCREATESTRUCT) lParam)->lpCreateParams);

         if (GETWNDEB(hWnd, WNDEB, hWndServer) == NULL)
            lResult = -1;

         break;

      case WM_DESTROY:
         PostMessage(hWndServer, WM_DDE_TERMINATE, hWnd, 0);
         SETWNDEB(hWnd, WNDEB, hWndServer, NULL);
         // From now on, do not send a WM_DDE_ACK message to the 
         // server in response to any messages sent from the 
         // Server.
         break;

      case WM_DDE_DATA:
         if (hWndServer != (HWND) wParam) {
            // Conversation not initiated with this Server or
            // Server sent after we have terminated the 
            // conversation.
            if (HIWORD(lParam) != NULL) {
               // Data handle is not.  If it were NULL, a link 
               // was set using the WM_DDE_ADVISE message.
               GlobalFree(HIWORD(lParam));
            }
            GlobalDeleteAtom(LOWORD(lParam));
         }
         break;

      case WM_DDECLIENT_EXECUTE:
         // This message was sent to this window from the 
         // Setup Application.  The lParam parameter contains 
         // the handle of the memory containing the commands 
         // to be executed by the Server.

         // Verify that a conversation was started and 
         // hasn't been terminated.
         if (hWndServer == NULL) break;

         PostMessage(hWndServer, WM_DDE_EXECUTE, hWnd, lParam);

         // Wait for response from the Server.
         GetMessage(&Msg, hWnd, WM_DDE_ACK, WM_DDE_ACK);

         // Return whether the command was 
         // acknowledged successfully.
         wParam = LOWORD(Msg.lParam);
         lResult = ((DDEACK *) &wParam)->fAck;
         break;

      case WM_DDE_TERMINATE:
         if (hWndServer == NULL) break;
         // The Server has terminated the conversation with us.
         // We must post the WM_DDE_TERMINATE message back to 
         // the server.
         PostMessage(hWndServer, WM_DDE_TERMINATE, hWnd, 0);
         SETWNDEB(hWnd, WNDEB, hWndServer, (HWND) NULL);
         break;

      case WM_DDE_ACK:
         if (hWndServer == NULL) {
            // No conversation initiated, WM_DDE_ACK must be from 
            // a potential server that just received my 
            // WM_DDE_INITIATE message.
            SETWNDEB(hWnd, WNDEB, hWndServer, (HWND) wParam);
            break;
         }

         // WM_DDE_ACK message received from a potential Server 
         // but we have already established a conversation with 
         // another Server.  Tell the Server that we do not wish 
         // to continue our conversation with it. 
         PostMessage((HWND) wParam, WM_DDE_TERMINATE, hWnd, 0);
         break;

      default:
         fCallDefProc = TRUE;
      break;
   }

   if (fCallDefProc)
      lResult = DefWindowProc(hWnd, wMsg, wParam, lParam);

   return(lResult);
}


BOOL WINAPI RegisterDDEClient (HINSTANCE hInstance) {
   WNDCLASS wc;
   wc.style = 0;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = sizeof(WNDEB);
   wc.lpfnWndProc = DDEClientWndProc;
   wc.hInstance = hInstance;
   wc.hIcon = NULL;
   wc.hCursor = NULL;
   wc.hbrBackground = NULL;
   wc.lpszMenuName = NULL;
   wc.lpszClassName = _szClassName;
   return(RegisterClass(&wc));
}


// **** Functions for adding files to the Program Manager ********

BOOL WINAPI CreatePMInfo (HINSTANCE hInstance) {
   int nPMProg, nMaxPMProgs;
   UINT uTemp;
   BOOL fOk;
   char szPMGroup[_MAX_PATH], szPMGroupFileName[_MAX_PATH];
   char szPMProgPath[_MAX_PATH], szPMProgDesc[MAXPMDESC];
   char szCmd[200], szProgMan[] = "PROGMAN";
   HWND hWndDDEClient, hWndPM;
   ATOM aApp, aTopic;
   HGLOBAL hGlbl; LPSTR lpCommand;

   // Initiate a conversation with the Program Manager.
   aApp = GlobalAddAtom(szProgMan);
   aTopic = GlobalAddAtom(szProgMan);
   hWndDDEClient = CreateWindow("DDEClient", "", 0, 0, 0, 0, 0,
      NULL, NULL, hInstance, (LPSTR) MAKELONG(aApp, aTopic));
   GlobalDeleteAtom(aApp);
   GlobalDeleteAtom(aTopic);

   if (hWndDDEClient == NULL) {
      // Conversation could not be initiated.
      return(FALSE);
   }

   // Notice that I use the FindWindow function here.  I can not 
   // use the window handle of the DDE Server window because the 
   // Program Manager could acknowledge our DDE conversation by 
   // creating a "DDEServer" window.  
   hWndPM = FindWindow(szProgMan, NULL);
   if (!IsWindow(hWndPM))  // Program Manager cannot be found
      return(FALSE);

   // Force the Program Manager to open so that the user can 
   // see what group and applications we are adding.
   ShowWindow(hWndPM, SW_RESTORE);

   // Disable the Program Manager so that the user 
   // can't work with it while we are doing our stuff.
   EnableWindow(hWndPM, FALSE);

   // Create the PM Group box.
   _SetupInfo.GetPMGroupInfo(szPMGroupFileName, szPMGroup);
   wsprintf(szCmd, "[CreateGroup(%s%s%s)]",
      (LPSTR) szPMGroup,
      (LPSTR) (*szPMGroupFileName == 0 ? "" : ","),
      (LPSTR) szPMGroupFileName);

   hGlbl = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE,
      lstrlen(szCmd) + 1);
   lpCommand = GlobalLock(hGlbl);
   lstrcpy(lpCommand, szCmd);
   GlobalUnlock(hGlbl);

   fOk = (BOOL) SendMessage(hWndDDEClient,
      WM_DDECLIENT_EXECUTE, 0, MAKELONG(0, hGlbl));
   GlobalFree(hGlbl);

   // Add the individual PM files to the Group box.
   nMaxPMProgs = _SetupInfo.GetPMItemNum();
   for (nPMProg = 0; fOk && (nPMProg < nMaxPMProgs); nPMProg++) {
      uTemp = _SetupInfo.GetPMItemInfo(nPMProg,
         szPMProgDesc, szPMProgPath);
      if (uTemp == (UINT) -1) // File cannot be added to group
         continue;

      // Add the new file to the already created PM Group.
      // Syntax: AddItem(CmdLine, Name, IconPath, Icon Index,
      //                 xPos, yPos, DefDir, HotKey, fMinimize)
      wsprintf(szCmd, "[AddItem(%s,%s)]",
         szPMProgPath, szPMProgDesc, uTemp);
      hGlbl = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE,
         lstrlen(szCmd) + 1);
      lpCommand = GlobalLock(hGlbl);
      lstrcpy(lpCommand, szCmd);
      GlobalUnlock(hGlbl);

      fOk = (BOOL) SendMessage(hWndDDEClient,
         WM_DDECLIENT_EXECUTE, 0, MAKELONG(0, hGlbl));
      GlobalFree(hGlbl);
   }
   // Terminate the DDE conversation with the Program Manager.
   DestroyWindow(hWndDDEClient);
   EnableWindow(hWndPM, TRUE);
   return(fOk);
}
