#include "log.h"

void main()
{
	initmainnwcalls();
	initnwcalls();
	getconninfo(connNumber);
	outputinfo();
} //main


void initmainnwcalls()
//initialize the main 3 nwcalls
{ WORD nwrc;

	nwrc = (NWCallsInit(NULL, NULL));
	if (nwrc != 0x0000)
	  {  clrscr();
	     printf("\nNWCallsInit failed: %04x",nwrc);
	     printf("\nCheck to make sure your NIC card initilized.");
	     printf("\nMake sure you can see the login directory on the server.");
	     exit(1);
	  }

	nwrc = (NWGetDefaultConnectionID(&connHandle));
	if (nwrc != 0x0000)
	  {  printf("\nNWGetDefaultConnectionID failed: %04x",nwrc);
	     printf("\nYou have an invalid connection, try rebooting.");
	     exit(1);
	  }

	nwrc = (NWGetConnectionNumber(connHandle, &connNumber));
	if (nwrc != 0x0000)
	  {  printf("\nNWGetConnectionNumber failed: %04x",nwrc);
	     printf("\nInvalid connection number.");
	     printf("\nYou might have lost your link to the server, reboot.");
	     exit(1);
	  }
} //initmainnwcalls

void initnwcalls()
//initialize other nwcalls
{  WORD nwrc;

	nwrc = (NWGetInetAddr(connHandle, connNumber,(NWINET_ADDR NWFAR *)&inetAddr));
	if (nwrc != 0x0000)
	  {  printf("\nNWGetInetAddr failed: %04x",nwrc);
	     printf("\nInvalid network address.");
	     printf("\nLogin to the server again.");
	     exit(1);
	  }

} //initnwcalls

int getconninfo(int cnum)
//get connection information based on connection number and connhandle
{  WORD nwrc;

	nwrc = NWGetConnectionInformation(connHandle, cnum, (char FAR *)objname, (WORD FAR *)&objtype, (DWORD FAR *)&objID,
												(BYTE FAR *)logintime);
	if (nwrc != 0x0000)
	  {  //printf("\nNWGetConnectionInformation failed: %04x",nwrc);
	       return(1);
	  }

  return(0);
} //getconninfo

void outputinfo()
//output information gathered from function calls
{ FILE *outfile;

	if ((outfile = (fopen("logfile.dat","a+"))) == NULL)
	  {  printf("Error opening LOGFILE.DAT");
	     printf("Make sure you have sufficient rights to the file.");
	     exit(1);
	  }

	printf("\n%-10s on Conn. #%2d on %02d/%02d/%02d @ %02d:%02d:%02d     [%X%X%X%X]:[%X%X%X%X%X%X]\n",
	objname, connNumber, (int)logintime[1], (int)logintime[2],
	(int)logintime[0],(int)logintime[3],(int)logintime[4],(int)logintime[5],
	inetAddr.networkAddr[0],
	inetAddr.networkAddr[1],inetAddr.networkAddr[2],inetAddr.networkAddr[3],
	inetAddr.netNodeAddr[0],inetAddr.netNodeAddr[1],inetAddr.netNodeAddr[2],
	inetAddr.netNodeAddr[3],inetAddr.netNodeAddr[4],inetAddr.netNodeAddr[5]);

	fprintf(outfile,"\n%-10s on Conn. #%2d on %02d/%02d/%02d @ %02d:%02d:%02d     [%X%X%X%X]:[%X%X%X%X%X%X]",
	objname, connNumber, (int)logintime[1], (int)logintime[2],
	(int)logintime[0],(int)logintime[3],(int)logintime[4],(int)logintime[5],
	inetAddr.networkAddr[0],inetAddr.networkAddr[1],inetAddr.networkAddr[2],
	inetAddr.networkAddr[3],inetAddr.netNodeAddr[0],inetAddr.netNodeAddr[1],
	inetAddr.netNodeAddr[2],inetAddr.netNodeAddr[3],inetAddr.netNodeAddr[4],inetAddr.netNodeAddr[5]);

	fclose(outfile);

} //outputinfo
