  { SKELNUM:  Number scanning for skeleton files. }
  { Copyright (C) 1984 by QCAD Systems Inc., All Rights Reserved. }

  {****************}
  function PWR10(N:  int):  real;
    var P10: real;
        SIGN: boolean;
        PX: int;
  begin
    if n<0 then begin
      n := -n;
      sign := true;
    end
    else
      sign := false;
    p10 := 1.0;
    if n >= 38 then begin
      error('exponent too large -- 37 assumed');
      p10 := 1E37
    end
    else begin
      px := 0;
      while n>0 do begin
        if odd(n) then p10 := p10*pwr10_2[px];
        n := n div 2;
        px := px+1;
      end
    end;
    if sign then
      pwr10 := 1.0/p10
    else
      pwr10 := p10;
  end;

  {*****************}
  procedure GET_NUMBER;
    { Accepts an integer, decimal or real number. }
    var V1, V2: integer;
        RV: real;

    {...............}
    function GET_INTEGER:  integer;
      { interpret a non-null sequence of digits as an integer. }
      var V: integer;
    begin
      v := 0;
      while (ch>='0') and (ch<='9') do begin
        v := 10*v + ord(ch) - ord('0');
        nextch;
      end;
      get_integer := v
    end;

    {................}
    function GET_FRACTION:  real;
      var V, P:  real;
    begin
      v := 0;
      p := 0.1;
      while (ch>='0') and (ch<='9') do begin
        v := v+p*(ord(ch)-ord('0'));
        p := p/10.0;
        nextch;
      end;
      get_fraction := v;
    end;

    {.................}
    procedure GET_EXP;
      var EXPSIGN: boolean;
          EXP: int;
    begin
      nextch;  { get over e or E }
      expsign := false;
      if ch='+' then
        nextch
      else if ch='-' then begin
        expsign := true;
        nextch;
      end;
      if (ch>='0') and (ch<='9') then begin
        exp := get_integer;
        if expsign then
          rv := rv/pwr10(exp)
        else
          rv := rv*pwr10(exp);
      end
      else
        error('missing digit after E in exponent');
    end;

    {................}
    procedure FINISH_REAL;
      { return a real number as the result of the lexical scan. }
    begin
      token := real_tokx;
      with lsemp^ do begin
        semt := float;
        rval := rv;
      end
    end;

  begin { get_number }
    v1 := get_integer;
    if ch='.' then begin
      { real number }
      nextch;
      rv := v1 + get_fraction;
      if ch in ['e', 'E'] then get_exp;
      finish_real;
    end
    else if ch in ['e', 'E'] then begin
      { integer followed by exponent part }
      rv := v1;
      get_exp;
      finish_real;
    end
    else begin
      token := int_tokx;
      with lsemp^ do begin
        semt := fixed;
        numval := v1;
      end
    end
  end { get_number };

