/*-----------------------------------------
   FONTREFL.C -- Reflected Fonts
                 (c) Charles Petzold, 1994
  -----------------------------------------*/

#include <windows.h>
#include <string.h>
#include "ezfont.h"

#define TWO_PI (2 * 3.14159)

char szClass [] = "FontRefl" ;
char szTitle [] = "FontRefl: Rotated Fonts" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     static char szString [] = "Reflection" ;
     HFONT       hFont ;
     int         i ;
     XFORM       xform ;

     hFont = EzCreateFont (hdc, "Times New Roman", 540, 0, 0, TRUE) ;

     SelectObject (hdc, hFont) ;

     SetBkMode (hdc, TRANSPARENT) ;
     SetTextAlign (hdc, TA_BASELINE) ;
     SetGraphicsMode (hdc, GM_ADVANCED) ;

     for (i = 0 ; i < 4 ; i ++)
          {
          xform.eM11 = (FLOAT) (i > 1 ? -1 : 1) ;
          xform.eM12 = (FLOAT) 0 ;
          xform.eM21 = (FLOAT) 0 ;
          xform.eM22 = (FLOAT) (i & 1 ? -1 : 1) ;
          xform.eDx  = (FLOAT) (cxArea / 2) ;
          xform.eDy  = (FLOAT) (cyArea / 2) ;

          SetWorldTransform (hdc, &xform) ;

          TextOut (hdc, 0, 0, szString, strlen (szString)) ;
          }

     SelectObject (hdc, GetStockObject (SYSTEM_FONT)) ;
     DeleteObject (hFont) ;
     }
