/*+
    Name:	winmenu.h
    Date:	06-Jun-1988
    Author:	Kent J. Quirk
		(c) Copyright 1988 Ziff Communications Co.
    Abstract:	Contains header information for those using either
		HLWIN.C or HLMENU.C.
-*/    

typedef struct Window {
	char *scrnbuf;			/* old data below window */
	short bufsize;			/* size of the window data */
	struct rccoord oldcpos; 	/* previous cursor position */
	short r1, c1, r2, c2;		/* the corners */
	char attr;			/* the base attribute */
	char x; 			/* filler */
	struct rccoord cpos;		/* current cursor position */
} WINDOW;

WINDOW *open_window(short r1, short c1, short r2, short c2, char attr);
int close_window(WINDOW *w);
void activate_window(WINDOW *w);
void deactivate_window(WINDOW *w);
void fill_screen(FILE *f);
struct rccoord bios_getcur();
struct rccoord bios_setcur(short r, short c);

char *select_1_file(char *afn);

#define UP 0x148
#define LEFT 0x14B
#define RIGHT 0x14D
#define DOWN 0x150
#define BACKTAB 0x10F
#define TAB 0x09
#define DOIT 0x0D
#define ENTER 0x0D
#define ESC 0x1B
#define INS 0x152
#define DEL 0x153
#define HOME 0x147
#define END 0x14F
#define PGUP 0x149
#define PGDN 0x151
#define F10  0x144
#define UNDO 0x7F               /* control-Backspace */

int xgetch(void );
void draw_text(int row, int col, char *menu[], int nrows, int width);
WINDOW *draw_menu(char *menu[], char *toptitle, char *bottitle, 
		int nrows, int toprow, int leftcol, int maxlen);
int scroll_menu(char *menu[], char *toptitle, char *bottitle, 
		int toprow, int leftcol, int nrows, int allow_select);
int do_menu(char *menu[], char *toptitle, char *bottitle, int sel);
int edit_line(char *text, int len, int row, int col);
int pop_error(char *s);

/* user-supplied functions (required) */
void (*menu_init)();
void (*menu_exit)();
void (*menu_line)(char *text, int item);
