(*
**    File:    makeform.pas
**    Purpose: Create a new card file
**    Author:  (c) 1989 by Tom Swan. All rights reserved.
*)

program MakeForm;

uses Crt, Forms, Sliders, uNewType, uFormGen;

type  FnameString = string[65];     { File name string type }

const FORMFILE = 'TEST.DTA';        { Name for new file }

   
{---- Design a new data-entry form. }

{$F+}    { Turn on far-code generation. }
procedure newForm;
begin
   theForm.init( 9, 4, 71, 22 );
   theForm.add( new( FStrPtr,   
      init(  3,  3, ' Name   :', 30 ) ) );
   theForm.add( new( FIntPtr,   
      init(  3,  4, ' Age    :', 0, 999 ) ) );
   theForm.add( new( FYesNoPtr, 
      init(  3,  5, ' Single :' ) ) );
end; { newForm }
{$F-}    { Turn off "far" code generation. }


{---- Return True if file exists in current directory }

function fileExists( fname : FnameString ) : Boolean;
var
   f : File;
begin
   assign( f, fname );
   {$i-} reset( f ); {$i+}    { Try to open the file }
   if ioresult = 0 then
   begin
      fileExists := True;     { Return true if file open }
      close( f )              { Then, close the file }
   end else
      FileExists := False     { Return false if not open }
end; { FileExists }


{---- Main program }

begin
   if FileExists( FORMFILE )
   then
      writeln( FORMFILE, ' already exists' )
   else begin
      writeln( 'Creating new ', FORMFILE );
      MakeFile( NewForm, FORMFILE );
   end { else }
end. { MakeForm }
