/* Listing 4. Code file for tabexp class */

#include "tabexp.hpp"

tabexp::tabexp(FILE *fp, int ts)
/* The constructor for tabexp objects */
{
   init(fp, ts);
}

void tabexp::init(FILE *fp, int ts)
/* A method to initialize tabexp objects */
{
   f = fp;
   col = 0; tabsize = ts; tabcnt = 0;
}

int tabexp::get(void)
/* A method that gets a character from the input */
/* file, expanding tabs along the way            */
{
  int c;

  if (tabcnt) { /* currently expanding tab */
     tabcnt--; col++;
     c = ' ';
  }
  else c = fgetc(f);

  if (c == 0x09) { /* handle tabs */
     tabcnt = tabsize - (col % tabsize);
     return get();
  }
  else {
    if (c == '\n') col = 0; else col++;
  }
  return c;
}
