/* Listing 2. A more structured tab expansion program */

#include <stdio.h>

/* Wrap up global variables for tab expansion into a struct */

typedef struct {
  FILE *f;       /* input file stream              */
  int col;       /* current column of current line */
  int tabsize;   /* given tab size                 */
  int tabcnt;    /* amount of spaces left in tab   */
} tabexp;

void tabexp_init(tabexp *t, FILE *fp, int ts)
/* A function to initialize tabexp structs */
{
   t->f = fp;
   t->col = 0; t->tabsize = ts; t->tabcnt = 0;
}

int tabexp_get(tabexp *t)
/* Gets a character from the input file, */
/* expanding tabs along the way          */
{
  int c;

  if (t->tabcnt) {  /* currently expanding tab */
     t->tabcnt--; t->col++;
     c = ' ';
  }
  else c = fgetc(t->f);

  if (c == 0x09) { /* tab handler */
     t->tabcnt = t->tabsize - (t->col % t->tabsize);
     return tabexp_get(t);
  }
  else {
    if (c == '\n') t->col = 0; else t->col++;
  }
  return c;
}

main()
{
  int c;
  tabexp te;
  tabexp_init(&te, stdin, 8);  /* use stdin, tab size of 8 */

  do { /* loop until no more characters in input */
    c = tabexp_get(&te);
    if (c == -1) break; else putc(c, stdout);
  } while(1);
}
