/*   draw.h  -- Interactive drawing utilities
 */
void pencil(void);
void spraycan(void);
void drawlines(void);
void erase(void);
void drawcircle(void);
void mallocerror(void);

/*   The fill parameters, drawing colors, and so forth are all kept as global
 *   variables. From time to time the current drawing, fill, and line
 *   styles may be changed, so before using any drawing function make sure
 *   the various drawing parameters are reset to these global values.
 */
extern int globalfillstyle;  /* The fill style that should be used */
extern int globalfillcolor;  /* Holds the fill color that should be used */
extern int globaldrawcolor;  /* Holds the drawing color to use */
extern int globallinestyle;  /* Holds the line style that should be used */

extern int wl, wt, wr, wb;

#define ERASERSIZE 3         /* Half the size of the eraser */
#define SPRAYSIZE 15         /* Size of spray can spray area */
