/* CLONE.C -- Clone Directories with TDRF, by Tom Swan */

#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <string.h>

#define PATHLEN 65

const char *batchFile = "c:\\clone@@@.bat";
char originalPath[PATHLEN];
FILE *bf;        /* Batch file */

void readDirectory(void);
void preparePath(void);

main(int argc, char *argv[])
{
   int err = 0;

   if (getcwd(originalPath, PATHLEN) != NULL) {
      if (argc > 1) err = chdir(*++argv);
      if (!err) {
         if ((bf = fopen(batchFile, "wt")) == NULL) {
            fprintf(stderr, "Error creating batch file\n");
            return(1);
         }
         readDirectory();    /* Write commands to batch file */
         fclose(bf);         /* Close batch file before running */
         execl(getenv("COMSPEC"), argv[0], "/C", batchFile, NULL);
         remove(batchFile);  /* Erase the batch file */
         chdir(originalPath);
      } else {
         puts("Clone Directories with TDRF, by Tom Swan");
         puts("Syntax: CLONE [-?] [pathName]");
      }
   }
   return(0);   /* End program, no errors */
}

/*--- Walk through all paths from current directory */
void readDirectory()
{
   int done;
   struct ffblk sr;

   preparePath();
   done = findfirst("*.*", &sr, FA_DIREC);
   while (!done) {
      if ((sr.ff_name[0] != '.') &&
          (sr.ff_attrib & FA_DIREC)) {
         chdir(sr.ff_name);   /* Change to next level */
         readDirectory();     /* Process files there */
         chdir("..");         /* Return to previous level */
      }
      done = findnext(&sr);
   }
} /* readDirectory */

/*--- Write TDRF commands to batch file bf */
void preparePath()
{
   char *p;                /* Next backslash position */
   char fExpand[PATHLEN];  /* Full current path name  */
   char *plainPath;        /* Path without drive info */

   plainPath = getcwd(fExpand, PATHLEN) + 2;
   if (strcmp(plainPath, "\\") != 0) {
      p = plainPath;  /* Initialize search for backslashes */
      while ((p = strchr(++p, '\\')) != NULL) {
         *p = 0;      /* Cut off string at backslash */
         fprintf(bf, "tdrf md %s\n", plainPath);
         *p = '\\';   /* Replace backslash */
      }
      fprintf(bf, "tdrf md %s\n", plainPath);
      fprintf(bf, "tdrf del %s%s\n", plainPath, "\\*.*");
      fprintf(bf, "tdrf t %s%s%s\n", plainPath, "\\*.* ", plainPath);
   }
} /* preparePath */



