/**********************************************
     Monitor Saver For Microsoft Windows 3.0
 (c) Copyright 1990 By Moon Valley Software Inc.
***********************************************/

#include <windows.h>   /* Required for all Windows applications */
#include "ms.h"        /* Specific to this program */
#include <stdlib.h>    /* Needed for random */
#define TIMER_QSEC 1   /* Timer ID for 1/4 sec intervals */
#define TIMER_ICON 2   /* Timer for moving cursor on the screen */
#define T_SEC 250      /* 1/4 second interval timer */
#define MAXMINUTES 15  /* Default delay in minutes */

/********************
 Global Variables
********************/

HANDLE hInst;                  /* Current instance */
RECT winrect;                  /* Client area */
WNDCLASS  wc;                  /* Window class */
HCURSOR savcurs,actcurs;       /* Handle to cursor */
HWND hWnd,prevwnd;             /* Handles to windows */
HDC hDC;                       /* Handle to device context */
PAINTSTRUCT pc;                /* Paint client area */
int x=0,y=0,t_paint=0;         /* Window coordinates to paint */
                               /* Time and icon vars */
int maxmin=MAXMINUTES,minutes,restored=1,qsecs,isicon;
int xScreen, yScreen;          /* x and y window coordinates */
POINT oldpos,curpos;           /* Area of cursor location */
char szAppName[] = "Monitor Saver";

/* Forward Declarations */
long FAR PASCAL MainWndProc(HWND, unsigned, WORD, LONG);
BOOL InitApplication(HANDLE);
BOOL InitInstance(HANDLE, int);
BOOL FAR PASCAL About(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL Input(HWND, unsigned, WORD, LONG);
DWORD FAR PASCAL KeyHook(int, WORD, LONG);
FARPROC lpKeyHook, lpOldHook;

/******************************************************************
 FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)
 PURPOSE: calls initialization function, processes message loop
*******************************************************************/

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;        /* Current instance */
HANDLE hPrevInstance;    /* Previous instance */
LPSTR lpCmdLine;         /* Command line */
int nCmdShow;            /* Show window type Full or Iconic */

 {
   MSG msg;   /* Windows message  */
              /* Test for an existing instance */
              /* Only one instance is allowed  */
       if(hPrevInstance) {
        MessageBox(hWnd,"Monitor Saver Is Already Active!",
       szAppName,MB_ICONEXCLAMATION | MB_OK);
    return(FALSE);
}
     if (!hPrevInstance)
       if  (!InitApplication(hInstance)) /* Init shared resources   */
           return (FALSE);               /* Exit if unable to init  */
       /* Perform initialazations that apply to a specific instance */
       if (!InitInstance(hInstance, nCmdShow))
       return (FALSE);

    while (GetMessage(&msg, NULL, NULL, NULL)) {
           /* Dispatch messages until WM_QUIT is received */
           TranslateMessage(&msg);
           DispatchMessage(&msg);
   }

    return (msg.wParam);  /* Returns value from PostQuitMessage */
}

/******************************************************************
  FUNCTION: InitApplication(HANDLE)
  PURPOSE: Initialize window data and registers window class
******************************************************************/

BOOL InitApplication(hInstance)
HANDLE hInstance;                       /* Current instance */
{
   wc.style = NULL;                     /* Class style(s) */
   wc.lpfnWndProc = MainWndProc;        /* Func to receive msg's */
                                        /*  for this class */
   wc.cbClsExtra = 0;                   /* No per-class extra data */
   wc.cbWndExtra = 0;                   /* No per-window data */
   wc.hInstance = hInstance;            /* App that owns window class */
   wc.hIcon = LoadIcon(hInstance,"Ready"); /* Icon for when minimized */
   wc.hCursor = NULL;                      /* Cursor to use */
   wc.hbrBackground = GetStockObject(WHITE_BRUSH);  /* Bkground color */
   wc.lpszMenuName =  "MsMenu";          /* Menu name in rc file */
   wc.lpszClassName = szAppName;         /* Name used in call window */

   /* Register the windows class and return success/failure */
   return (RegisterClass(&wc));
}

/*******************************************************************
 FUNCTION:  InitInstance(HANDLE, int)
 PURPOSE:  Saves instance handle and creates main window
*******************************************************************/

BOOL InitInstance(hInstance, nCmdShow)
    HANDLE  hInstance;  /* Current instance */
    int     nCmdShow;   /* Param for first ShowWindow() call */
{
   HWND     hWnd;       /* Main win handle */
   hInst = hInstance;   /* Save the instance handle in a static var */
    xScreen = GetSystemMetrics(SM_CXSCREEN); /* Get current sys. info */
    yScreen = GetSystemMetrics(SM_CYSCREEN);
    /* Cursor to use when screen is blank */
    actcurs = LoadCursor(hInstance,"Active");
    hWnd = CreateWindow(     /* Create main win for this instance */
         szAppName,        /* Registered class */
        "Monitor Saver",     /* Caption Bar Text */
         WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX,
         CW_USEDEFAULT,       /* Initial x Pos */
         CW_USEDEFAULT,       /* Initial y Pos */
         165,                 /* Initial x size */
         37,                  /* Initial y size */
         NULL,                /* Overlapped have no parent win */
         NULL,                /* Use the window class menu */
         hInstance,           /* This instance owns the window */
         NULL);               /* Pointer not needed */

   if (!hWnd)                 /* If window could not be created */
      return (FALSE);         /* Fail */
                         /* Show window in minimized active state */
    ShowWindow(hWnd,SW_SHOWMINNOACTIVE);
    UpdateWindow(hWnd);  /* Sends WM_PAINT Message to window */
                         /* Only 16 timers total are permitted */
    while(!SetTimer(hWnd,TIMER_QSEC,T_SEC,NULL))
       if(IDCANCEL == MessageBox(hWnd,"Too Many Clocks Or Timers!",
          szAppName,MB_ICONEXCLAMATION | MB_RETRYCANCEL)) /* Error box */
    return(FALSE);                 /* Fail */

    lpKeyHook = MakeProcInstance((FARPROC)KeyHook,hInst);
    /* catch all keyboard messages: */
    lpOldHook = SetWindowsHook(WH_KEYBOARD,lpKeyHook);
     return (TRUE); /* Return value from PostQuitMessage */

}

/*******************************************************************
 FUNCTION: MainWndProc(HWND, unsigned, WORD, LONG)
 PURPOSE:  Processes messages
*******************************************************************/

long FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{

  FARPROC lpProcAbout,lpProcInput;
  DWORD savcol;

  switch (message) {
    case WM_CREATE:
         winrect.right = xScreen;
         winrect.bottom = yScreen;
                                   /* Check win.ini for delay time */
         maxmin = GetProfileInt(szAppName,"delay",MAXMINUTES);
         break;

  case WM_COMMAND:
       switch(wParam) {

  case SET_TIMER:
       lpProcInput = MakeProcInstance(Input, hInst);
       DialogBox(hInst,"Input",hWnd,lpProcInput);
       FreeProcInstance(lpProcInput);
       break;

  case ABOUT:
       lpProcAbout = MakeProcInstance(About, hInst);
       DialogBox(hInst,"About",hWnd,lpProcAbout);
       FreeProcInstance(lpProcAbout);
       break;
       }
       break;

  case WM_KEYDOWN:
  case WM_SYSKEYDOWN:
  case WM_LBUTTONDOWN:
  case WM_RBUTTONDOWN:
       if(!restored) {
          hDC = GetWindowDC(hWnd); /* Get handle to the device context */
          FillRect(hDC,&winrect,GetStockObject(WHITE_BRUSH));
          ValidateRect(hWnd,NULL);
          ReleaseDC(hWnd,hDC);     /* Release the device context */

          if(isicon) {             /* If window was minimized */
             MoveWindow(hWnd, 0, 0, 165, 37,  1);
             ShowWindow(hWnd,SW_SHOWMINNOACTIVE);     /* Minimize it */
             SetClassWord(hWnd,GCW_HICON,LoadIcon(hInst,"Restore"));
             UpdateWindow(hWnd);

        } else {
            MoveWindow(hWnd, 0, 0, 165, 37, 1);
            ShowWindow(prevwnd, SW_SHOWMINNOACTIVE); /* Show window */
            UpdateWindow(hWnd);                      /* Update it */
        }
      SetCursor(savcurs);        /* Restore cursor */
      restored = 1;              /* Show the screen as being restored */
      KillTimer(hWnd,TIMER_ICON);/* Re-set movement timer */
      minutes = qsecs = 0;
      SetActiveWindow(prevwnd);  /* Restore previous window */
      ShowWindow(hWnd,SW_HIDE);  /* Return focus to last App */
      /* Redisplay window from hidden: */
      ShowWindow(hWnd,SW_SHOWMINNOACTIVE);
      UpdateWindow(hWnd);        /* Update the window */
   }
   return (DefWindowProc(hWnd, message, wParam, lParam));

  case WM_TIMER:
       switch(wParam) {

  case TIMER_QSEC:
       GetCursorPos(&curpos);
        if(curpos.x == oldpos.x && curpos.y == oldpos.y) {
           qsecs++;         /* If cursor's not moved, add to counter */
        if(qsecs >= 240) {  /* If counter is more then 1 minute */
           minutes++;       /* Add one to minutes counter */
           qsecs = 0;
        }

 if(minutes >= maxmin) {             /* If minutes >= timeout limit? */
   if((curpos.x == oldpos.x && curpos.y == oldpos.y) && restored) {
     if((isicon = IsIconic(hWnd)))   /* Is it an icon? */
         OpenIcon(hWnd);             /* Restore icon */
         prevwnd = SetActiveWindow(hWnd);  /* Make this window active */
         MoveWindow(hWnd,0,0,9900,9900,1); /* Make screen blanker win*/
         hDC = GetWindowDC(hWnd);          /* Get device context */
                                 /* Fill the entire window with black */
         FillRect(hDC,&winrect,GetStockObject(BLACK_BRUSH));
         ValidateRect(hWnd,NULL);
         ReleaseDC(hWnd,hDC);
         savcurs = SetCursor(actcurs); /* Change cursor */
         restored = 0;   /* Display the screen as being blanked */
         /* Start 5 sec cursor timer: */
         SetTimer(hWnd,TIMER_ICON,5000,NULL);
         oldpos.x = curpos.x = x = 20 + (rand() % (winrect.right - 64));
         oldpos.y = curpos.y = y = 50 + (rand() % (winrect.bottom - 96));
         SetCursor(actcurs);      /* Change cursor to screen saver */
         SetCursorPos(x,y);       /* Draw cursor on screen */
         minutes = qsecs = 0;
         }
      }
  } else {
    if(!restored)
       SendMessage(hWnd,WM_RBUTTONDOWN,0,(DWORD)0);
       oldpos.x = curpos.x;
       oldpos.y = curpos.y;
       qsecs = minutes = 0;
       }
       break;


  case TIMER_ICON:   /* Timer to place cursor at random locations */
       if(!IsIconic(hWnd)) {  /* If not minimized ... */
          oldpos.x = curpos.x = x = 20 + (rand() % (winrect.right - 64));
          oldpos.y = curpos.y = y = 50 + (rand() % (winrect.bottom - 96));
          SetCursor(actcurs); /* Change cursor to screen saver */
          SetCursorPos(x,y);  /* Draw cursor on screen */
       }
     break;
   }
  break;

  case WM_DESTROY:
       KillTimer(hWnd,TIMER_QSEC);
       /* Be SURE to unhook the keyboard or Windows Will CRASH with the */
       UnhookWindowsHook(WH_KEYBOARD,lpKeyHook);  /* next keystroke! */
       PostQuitMessage(0);
       break;

       default:
       return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (0L);
}

/*****************
 The "About Box"
******************/

BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
int i;

switch (message) {
  case WM_INITDIALOG:
       return (TRUE);

  case WM_COMMAND:
       if (wParam == OK_BUT) {
           EndDialog(hDlg, TRUE);
           return (TRUE);
           }
           break;
      }
           return (FALSE);
}

/**********************************************
  Get Input From User To Adjust Delay Time.
***********************************************/

BOOL FAR PASCAL Input(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
int i;

switch (message) {
  case WM_INITDIALOG:
       SetFocus(hDlg);
       /* Place delay time minute field: */
       SetDlgItemInt(hDlg,E_TEXT,maxmin,0);
       return (TRUE);

 case WM_COMMAND:
      if (wParam == OK_BUT
          || wParam == CANCEL) {

      if(wParam == OK_BUT) {
         /* Get new delay value: */
         maxmin = GetDlgItemInt(hDlg,E_TEXT,&i,0);
         maxmin = (maxmin > 0)? maxmin : 1;
         }
         EndDialog(hDlg, TRUE);
         return (TRUE);
         }
       break;
     }
      return (FALSE);
}

/********************************************************************
FUNCTION: KeyHook
PURPOSE:  Captures keyboard messages to insure screen will not blank
          prematurely
*********************************************************************/

DWORD FAR PASCAL KeyHook(iCode,wParam,lParam)
int iCode;
WORD wParam;
LONG lParam;
{
   if(iCode == HC_ACTION)
      /* If this is negative reset counter to zero: */
      if(HIWORD(lParam) & 0x8000)
         qsecs = minutes = 0;      /* Reset counters to 0 */

   /* Make sure to return this value! */
   return DefHookProc(iCode,wParam,lParam, &lpOldHook);
}

