; SysReqFF -- Michael A. Covington 1988
;
; Makes the Sys Req key formfeed the printer.
; Has no effect on computers without a Sys Req key.
;
; Assemble this file with the following commands:
;   C> TASM SYSREQFF.ASM SYSREQFF.OBJ
;   C> TLINK SYSREQFF.OBJ /T
; The /T is important -- you're creating a .COM file.

FORMFEED       EQU  0CH
CR             EQU  0DH
LF             EQU  0AH

;; Code segment -----------------------------------------------

               .MODEL TINY
               .CODE
               ORG  100H

MAIN           PROC FAR
               JMP  INSTALL     ; don't execute it, install it!

;; Data area used by interrupt service routine ----------------

OLD_ISR        DD   0         ; to hold address of pre-existing
                           ; service routine for this interrupt

;; Interrupt service routine ----------------------------------

ISR            PROC FAR
               STI                       ; re-enable interrupts

               CMP  AX,8500H                 ; Sys Req pressed?
               JE   PRINT_FF            ; yes, print a formfeed
               JMP  CS:OLD_ISR   ; no, use pre-existing routine

PRINT_FF:      MOV  AL,FORMFEED
               MOV  AH,0                     ; print char in AL
               MOV  DX,0                             ; on LPT1:
               INT  17H                    ; using BIOS service

               IRET                                  ; all done

BAIL_OUT:      JMP  CS:OLD_ISR
ISR            ENDP

END_OF_ISR     EQU  $-MAIN+100H      ; where resident code ends
                                     ; (Assembler does not know
                                     ; about loading and has to
                                     ; be reminded of 100h org)

;; Instructions to install the interrupt service routine ------

INSTALL:       ;;  Copy the current INT 15H vector into OLD_ISR

               MOV  BX,OFFSET OLD_ISR       ; where to store it
               MOV  AX,0
               MOV  ES,AX                ; it's in segment 0000
               MOV  AX,ES:[0054H]     ; first word at 0000:0054
               MOV  [BX],AX
               MOV  AX,ES:[0056H]    ; second word at 0000:0056
               MOV  [BX+2],AX

               ;; Ask DOS to install new routine

               MOV  AH,25H        ; install new service routine
               MOV  AL,15H                  ; for interrupt 15H
               MOV  DX,OFFSET ISR      ; here's what to install
               INT  21H

               ;; Display message

               MOV  AH,09H           ; DOS call: display string
               MOV  DX,OFFSET MESSAGE           ; what to print
               INT  21H

               ;; Deallocate this program's copy of environment
               ;            (Optional. Doing this saves memory,
               ;           but it prevents MAP and its kin from
               ;             showing the name of this program.)

               MOV  AX,CS:[002CH]       ; PSP:002C contains the
               MOV  ES,AX          ; segment address of the env
               MOV  AH,49H   ; DOS call: free a block of memory
               INT  21H

               ;; Compute number of paragraphs of memory needed

               MOV  DX,(OFFSET END_OF_ISR+15)/16

               ;; Terminate and stay resident

               MOV  AH,31H     ; DOS call: Term & Stay Resident
               MOV  AL,0                          ; return code
               INT  21H          ; (DX contains memory request)

MESSAGE DB 'SysReq key will advance paper in printer.',CR,LF,'$'

MAIN           ENDP
               END  MAIN

CODE           ENDS