Program Draw;

{ By Rick Gessner
  For PC TECHNIQUES June/July 1990 }

Uses CRT;

PROCEDURE DrawLines;

Type  Directions = (Left,Right,Up,Down);
      VidRec = Record
                 Ch : Char;
                 Atr: Byte;
               end;

Const
  Check : Array[Directions] of Set of 1..11 =
  ([2,3,5,7,8,9,11], {left} [2,4,6,7,8,9,10], {Right}
   [1,3,4,7,8,10,11],{up}   [1,5,6,7,9,10,11]); {Down}

  AllLineChars: Array[1..11] of Char =
  ('','','','','','','','','','','');
  DeltaX      : Array[Directions] of ShortInt = (-1,1,0,0);
  DeltaY      : Array[Directions] of Shortint = (0,0,-1,1);
  CharTable   : Array[Directions,0..15] of Byte =
  ((2,2,2,2,6,6,9,9,4,4,8,8,10,10,7,7),
   (2,2,2,2,5,9,5,9,3,8,3,8,11,7,11,7),
   (1,6,5,9,1,6,5,9,1,10,11,7,1,10,11,7),
   (1,4,3,8,1,10,11,7,1,4,3,8,1,10,11,7));

  UpArrow = 'H';    DnArrow = 'P';    ESC = #27;
  LArrow  = 'K';    RArrow  = 'M';


FUNCTION Valid_Char(Dir: Directions;
                    Row,Col: integer): Boolean;

Var VideoMem: Array[1..25,1..80]
              of VidRec absolute $B800:0;
    I       : Integer;

Begin
  Valid_Char:=True;
  For I:=1 to 11 do
    If (I in Check[Dir]) and
       (VideoMem[Row,Col].Ch=AllLineChars[I])
    then Exit;  {Jump out because we've found our char!}
  Valid_Char:=False;
end; {Valid Char}



Var  Row,Col,Index: Integer;
     Ch           : Char;
     Dir          : Directions;

Begin
  Repeat
    Row:=WhereY; Col:=WhereX;
    Ch:=Readkey; If Ch=Chr(0) then Ch:=Readkey;
    If Ch in [UpArrow,DnArrow,LArrow,RArrow] then
      Begin
        Index :=
        Ord(Valid_Char(Left, Row,  Col-1))+   {Check left}
        Ord(Valid_Char(Right,Row,  Col+1))*2+ {Check right}
        Ord(Valid_Char(Up,   Row-1,Col))*4+   {Check above}
        Ord(Valid_Char(Down, Row+1,Col))*8;   {Check below}
        Case Ch of
          UpArrow : Dir:=Up;
          DnArrow : Dir:=Down;
          LArrow  : Dir:=Left;
          RArrow  : Dir:=Right;
        end;
        Write(AllLineChars[CharTable[Dir,Index]]);
        Gotoxy(Col+DeltaX[Dir],Row+DeltaY[Dir]);
      end;
  Until Ch=ESC;
end; {DrawLines}



Begin { Main }
  ClrScr;
  Gotoxy(40,15);  {Arbitrary starting point}
  DrawLines;
end. {Draw}


