// This code declares the classes for three simple data types.
// The contents of a general purpose C header file should be
// enclosed in a macro #ifdef clause as shown here.
// This allows multiple inclusions without conflicts.

 #ifndef __TYPES_H
 #define __TYPES_H

 enum datatype{EMPTY, INT, LONG, STRING, DERIVED};
 class value{
  protected:
      char* namptr;
  public:
      value(); value(char* namestr); //constructor
      virtual ~value();      //destructor
      //return characteristics
      const char* name(){return namptr;};
      virtual int valid();
      virtual datatype type(); virtual const char* typename();
      //return value in different forms
      virtual int asint();
      virtual long aslong();
      virtual const char* asstring();};


 class ival:public value{
  protected:
      int data;
  public:
      ival(char* namestr, int val);
      datatype type(); const char* typename();
      int asint();
      long aslong();
      const char* asstring();};


 class lval:public value{
  protected:
      long data;
  public:
      lval(char* namestr, long val);
      datatype type(); const char* typename();
      int asint();
      long aslong();
      const char* asstring();};


 class sval:public value{
  protected:
      char* data;
  public:
      sval(char* namestr, char* val);
      ~sval(); //supplemental destructor
      datatype type(); const char* typename();
      int asint();
      long aslong();
      const char* asstring();};


 #endif
