{$X+}
program TVTerminal;

uses  ComIO, VTDlg, Dial, App, Drivers, MsgBox, Crt,
      Menus, Memory, Objects, Views;

const
  DialPrefix = 'ATDT';
  cMyBase           = 200;
  cmOpenLogFile     = cMyBase+1;
  cmLineSet         = cMyBase+2;
  cmTerminalSet     = cMyBase+3;
  cmSetLocalEcho    = cMyBase+4;
  cmDoManualDial    = cMyBase+5;
  cmDoHangUp        = cMyBase+6;

type
  TVTerm = object(TApplication)
    ComWindow: PComWindow;
    constructor Init;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Idle; virtual;
    procedure InitStatusLine; virtual;
    procedure InitMenuBar; virtual;
    procedure InitDeskTop; virtual;
  end;

constructor TVTerm.Init;
begin
  TApplication.Init;
  ComWindow:=New(PComWindow, Init);
  Desktop^.Insert(ComWindow);
end;

procedure TVTerm.InitStatusLine;
var R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('', kbF3, cmOpenLogFile,
      NewStatusKey('', kbF5, cmZoom,
      NewStatusKey('', kbAltX, cmQuit, nil)))),
    nil)));
end;

procedure TVTerm.InitMenuBar;
var R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile', hcNoContext, NewMenu(
      NewItem('~O~pen Log', 'F3', kbF3, cmOpenLogFile, hcNoContext,
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext, nil))),
    NewSubMenu('~P~hone', hcNoContext, NewMenu(
      NewItem('~H~ang up phone', 'Alt-H', kbAltH, cmDoHangUp, hcNoContext,
      NewItem('~D~ial', 'Alt-D', kbAltD, cmDoManualDial, hcNoContext, nil))),
    NewSubMenu('~S~etup', hcNoContext, NewMenu(
      NewItem('~L~ine Settings', 'Alt-L', kbAltL, cmLineSet, hcNoContext,
      NewItem('Local ~E~cho', '', 0, cmSetLocalEcho, hcNoContext, nil))),
    nil))))));
end;

procedure TVTerm.InitDeskTop;
var R: TRect;
begin
  GetExtent(R);
  Inc(R.A.Y);
  New(DeskTop, Init(R));
end;

procedure TVTerm.Idle;
var S : String;
begin
  TApplication.Idle;
  if ComAvail then
  begin
    S:='';
    while ComAvail do
    begin
      S:=S+Char(ComGet);
      if Length(S) = 255 then
      begin
        Write(ComWindow^.Win, S);
        S:='';
      end;
    end;
    Write(ComWindow^.Win, S);
  end;
end;

procedure TVTerm.HandleEvent(var Event: TEvent);
var
  Bounds: TRect;
  DialString: String;
begin
  TApplication.HandleEvent(Event);
  if Event.What = evCommand then
  begin
    case Event.Command of
      cmSetLocalEcho: ComWindow^.SetLocalEcho;
      cmLineSet: ComWindow^.SetLineDialog;
      cmDoHangUp: begin
        ComPutString('+++');
        Delay(1500);
        ComPutString('ATH0'^M);
      end;
      cmDoManualDial: begin
        DialString := GetPhoneNum;
        if DialString <> '' then
          ComPutString(DialPrefix+DialString+^M);
      end;
      cmOpenLogFile: ErrorDialog('currently NOT supported');
    else Exit;
    end;
    ClearEvent(Event);
  end;
end;

var VTerm: TVTerm;
begin
  VTerm.Init;
  VTerm.Run;
  VTerm.Done;
end.
