; ***

APPL_RAM        EQU     04F0h           ; starting BIOS ram address
RAM_SIZE        EQU     16              ; size of reserved area

LOG_TEXT        SEGMENT  WORD PUBLIC 'CODE'
              ASSUME        CS: LOG_TEXT
        public  _LogByte

; uses C calling convention as follows:
; void LogByte(char cByteToLog)

_LogByte        PROC    far
        push    bp
        mov     bp,sp

        push    ax              ; be polite and save all registers
        push    cx
        push    di
        push    si
        push    ds
        push    es

        std                     ; we're going to start at the back
                                ; and work to the front

        xor        ax,ax           ; set ES and DS to segment 0
        mov        ds,ax
        mov     es,ax

        mov     di, APPL_RAM
        add     di, RAM_SIZE-1  ; es:di -> last byte in RAM
        mov     si, di
        dec     si              ; ds:si -> next to last byte in RAM

        mov     cx, RAM_SIZE
        dec     cx

        rep     movsb           ; shift all bytes right one byte

        mov     al, [bp+6]      ; get byte (assumes large model)
        mov     [di], al        ; store it in first RAM location

        pop     es              ; restore registers as they were
        pop     ds
        pop     si
        pop     di
        pop     cx
        pop     ax
        pop     bp
        ret
_LogByte        endp
LOG_TEXT        ENDS
END
