                        ASSUME CS:_TEXT, DS:_TEXT, SS:_TEXT
_TEXT                   SEGMENT BYTE PUBLIC 'CODE'
                        ORG 0

ProgramStart:           jmp  ProgramSetup

BPB                     STRUC
OEM                     db   49h,42h,4Dh,20h,59h,55h,4Bh,21h
BytesPerSector          dw   512
SectorsPerCluster       db   1
ReservedSectors         dw   1
NumberOfFATs            db   2
NumberOfDirEntries      dw   224
TotalSectors            dw   2400
MediaDescriptor         db   0F9h
SectorsPerFAT           dw   7
SectorsPerTrack         dw   15
NumberOfHeads           dw   2
NumberOfHiddenSectors   dw   0
BPB                     ENDS

BIOS_Parameter_Block    BPB  <>

SkyAttribute            EQU  1Fh
CompanyAttribute        EQU  1Bh
OOPSAttribute           EQU  4Eh
MsgAttribute            EQU  4Fh
InstrucAttribute        EQU  4Bh
ShadowAttribute         EQU  0Bh

OOPS_Line1              db   'OOPS!'
OOPS_Line1_Row          EQU  6
OOPS_Line1_Col          EQU  37

OOPS_Line2              db   'You''ve accidentally left a data disk'
OOPS_Line2_Row          EQU  7
OOPS_Line2_Col          EQU  22

OOPS_Line3              db   'in diskette drive A: while booting.'
OOPS_Line3_Row          EQU  8
OOPS_Line3_Col          EQU  23

OOPS_Line4              db   'Please open the drive bay door!'
OOPS_Line4_Row          EQU  10
OOPS_Line4_Col          EQU  25

Company_Line1           db   'My Company, Inc.'
Company_Line1_Row       EQU  19
Company_Line1_Col       EQU  33

Company_Line2           db   'P.O. Box 100'
Company_Line2_Row       EQU  20
Company_Line2_Col       EQU  34

Company_Line3           db   'Mytown, USA 11111'
Company_Line3_Row       EQU  21
Company_Line3_Col       EQU  32

MonochromeMode   EQU    7


                 IDEAL                      ; allow SIZE operator

ProgramSetup:    sti
                 mov    ax,0                ; initialize...
                 mov    ss,ax               ; stack...
                 mov    sp,ax               ; registers

                 mov    ax,07C0h            ; trick to set...
                 push   ax                  ; CS & IP...
                 mov    ax,OFFSET CS_Loaded ; to appropriate...
                 push   ax                  ; values
                 retf
                                            ; set DS = CS
CS_Loaded:       mov    ax,cs
                 mov    ds,ax

Sky:             mov    ah,6                ; Init window
                 mov    al,0                ; Blank entire window
                 mov    bh,SkyAttribute     ; Attribute
                 mov    cx,0                ; Top, left = 0
                 mov    dh,18               ; bottom row
                 mov    dl,79               ; right column
                 int    10h                 ; video services

                 mov    bh,CompanyAttribute ; New attribute
                 mov    ch,19               ; top row
                 mov    dh,24               ; bottom row
                 int    10h                 ; video services

CheckDisplayMode:
                 mov    ah,0Fh              ; Get display mode
                 int    10h                 ; video services
                 cmp    al,MonochromeMode   ; if mono...
                 je     MonochromeOOPS      ; jump

ColorOOPS:       mov    ah,6                ; Init window
                 mov    al,0                ; Blank entire window
                 mov    bh,OOPSAttribute    ; Attribute
                 mov    ch,6                ; Top row
                 mov    cl,20               ; Left column
                 mov    dh,ch               ; bottom row
                 mov    dl,60               ; right column
                 int    10h                 ; video services

                 mov    bh,MsgAttribute     ; Attribute
                 mov    ch,7                ; Top row
                 mov    dh,9                ; Bottom row
                 int    10h                 ; video services

                 mov    bh,InstrucAttribute ; Attribute
                 mov    ch,10               ; Top row
                 mov    dh,ch               ; Bottom row
                 int    10h                 ; video services

                 mov    bh,ShadowAttribute  ; Attribute
                 mov    ch,7                ; Top row
                 mov    cl,61               ; Left column
                 mov    dh,10               ; Bottom row
                 mov    dl,62               ; Right column
                 int    10h                 ; video services

                 mov    ch,11               ; Top row
                 mov    cl,22               ; Left column
                 mov    dh,ch               ; Bottom row
                 mov    dl,62               ; Right column
                 int    10h                 ; video services

                 jmp    DisplayText


MonochromeOOPS:  mov    ah,6                ; Init window
                 mov    al,0                ; Blank entire window
                 mov    bh,070h             ; Black on white
                 mov    ch,6                ; Top row
                 mov    cl,20               ; Left column
                 mov    dh,10               ; bottom row
                 mov    dl,60               ; right column
                 int    10h                 ; video services

DisplayText:     mov    bp,OFFSET OOPS_Line1  ; Message
                 mov    cx,SIZE OOPS_Line1    ; byte count
                 mov    dh,OOPS_Line1_Row     ; row
                 mov    dl,OOPS_Line1_Col     ; column
                 call   PrintString           ; do it

                 mov    bp,OFFSET OOPS_Line2  ; Message
                 mov    cx,SIZE OOPS_Line2    ; byte count
                 mov    dh,OOPS_Line2_Row     ; row
                 mov    dl,OOPS_Line2_Col     ; column
                 call   PrintString           ; do it

                 mov    bp,OFFSET OOPS_Line3  ; Message
                 mov    cx,SIZE OOPS_Line3    ; byte count
                 mov    dh,OOPS_Line3_Row     ; row
                 mov    dl,OOPS_Line3_Col     ; column
                 call   PrintString           ; do it

                 mov    bp,OFFSET OOPS_Line4  ; Message
                 mov    cx,SIZE OOPS_Line4    ; byte count
                 mov    dh,OOPS_Line4_Row     ; row
                 mov    dl,OOPS_Line4_Col     ; column
                 call   PrintString           ; do it

                 mov    bp,OFFSET Company_Line1 ; Message
                 mov    cx,SIZE Company_Line1   ; byte count
                 mov    dh,Company_Line1_Row    ; row
                 mov    dl,Company_Line1_Col    ; column
                 call   PrintString             ; do it

                 mov    bp,OFFSET Company_Line2 ; Message
                 mov    cx,SIZE Company_Line2   ; byte count
                 mov    dh,Company_Line2_Row    ; row
                 mov    dl,Company_Line2_Col    ; column
                 call   PrintString             ; do it

                 mov    bp,OFFSET Company_Line3 ; Message
                 mov    cx,SIZE Company_Line3   ; byte count
                 mov    dh,Company_Line3_Row    ; row
                 mov    dl,Company_Line3_Col    ; column
                 call   PrintString             ; do it

SetCursorForReboot:
                 mov    ah,2                ; Set cursor
                 mov    bh,0                ; page 0
                 mov    dh,22               ; row
                 mov    dl,0                ; column
                 int    10h                 ; video services

Delay2Seconds:   mov    ah,0                ; Read the clock
                 int    1Ah                 ; timer services
                 add    dx,40               ; add about 2 seconds
                 mov    bx,dx               ; save in BX
CheckDelay:      int    1Ah                 ; check the time again
                 cmp    dx,bx               ; 2 seconds yet?
                 jne    CheckDelay          ; if not, try again

ProgramEnd:      int    25                  ; re-boot computer


                 MASM                       ; return from IDEAL

PrintString      PROC
;
;   Input
;       ds:bp = pointer to string to be printed
;       dh = row
;       dl = column
;       cx = length of string
;

SetCursor:       mov    ah,2                ; set cursor position
                 mov    bh,0                ; page 0
                 int    10h                 ; video services

WriteText:       mov    ah,14               ; write character
PrintNextChar:   mov    al,ds:[bp]          ; load char to write
                 int    10h                 ; video services
                 inc    bp                  ; next character
                 loop   PrintNextChar       ; do again

                 ret                        ; done
PrintString      ENDP

_TEXT            ENDS
                 END    ProgramStart
