;DRIVES.ASM
;(c) 1991 by Deborah L. Cooper
;
codesg  segment
        assume  cs:codesg
        org     100h            ;make this a COM program
start:  jmp     start_2         ;skip over data area

org_drive       db      0       ;current drive code
got_drive       db      0dh,0ah,'Valid drive: ','$' ;output message

;Get and save the current drive so we can restore it later on
start_2:
        mov     ah,19h          ;get default drive code
        int     21h             ;call dos
        mov     org_drive,al    ;save it (0=A, 1=B, ... )
;Now go through 1-26 possible drive codes and display the
;message when we find a valid disk drive
select: mov     ah,0eh          ;select drive function
        mov     dl,0            ;start with Drive A
        int     21h             ;call dos
;Use function 19h to see if drive actually exists
select_2:
        mov     ah,19h          ;get default disk drive
        int     21h             ;call dos
        cmp     dl,al           ;is it a valid drive?
        je      got_one         ;yes, show the message!
next_drive:
        inc     dl              ;no, prepare to test next one
        cmp     dl,27d          ;maximum 26 possible!
        jae     all_done        ;go if done now
        mov     ah,0eh          ;select drive function
        int     21h             ;call dos
        jmp     select_2        ;and go back to test it
got_one:
        push    dx              ;save our drive number
        mov     dx,offset got_drive ;point DX to message
        mov     ah,09h          ;display string function
        int     21h             ;call dos
;Show the message with drive letter
        pop     dx              ;recover test drive code
        push    dx              ;save on stack for a minute
        xchg    al,dl           ;put drive code in AL for printing
        add     al,41h          ;convert to ASCII letter
        mov     ah,0eh          ;display byte function
        int     10h             ;call bios
        pop     dx              ;recover our drive number
        jmp     next_drive      ;and go back
;Now restore our original drive and exit
all_done:
        mov     ah,0eh          ;select drive function
        mov     dl,org_drive    ;original drive code
        int     21h             ;call dos
        mov     ah,4ch          ;terminate program function
        int     21h             ;call dos
codesg  ends
        end     start           ;end of demo!
