#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define LONGBAR  33
#define SHORTBAR 32

void  postnet(char *),
      printbar(int);

void main(int argc, char *argv[]) {
/*-------------------------------------------------------------*/
/*  main function - syntax: Postnet zip_code LETTER|BUSINESS   */
/*-------------------------------------------------------------*/

if (argc < 3) {
  printf("Usage:  Envelope zip_code LETTER|BUSINESS\n");
  exit(1);
}

if (stricmp(argv[2], "LETTER") == 0)   // size of envelope parameter
  fprintf(stdprn, "\033*p1640x1200Y"); // initialize print position
else
  if (stricmp(argv[2], "BUSINESS") == 0)
    fprintf(stdprn, "\033*p1715x1200Y");
  else {
	printf("Usage:  Envelope zip_code LETTER|BUSINESS\n");
	exit(1);
	}

postnet(argv[1]);          // print the US PostNet barcode
fprintf(stdprn, "\033E");  // reset & form feed
}

void postnet(char *zip_code) {
/*  postnet - print US Postal Service PostNet barcode.  */
int checksum = 0,
    code[10] = {      // |-len-|--data---|
                184,  //  1 0 1 1 1 0 0 0\
                163,  //  1 0 1 0 0 0 1 1 \       len:
                165,  //  1 0 1 0 0 1 0 1   \     # of bars
                166,  //  1 0 1 0 0 1 1 0     \   in code
                169,  //  1 0 1 0 1 0 0 1       \
                170,  //  1 0 1 0 1 0 1 0        /
                172,  //  1 0 1 0 1 1 0 0      /  data bits:
                177,  //  1 0 1 1 0 0 0 1    /    0 = short bar
                178,  //  1 0 1 1 0 0 1 0  /      1 = long bar
                180}, //  1 0 1 1 0 1 0 0/
    i,
    len;

len = strlen(zip_code);

printbar(LONGBAR);               // start with LONGBAR

for (i = 0; i < len; i++)        // print each digit
  if (isdigit(zip_code[i])) {
    printbar(code[zip_code[i] - '0']);

    checksum = checksum + (zip_code[i] - '0');
  }

checksum %= 10;                  // get remainder
printbar(code[10 - checksum]);   // print checksum
printbar(LONGBAR);               // end with LONGBAR

}

void printbar(int code) {
/*  printbar() - print the bar(s) for a single code. */
int     i,
	len;

len = (code >> 5) & 0x07;

for (i = len - 1; i >= 0; i--)
  if ((code & (1 << i)) != 0) {     // if bit == 1, long bar
    fprintf(stdprn, "\033*c38a4b0P");    // draw rectangle 38x4 dots
    fprintf(stdprn, "\033*p-14Y");  // move 14 dots (Y) for next bar
    } else {                        // else, short bar
       fprintf(stdprn, "\033*p+21X");    // move 21 dots (X)
       fprintf(stdprn, "\033*c17a4b0P"); // draw rectangle 17x4 dots
       fprintf(stdprn, "\033*p-21x-14Y");// move back 21 dots (X) &
    }                                    // 14 dots (Y) for next bar
}
