/* RTC.H -- Symbols and function prototypes for RTCHDW.C */

#define PIC1data 0x20                   /* PIC 1 data register */
#define PIC1ctrl 0x21                /* PIC 1 control register */
#define PIC2data 0xa0                   /* PIC 2 data register */
#define PIC2ctrl 0xa1                /* PIC 2 control register */
#define EOI  0x20                  /* "End of Interrupt" value */
#define ALARMINT 0x4A           /* User Alarm Interrupt number */
#define RTCINT 0x70                           /* RTC interrupt */
#define CMOS_Control 0x70             /* CMOS RAM control port */
#define CMOS_Data 0x71                   /* CMOS RAM data port */
#define SRA 0x0a                          /* Status Register A */
#define SRB 0x0b                          /* Status Register B */
#define SRC 0x0c                          /* Status Register C */
#define SRD 0x0d                          /* Status Register D */

/* Status Register A flag masks */
#define UIP 0x80                         /* Update in Progress */

/* Status Register B flag masks */
#define SET     0x80                       /* Halt update flag */
#define PIE     0x40              /* Periodic Interrupt Enable */
#define AIE     0x20                 /* Alarm Interrupt Enable */
#define UIE     0x10          /* Update-ended Interrupt Enable */
#define SQWE    0x08                     /* Square Wave Enable */
#define DM      0x04                              /* Data Mode */
#define AMPM    0x02                           /* 24/12 Switch */
#define DSE     0x01                /* Daylight Savings Enable */

/* Status Register C flag masks */
#define IRQF    0x80                      /* Interrupt Request */
#define PF      0x40                     /* Periodic Interrupt */
#define AF      0x20                        /* Alarm Interrupt */
#define UF      0x10                 /* Update-ended Interrupt */

/* Status Register D flag masks */
#define VRT     0x80                       /* Valid RAM & Time */

/* Time structure used by SetAlarmInt */
struct RTCTIME {
    unsigned int Hour;
    unsigned int Min;
    unsigned int Sec;
    unsigned int Daylight;
};

int ReadCMOS (int Addr);
void WriteCMOS (int Loc, int Data);
void NewCMOSChecksum (void);
int SetPeriodicInt (int Freq, void far (*isr)());
int SetUpdateInt (void far (*isr)());
int SetAlarmInt (struct RTCTIME *Time, void far (*isr)());
void EnableRTCint (int Which);
void DisableRTCint (int Which);
void ResetRTCint (int Which);
void TimerOn (void);
void TimerOff (void);
