// WRITEPRO.C

#include <stdio.h>
#include <dos.h>
#include <stdlib.h>

#define RETURN_OK               0
#define RETURN_WRITE_PROTECT    1
#define RETURN_OTHER            2

char far buffer[10000];
char far *pbuf = buffer;

void main(void);

void main(void)
{
    union REGS      inregs, outregs;
    struct SREGS    segregs;
    int             retries = 0;
    int             rc = RETURN_OK;

    // Read logical sector 1
    inregs.h.ah = 0x00;             // Just clear it out
    inregs.h.al = 0x00;             // Disk drive A:
    inregs.x.cx = 0x01;             // Number of sectors to read
    inregs.x.dx = 0x01;             // Logical sector 1 (FAT)
    inregs.x.bx = FP_OFF(pbuf);     // Offset of buffer
    segregs.ds  = FP_SEG(pbuf);     // Segment address of buffer
    int86x(0x25, &inregs, &outregs, &segregs);

    // If the carry flag is set, then there was an error
    if (outregs.x.cflag) {
	rc = RETURN_OTHER;
    } else {
	// Write logical sector 1
	inregs.h.ah = 0x00;           // Just clear it out
	inregs.h.al = 0x00;           // Disk drive A:
	inregs.x.cx = 0x01;           // Number of sectors to write
	inregs.x.dx = 0x01;           // Logical sector 1 (FAT)
	inregs.x.bx = FP_OFF(pbuf);   // Offset of buffer
	segregs.ds  = FP_SEG(pbuf);   // Segment address of buffer
	int86x(0x26, &inregs, &outregs, &segregs);

	// If the carry flag is set, then there was an error
	if (outregs.x.cflag) {
	    // If ah = 3 then there was a write protect error
	    if (outregs.h.ah == 3) {
		rc = RETURN_WRITE_PROTECT;
	    } else {
		rc = RETURN_OTHER;
	    }
	}
    }
    exit(rc);
}