/* FD_FORMAT_TRACK - Format Diskette Track                              */

#include <stdio.h>
#include "diskette.h"

static struct fd_dprm _far new_dpt =    /* 1.2M diskette                */
{
  0xdf, 0x02, 0x25, 0x02, 0x0f, 0x1b, 0xff, 0x54, 0xf6, 0x0f, 0x08
};

static struct fd_afld _far af_table[15] =       /* 1.2M diskette        */
{
  { 0, 0, 1, 2 }, { 0, 0, 2, 2 }, { 0, 0, 3, 2 },
  { 0, 0, 4, 2 }, { 0, 0, 5, 2 }, { 0, 0, 6, 2 },
  { 0, 0, 7, 2 }, { 0, 0, 8, 2 }, { 0, 0, 9, 2 },
  { 0, 0, 10, 2 }, { 0, 0, 11, 2 }, { 0, 0, 12, 2 },
  { 0, 0, 13, 2 }, { 0, 0, 14, 2 }, { 0, 0, 15, 2 }
};

int main()
{
  struct fd_diskette disk;

  puts("\nCTEST_09 - Format Diskette Track\n");

  if (fd_open(&disk, 0) == TRUE)
  {
    if (fd_install_table(&disk, &new_dpt) == TRUE)
    {
      printf("New Diskette Parameters table installed\n");

      if (fd_format_track(&disk, 0, 0, af_table) == TRUE)
        printf("Track 0 side 0 formatted\n");
      else
        printf("Track 0 side 0 format failed\n");

      fd_remove_table(&disk);

      printf("Previous Diskette Parameters table restored\n");
    }
    else
      printf("Diskette Parameters table not installed\n");

    fd_close(&disk);
  }
  else
    printf("Drive A could not be opened\n");

  return (0);
}

