// DISKETTE::REMOVE_TABLE - Remove Custom Diskette Parameters Table

#include "diskette.hpp"
#include <iostream.h>

static fd_dprm _far new_dpt =   // 1.2M diskette
{
  0xdf, 0x02, 0x25, 0x02, 0x0f, 0x1b, 0xff, 0x54, 0xf6, 0x0f, 0x08
};

int main()
{
  Diskette drive_a(0);

  cout << "\nPTEST_03 - Remove Custom Diskette Parameters Table\n\n";

  if (drive_a.obj_status() == TRUE)
  {
    if (drive_a.install_table(&new_dpt) == TRUE)
      cout << "New Diskette Parameters table installed\n";
    else
      cout << "Diskette Parameters table not installed\n";

    drive_a.remove_table();

    cout << "Previous Diskette Parameters table restored\n";
  }
  else
    cout << "Drive A could not be opened\n";

  return (0);
}
