// DISKETTE::VERIFY_SECTORS - Verify Diskette Sectors

#include "diskette.hpp"
#include <iostream.h>

static fd_afld _far af_table[15] =      // 1.2M diskette
{
  { 0, 0, 1, 2 }, { 0, 0, 2, 2 }, { 0, 0, 3, 2 },
  { 0, 0, 4, 2 }, { 0, 0, 5, 2 }, { 0, 0, 6, 2 },
  { 0, 0, 7, 2 }, { 0, 0, 8, 2 }, { 0, 0, 9, 2 },
  { 0, 0, 10, 2 }, { 0, 0, 11, 2 }, { 0, 0, 12, 2 },
  { 0, 0, 13, 2 }, { 0, 0, 14, 2 }, { 0, 0, 15, 2 }
};

int main()
{
  Diskette drive_a(0);

  cout << "\nPTEST_08 - Verify Diskette Sectors\n\n";

  if (drive_a.obj_status() == TRUE)
  {
    if (drive_a.verify_sectors(15, 0, 1, 0, af_table) == TRUE)
      cout << "Sectors verified\n";
    else       
      cout << "Sectors failed verification\n";
  }
  else
    cout << "Drive A could not be opened\n";

  return (0);
}
