// DISKETTE::FORMAT_TRACK - Format Diskette Track

#include "diskette.hpp"
#include <iostream.h>

static fd_dprm _far new_dpt =   // 1.2M diskette
{
  0xdf, 0x02, 0x25, 0x02, 0x0f, 0x1b, 0xff, 0x54, 0xf6, 0x0f, 0x08
};

static fd_afld _far af_table[15] =      // 1.2M diskette
{
  { 0, 0, 1, 2 }, { 0, 0, 2, 2 }, { 0, 0, 3, 2 },
  { 0, 0, 4, 2 }, { 0, 0, 5, 2 }, { 0, 0, 6, 2 },
  { 0, 0, 7, 2 }, { 0, 0, 8, 2 }, { 0, 0, 9, 2 },
  { 0, 0, 10, 2 }, { 0, 0, 11, 2 }, { 0, 0, 12, 2 },
  { 0, 0, 13, 2 }, { 0, 0, 14, 2 }, { 0, 0, 15, 2 }
};

int main()
{
  Diskette drive_a(0);

  cout << "\nPTEST_09 - Format Diskette Track\n\n";

  if (drive_a.obj_status() == TRUE)
  {
    if (drive_a.install_table(&new_dpt) == TRUE)
    {
      cout << "New Diskette Parameters table installed\n";

      if (drive_a.format_track(0, 0, af_table) == TRUE)
        cout << "Track 0 side 0 formatted\n";
      else
        cout << "Track 0 side 0 format failed\n";

      drive_a.remove_table();

      cout << "Previous Diskette Parameters table restored\n";
    }
    else
      cout << "Diskette Parameters table not installed\n";
  }
  else
    cout << "Drive A could not be opened\n";

  return (0);
}

