/* MYCOMM.C - Bare-minimum serial communications program */
/* Michael A. Covington - 1992 - Turbo C for Windows     */

#include <windows.h>
#include <dos.h>
#include <stdio.h>
#include <conio.h>

/* Some declarations that should be in conio.h, but aren't: */
void        _Cdecl _DoneEasyWin(void);
extern char _Cdecl _WindowTitle[80];
extern BOOL _Cdecl _CheckBreak;

#define  portname  "COM1"
#define  exitkey   28       /* Ctrl-\ */

char  c = 0;
int   i, charsrecd;
char  inputdata[1024];

int     port;              /* Port identifier */
DCB     dcb;               /* Device control block */
COMSTAT comstat;           /* Comm status information */

main()
{
  strcpy(_WindowTitle,"Communications Program");
  _InitEasyWin();

  _CheckBreak = 0;  /* Treat Ctrl-C as ordinary character */

  port = OpenComm(portname,2000,10);
    /* Serial port with 2000-byte input queue */
    /*               and 10-byte output queue */
  if (port < 0)
  {
    puts("Could not open serial port");
    return(-1);
  }

  GetCommState(port,&dcb);
  dcb.BaudRate = 2400;
  dcb.ByteSize = 7;           /* or 8 */
  dcb.Parity   = EVENPARITY;  /* or ODDPARITY, NOPARITY, etc. */
  dcb.StopBits = ONESTOPBIT;  /* NOT the number 1 */
  SetCommState(&dcb);

  puts("Ready. Press Ctrl-\\ to exit...");
  putchar('_');               /* ersatz cursor */

  do
  {
     Yield();                 /* let other processes run */

     charsrecd = ReadComm(port,inputdata,sizeof(inputdata));

     if (charsrecd <= 0) {
	i = GetCommError(port,&comstat);
	if (i!=0) printf("<Error %d> ",i);
	  /* Error codes are documented in windows.h */
     }
     else {
	putchar('\b');        /* erase ersatz cursor */
	for (i=0; i<charsrecd; i++)
	   if (inputdata[i] != '\n') putchar(inputdata[i]);
	putchar('_');         /* create ersatz cursor */
     }

     if (kbhit()) {
	c = getch();
	if (c != exitkey) WriteComm(port,&c,1);
     }
  }
  while (c != exitkey);

  puts("\b\nExiting...");
  CloseComm(port);
  _DoneEasyWin();             /* close window */
  return(0);
}

